/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.common;

import javax.swing.table.TableCellEditor;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.ui.common.AbstractLimaTableModel;
import org.chorem.lima.ui.common.Column;
import org.chorem.lima.util.ErrorHelper;

public abstract class AbstractColumn<T extends AbstractLimaTableModel>
implements Column<T> {
    protected T tableModel;
    protected Class<?> columnClass;
    protected String columnName;
    protected boolean editable;
    protected TableCellEditor cellEditor;
    protected ErrorHelper errorHelper;

    public AbstractColumn(Class<?> columnClass, String columnName, boolean editable) {
        this.columnClass = columnClass;
        this.columnName = columnName;
        this.editable = editable;
        this.errorHelper = new ErrorHelper(LimaSwingConfig.getInstance());
    }

    @Override
    public Class<?> getColumnClass() {
        return this.columnClass;
    }

    @Override
    public void setTableModel(T tableModel) {
        this.tableModel = tableModel;
    }

    @Override
    public boolean isCellEditable(int row) {
        return this.editable;
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        return false;
    }

    public void setColumnClass(Class<?> columnClass) {
        this.columnClass = columnClass;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(TableCellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }
}

