package org.chorem.lima.ui.financialstatementchart;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.EnumEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.FinancialStatementWayEnum;
import org.chorem.lima.entity.FinancialStatement;
import org.chorem.lima.entity.FinancialStatementImpl;
import static org.nuiton.i18n.I18n.t;

public class FinancialStatementHeaderForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";
    public static final String PROPERTY_FINANCIAL_STATEMENT = "financialStatement";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESCRIPTION_TEXT_FIELD_TEXT = "descriptionTextField.text";
    public static final String BINDING_HEADER_AMOUNT_CHECK_BOX_SELECTED = "headerAmountCheckBox.selected";
    public static final String BINDING_SUB_AMOUNT_CHECK_BOX_SELECTED = "subAmountCheckBox.selected";
    public static final String BINDING_WAY_ENUM_EDITOR_SELECTED_ITEM = "wayEnumEditor.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVWz28bRRR+MXXSOCn9ERK1Ikgp9SER0rgHDohU/ZG0Jq0MlXClVvWF8e4knmZ2Z5l9SzZCIP4E/gS4c0Hixglx4MyBC+JfQIgDV8SbsXfXG68d48Nq9d773vvem3nf+rs/oR4buPmKpykzSYgyEOzJgxcvnvZfCQ8fitgzMkJtYPhbqEGtByt+bo8RbvU6Ft4awVv7Ooh0KMIx9G4HGjGeKhEPhECEt8oIL45b3dy9m0aJybLmpKqyfvP3X7Wv/a++rQGkEbFbpVa2zkMVnVzoQE36CNeo0me8pXh4RDSMDI+I7yVr21c8jj/igfgUvoSlDixG3FAyhLfnb9nlcPg0Qtg8lCEPPclVFzmKgDAHgvvCtLUJED7Q5oh5A21EwJQMOEskyxFxhvAG3CBrz8gURa7kIjU3WRBh52wZsko8rUhZJLrIfd+ZEa7a2TA7L7antRI8LMKWms94X4nbCNdLJxGf0FyZ89nI5RxwJbtMUocd3heKONv86QjyxBlt8LUc88YY5plIsS2FooPcKOFyRxnbaD7UXmJ7I443xhFIAJY5i46uxkn/QaCpj/2B8I73dIqwXqqU2c+QHLjjKEOtb6scd+mEnz4Kk+CRL+neIDQr5iacjxVh5RSLHh2bndxaiddegqjDcmhNH9u37ZHVwJulcrSKrFjFYlcWelA3CZnpXHuT2/sxuYZ7e/3M3tqEzvvvxtpvP/7xQztb1gbVXq8MHdMaWqLI6EgYlLb05eGmJihV60Me7fZgORaKhMoJ0WYFse7ITeSo3vDiWjg74PGAUtSXfv/p541Pfn0Nam1oKM39Nrfxj2EZB4amoJWfRvfuO0arJxfpecVyQ6jTxiga0S23QJNbxobHzw5pHVMazGbFYHJ2/eVf/lnrfn8/G84Ckb0xNbwYUP0lLMpQyVA4LRvJVKV2rUSxSHxdyFGVQME5ChWN1uK2e75bNZcLdo1I4qeNRdl1ThOLf891at/ehwohmL9Y8/MjgZPitb3DyO5ybe98UVWzUkjOq1sjMRxeO0Gisz2rdjeTDqqfs705bTS50FRRnZSh/8fznVk8D8akapxqc/blns62UvzmONDVjPBjKkTf2Vmkn/PTKcdaltT579GKa3coplV5Rzo7f8Ill1AfVyUjJZ4j0bovDnmicF/pWDwlJeT2riK8fsfnyLf6MvRJ6+9OFFiwz8YcBeqB9rn96N4ZCskWR/oP1E9QzEj6H4SeUIk4CgAA";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    private static final Log log = LogFactory.getLog(FinancialStatementHeaderForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean addState;
    protected JButton cancel;
    protected JLabel descriptionLabel;
    protected JTextField descriptionTextField;
    protected FinancialStatement financialStatement;
    protected FinancialStatementHeaderForm financialStatementHeaderForm = this;
    protected JCheckBox headerAmountCheckBox;
    protected JButton ok;
    protected JCheckBox subAmountCheckBox;
    protected EnumEditor wayEnumEditor;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Document $Document0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void getFinancialStatementWayValue(){
        
            FinancialStatementWayEnum fSWE =
                (FinancialStatementWayEnum) wayEnumEditor.getSelectedItem();
    
            if (fSWE == null){
                fSWE = FinancialStatementWayEnum.BOTH;
            }
            getFinancialStatement().setWay(fSWE);
        }
        protected void performCancel() {
            setFinancialStatement(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialStatementHeaderForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm() {
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__headerAmountCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setHeaderAmount(headerAmountCheckBox.isSelected());
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__subAmountCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setSubAmount(subAmountCheckBox.isSelected());
    }

    public void doActionPerformed__on__wayEnumEditor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatementWayValue();
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setLabel(getDescriptionTextField().getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setLabel(getDescriptionTextField().getText());
    }

    public void doWindowClosing__on__financialStatementHeaderForm(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAddState() {
        return addState;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JLabel getDescriptionLabel() {
        return descriptionLabel;
    }

    public JTextField getDescriptionTextField() {
        return descriptionTextField;
    }

    public FinancialStatement getFinancialStatement() {
        return financialStatement;
    }

    public JCheckBox getHeaderAmountCheckBox() {
        return headerAmountCheckBox;
    }

    public JButton getOk() {
        return ok;
    }

    public JCheckBox getSubAmountCheckBox() {
        return subAmountCheckBox;
    }

    public EnumEditor getWayEnumEditor() {
        return wayEnumEditor;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    public void setFinancialStatement(FinancialStatement financialStatement) {
        FinancialStatement oldValue = this.financialStatement;
        this.financialStatement = financialStatement;
        firePropertyChange(PROPERTY_FINANCIAL_STATEMENT, oldValue, financialStatement);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Document get$Document0() {
        return $Document0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFinancialStatementHeaderForm() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createDescriptionLabel() {
        $objectMap.put("descriptionLabel", descriptionLabel = new JLabel());
        
        descriptionLabel.setName("descriptionLabel");
        descriptionLabel.setText(t("lima.financialStatement.label"));
    }

    protected void createDescriptionTextField() {
        $objectMap.put("descriptionTextField", descriptionTextField = new JTextField());
        
        descriptionTextField.setName("descriptionTextField");
        descriptionTextField.setColumns(15);
    }

    protected void createFinancialStatement() {
        $objectMap.put("financialStatement", financialStatement = null);
    }

    protected void createHeaderAmountCheckBox() {
        $objectMap.put("headerAmountCheckBox", headerAmountCheckBox = new JCheckBox());
        
        headerAmountCheckBox.setName("headerAmountCheckBox");
        headerAmountCheckBox.setText(t("lima.financialStatement.headerAmount"));
        headerAmountCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__headerAmountCheckBox"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createSubAmountCheckBox() {
        $objectMap.put("subAmountCheckBox", subAmountCheckBox = new JCheckBox());
        
        subAmountCheckBox.setName("subAmountCheckBox");
        subAmountCheckBox.setText(t("lima.financialStatement.subAmount"));
        subAmountCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__subAmountCheckBox"));
    }

    protected void createWayEnumEditor() {
        $objectMap.put("wayEnumEditor", wayEnumEditor = new EnumEditor(org.chorem.lima.FinancialStatementWayEnum.class));
        
        wayEnumEditor.setName("wayEnumEditor");
        wayEnumEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__wayEnumEditor"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFinancialStatementHeaderForm();
        // inline complete setup of $Table0
        $Table0.add(descriptionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(subAmountCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(headerAmountCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(wayEnumEditor, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        // late initializer
        financialStatementHeaderForm.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("financialStatementHeaderForm", financialStatementHeaderForm);
        createFinancialStatement();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createDescriptionLabel();
        createDescriptionTextField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = getDescriptionTextField().getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        createSubAmountCheckBox();
        createHeaderAmountCheckBox();
        createWayEnumEditor();
        createCancel();
        createOk();
        // inline creation of financialStatementHeaderForm
        setName("financialStatementHeaderForm");
        setModal(true);
        setTitle(t("lima.financialStatement.header.form"));
        financialStatementHeaderForm.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__financialStatementHeaderForm"));
        
        getRootPane().setDefaultButton(ok);// registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DESCRIPTION_TEXT_FIELD_TEXT, true ,"financialStatement") {
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(descriptionTextField, getFinancialStatement().getLabel());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SUB_AMOUNT_CHECK_BOX_SELECTED, true ,"financialStatement") {
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    subAmountCheckBox.setSelected(getFinancialStatement().getSubAmount());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HEADER_AMOUNT_CHECK_BOX_SELECTED, true ,"financialStatement") {
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    headerAmountCheckBox.setSelected(getFinancialStatement().getHeaderAmount());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_WAY_ENUM_EDITOR_SELECTED_ITEM, true ,"financialStatement") {
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    wayEnumEditor.setSelectedItem(getFinancialStatement().getWay());
                }
            }
        });
    }

}