/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.ui.combobox.AccountComboBox;

public class AccountTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected static final Log log = LogFactory.getLog(AccountTableCellEditor.class);
    protected final AccountComboBox accountComboBox = new AccountComboBox();
    protected static final long serialVersionUID = 1L;

    public AccountTableCellEditor() {
        this.accountComboBox.setLeafAccounts(true);
        this.accountComboBox.setShowDecorator(false);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Account) {
            this.accountComboBox.setSelectedItem(value);
        }
        return this.accountComboBox;
    }

    @Override
    public Object getCellEditorValue() {
        return this.accountComboBox.getSelectedItem();
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        KeyEvent keyEvent;
        if (evt instanceof KeyEvent && (keyEvent = (KeyEvent)evt).getKeyChar() != '\u001b') {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountTableCellEditor.this.accountComboBox.getCombobox().getEditor().getEditorComponent().requestFocus();
                    JTextComponent edit = (JTextComponent)AccountTableCellEditor.this.accountComboBox.getCombobox().getEditor().getEditorComponent();
                    edit.requestFocus();
                    if (!Character.isIdentifierIgnorable(keyEvent.getKeyChar())) {
                        edit.setText(Character.toString(keyEvent.getKeyChar()));
                    }
                }
            });
        }
        boolean result = !(evt instanceof MouseEvent) || ((MouseEvent)evt).getClickCount() == 1;
        return result;
    }
}

