/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.config.ConfigUIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingApplicationContext;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.LimaTechnicalException;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.api.OptionsService;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.ui.ClosableTabHeader;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.account.AccountView;
import org.chorem.lima.ui.celleditor.NumberSeparatorCellRenderer;
import org.chorem.lima.ui.celleditor.NumberSeparatorTableCellRenderer;
import org.chorem.lima.ui.entrybook.EntryBookView;
import org.chorem.lima.ui.financialperiod.FinancialPeriodView;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartView;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionView;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchView;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedView;
import org.chorem.lima.ui.fiscalControlExport.FiscalControlExportView;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodView;
import org.chorem.lima.ui.home.HomeView;
import org.chorem.lima.ui.identity.IdentityForm;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.ui.lettering.LetteringView;
import org.chorem.lima.ui.vatchart.VatChartView;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DesktopUtil;
import org.nuiton.widget.SwingSession;

public class MainViewHandler {
    private static Log log = LogFactory.getLog(MainViewHandler.class);
    protected SwingSession swingSession;

    public MainView initUI(LimaSwingApplicationContext rootContext) {
        MainView ui = new MainView((JAXXContext)rootContext);
        this.swingSession = new SwingSession(this.getLimaStateFile(), false);
        LimaSwingApplicationContext.MAIN_UI_ENTRY_DEF.setContextValue((JAXXContext)rootContext, (Object)ui);
        return ui;
    }

    protected File getLimaStateFile() {
        LimaSwingConfig limaSwingConfig = LimaSwingConfig.getInstance();
        File limaStateFile = limaSwingConfig.getLimaStateFile();
        return limaStateFile;
    }

    public void changeLanguage(MainView mainUI, Locale newLocale) {
        LimaSwingConfig config = mainUI.getConfig();
        config.setLocale(newLocale);
        LimaSwingApplicationContext.get().initI18n(config);
        this.reloadUI(LimaSwingApplicationContext.get());
    }

    public void close(MainView ui) {
        boolean canContinue;
        this.swingSession.save();
        if (log.isInfoEnabled()) {
            log.info((Object)"Lima quitting...");
        }
        if (!(canContinue = this.ensureModification((JAXXContext)ui))) {
            return;
        }
        try {
            LimaSwingApplicationContext.get().close();
            Runtime.getRuntime().halt(0);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("error while closing " + ex.getMessage()), (Throwable)ex);
            }
            Runtime.getRuntime().halt(1);
        }
    }

    public void showConfig(JAXXContext context) {
        MainView ui = this.getUI(context);
        final LimaSwingConfig config = ui.getConfig();
        ConfigUIHelper helper = new ConfigUIHelper((ApplicationConfig)config);
        helper.registerCallBack(LimaSwingConfig.Option.COLOR_SELECTION_FOCUS.getKey(), I18n.t((String)"lima.config.color.selection.focus", (Object[])new Object[0]), (Icon)new ImageIcon(), new Runnable(){

            @Override
            public void run() {
                UIManager.put("Table.focusCellHighlightBorder", new BorderUIResource(new LineBorder(config.getColorSelectionFocus(), 2)));
            }
        });
        helper.addCategory(I18n.t((String)"lima.config.category.directories", (Object[])new Object[0]), I18n.t((String)"lima.config.category.directories.description", (Object[])new Object[0]));
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.CONFIG_FILE);
        helper.setOptionShortLabel(LimaSwingConfig.Option.CONFIG_FILE.getLabel());
        helper.addCategory(I18n.t((String)"lima.config.category.table", (Object[])new Object[0]), I18n.t((String)"lima.config.category.table.description", (Object[])new Object[0]));
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_BACKGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_FOREGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_PAIR_BACKGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_PAIR_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_PAIR_FOREGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_PAIR_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_SELECTED_BACKGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_SELECTED_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_SELECTED_FOREGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_SELECTED_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_BACKGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_FOREGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_ERROR_BACKGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_ERROR_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_ERROR_FOREGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_ERROR_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_PAIR_ERROR_BACKGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_PAIR_ERROR_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_PAIR_ERROR_FOREGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_PAIR_ERROR_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_SELECTED_ERROR_BACKGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_SELECTED_ERROR_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_SELECTED_ERROR_FOREGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_SELECTED_ERROR_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_ERROR_BACKGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_ERROR_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_ERROR_FOREGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_ERROR_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_MANDATORY_BACKGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_MANDATORY_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_MANDATORY_FOREGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_MANDATORY_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_PAIR_MANDATORY_BACKGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_PAIR_MANDATORY_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_PAIR_MANDATORY_FOREGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_PAIR_MANDATORY_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_SELECTED_MANDATORY_BACKGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_SELECTED_MANDATORY_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_SELECTED_MANDATORY_FOREGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_SELECTED_MANDATORY_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_MANDATORY_BACKGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_MANDATORY_BACKGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_MANDATORY_FOREGROUND);
        helper.setOptionShortLabel(LimaSwingConfig.Option.TABLE_CELL_PAIR_SELECTED_MANDATORY_FOREGROUND.getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.COLOR_SELECTION_FOCUS);
        helper.setOptionShortLabel(LimaSwingConfig.Option.COLOR_SELECTION_FOCUS.getLabel());
        helper.addCategory(I18n.t((String)"lima.config.category.other", (Object[])new Object[0]), I18n.t((String)"lima.config.category.other.description", (Object[])new Object[0]));
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.LOCALE);
        helper.setOptionShortLabel(LimaSwingConfig.Option.LOCALE.getLabel());
        JComboBox<Character> comboBoxSeparator = new JComboBox<Character>(LimaSwingConfig.NUMBER_SEPARATOR.toArray(new Character[LimaSwingConfig.NUMBER_SEPARATOR.size()]));
        DefaultCellEditor separatorEditor = new DefaultCellEditor(comboBoxSeparator);
        comboBoxSeparator.setRenderer(new NumberSeparatorCellRenderer());
        NumberSeparatorTableCellRenderer separatorRenderer = new NumberSeparatorTableCellRenderer();
        OptionsService optionsService = (OptionsService)LimaServiceFactory.getService(OptionsService.class);
        helper.addOption((ConfigOptionDef)optionsService.getDecimalSeparatorOption());
        helper.setOptionShortLabel(optionsService.getDecimalSeparatorOption().getLabel());
        helper.setOptionRenderer((TableCellRenderer)separatorRenderer);
        helper.setOptionEditor((TableCellEditor)separatorEditor);
        JComboBox<Integer> comboBoxDecimal = new JComboBox<Integer>(LimaSwingConfig.NUMBER_DECIMALS.toArray(new Integer[LimaSwingConfig.NUMBER_DECIMALS.size()]));
        DefaultCellEditor decimalEditor = new DefaultCellEditor(comboBoxDecimal);
        helper.addOption((ConfigOptionDef)optionsService.getScaleOption());
        helper.setOptionShortLabel(optionsService.getScaleOption().getLabel());
        helper.setOptionEditor((TableCellEditor)decimalEditor);
        helper.addOption((ConfigOptionDef)optionsService.getThousandSeparatorOption());
        helper.setOptionShortLabel(optionsService.getThousandSeparatorOption().getLabel());
        helper.setOptionRenderer((TableCellRenderer)separatorRenderer);
        helper.setOptionEditor((TableCellEditor)separatorEditor);
        helper.addOption((ConfigOptionDef)optionsService.getCurrencyOption());
        helper.setOptionShortLabel(optionsService.getCurrencyOption().getLabel());
        helper.addOption((ConfigOptionDef)LimaSwingConfig.Option.SELECT_ALL_EDITING_CELL);
        helper.setOptionShortLabel(LimaSwingConfig.Option.SELECT_ALL_EDITING_CELL.getLabel());
        helper.buildUI(context, I18n.t((String)"lima.config.category.directories", (Object[])new Object[0]));
        helper.displayUI((Frame)ui, false);
    }

    public void gotoSite(JAXXContext context) {
        LimaSwingConfig config = this.getUI(context).getConfig();
        URL siteURL = config.getOptionAsURL("application.site.url");
        try {
            DesktopUtil.browse((URI)siteURL.toURI());
        }
        catch (Exception e) {
            throw new LimaTechnicalException("Can't open lima website at " + siteURL, (Throwable)e);
        }
    }

    protected JEditorPane getJEditorPane() {
        JEditorPane translateArea = new JEditorPane();
        translateArea.setContentType("text/html");
        translateArea.setEditable(false);
        if (translateArea.getFont() != null) {
            translateArea.setFont(translateArea.getFont().deriveFont(11.0f));
        }
        translateArea.setBorder(null);
        return translateArea;
    }

    public void showAbout(JAXXContext context) {
        MainView ui = this.getUI(context);
        AboutPanel about = new AboutPanel();
        about.setTitle(I18n.t((String)"lima.help.about.title", (Object[])new Object[0]));
        about.setAboutText(I18n.t((String)"lima.help.about.title.description", (Object[])new Object[0]));
        about.setBottomText(ui.getConfig().getCopyrightText());
        about.setIconPath("/icons/lima.png");
        about.setLicenseFile("META-INF/lima-LICENSE.txt");
        about.setThirdpartyFile("META-INF/lima-THIRD-PARTY.txt");
        JEditorPane translateArea = this.getJEditorPane();
        String text = I18n.t((String)"lima.help.about.translate.content", (Object[])new Object[0]);
        translateArea.setText(text);
        JScrollPane component = new JScrollPane();
        component.getViewport().add(translateArea);
        about.getTabs().add(I18n.t((String)"lima.help.about.translate.title", (Object[])new Object[0]), component);
        about.init();
        about.showInDialog((Frame)ui, true);
    }

    protected void reloadUI(LimaSwingApplicationContext rootContext) {
        ((LimaSwingConfig)((Object)LimaSwingApplicationContext.CONFIG_DEF.getContextValue((JAXXContext)rootContext))).removeJaxxPropertyChangeListener();
        MainView ui = this.getUI((JAXXContext)rootContext);
        if (ui != null) {
            LimaSwingApplicationContext.MAIN_UI_ENTRY_DEF.removeContextValue((JAXXContext)rootContext);
            ui.dispose();
            ui.setVisible(false);
        }
        ui = this.initUI(rootContext);
        ui.setVisible(true);
        this.showHomeView((JAXXContext)rootContext);
    }

    protected boolean ensureModification(JAXXContext rootContext) throws IllegalArgumentException {
        if (rootContext == null) {
            throw new IllegalArgumentException("rootContext can not be null");
        }
        MainView ui = this.getUI(rootContext);
        if (ui == null) {
            return true;
        }
        return true;
    }

    protected MainView getUI(JAXXContext context) {
        if (context instanceof MainView) {
            return (MainView)context;
        }
        MainView ui = (MainView)LimaSwingApplicationContext.MAIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    public void showHomeView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        HomeView homeView = new HomeView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.home", (Object[])new Object[0]), (Component)((Object)homeView), false);
        JTabbedPane contentTabbedPane = mainView.getContentTabbedPane();
        contentTabbedPane.addChangeListener(new OnTabChangeListener(homeView));
    }

    public void showIdentity(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        IdentityForm identityForm = new IdentityForm();
        identityForm.setLocationRelativeTo(mainView);
        identityForm.setVisible(true);
    }

    public void showAccountView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        AccountView accountView = new AccountView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.accounts", (Object[])new Object[0]), accountView);
        this.swingSession.add((Component)accountView);
    }

    public void showEntryBookView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        EntryBookView entryBookView = new EntryBookView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.entryBooks", (Object[])new Object[0]), entryBookView);
        this.swingSession.add((Component)entryBookView);
    }

    public void showFiscalPeriodView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FiscalPeriodView fiscalPeriodView = new FiscalPeriodView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.fiscalYears", (Object[])new Object[0]), fiscalPeriodView);
        this.swingSession.add((Component)fiscalPeriodView);
    }

    public void showFinancialPeriodView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialPeriodView financialPeriodView = new FinancialPeriodView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.financialPeriods", (Object[])new Object[0]), financialPeriodView);
        this.swingSession.add((Component)financialPeriodView);
    }

    public void showFinancialStatementView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialStatementChartView financialStatementView = new FinancialStatementChartView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.financialStatements", (Object[])new Object[0]), financialStatementView);
        this.swingSession.add((Component)financialStatementView);
    }

    public void showVatChartView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        VatChartView vatChartView = new VatChartView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.vatStatements", (Object[])new Object[0]), vatChartView);
        this.swingSession.add((Component)vatChartView);
    }

    public void showTransactionView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialTransactionView transactionView = new FinancialTransactionView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.entries.enter", (Object[])new Object[0]), transactionView);
        this.swingSession.add((Component)transactionView);
    }

    public void showTransactionUnbalancedView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialTransactionUnbalancedView searchResultView = new FinancialTransactionUnbalancedView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.entries.unbalanced", (Object[])new Object[0]), searchResultView);
        this.swingSession.add((Component)searchResultView);
    }

    public void showTransactionSearchView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FinancialTransactionSearchView searchView = new FinancialTransactionSearchView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.entries.search", (Object[])new Object[0]), searchView);
        this.swingSession.add((Component)searchView);
    }

    public void showLetteringView(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        LetteringView letteringView = new LetteringView((JAXXContext)mainView);
        this.showTab(mainView, I18n.t((String)"lima.entries.lettering", (Object[])new Object[0]), letteringView);
        this.swingSession.add((Component)letteringView);
    }

    public void showImportExportView(JAXXContext rootContext, ImportExportEnum type) {
        MainView mainView = this.getUI(rootContext);
        ImportExport importExport = new ImportExport(mainView);
        importExport.processImportExport(type, true);
    }

    public void openLimaHttpUi(MainView ui) {
        OptionsService optionsService = (OptionsService)LimaServiceFactory.getService(OptionsService.class);
        String host = optionsService.getLimaHttpHostAddress();
        int port = optionsService.getLimaHttpPort();
        String url = port == 80 ? String.format("http://%s/", host) : (port == 443 ? String.format("https://%s/", host) : String.format("http://%s:%d/", host, port));
        if (log.isDebugEnabled()) {
            log.debug((Object)("URL : " + url));
        }
        MainViewHandler.openLink(url);
    }

    public static void openLink(String url) {
        block2: {
            try {
                URI uri = new URI(url);
                DesktopUtil.browse((URI)uri);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Error while opening link", (Throwable)e);
            }
        }
    }

    protected void showTab(MainView ui, String name, Component container, boolean canClose) {
        final JTabbedPane contentTabbedPane = ui.getContentTabbedPane();
        if (contentTabbedPane.indexOfTab(name) == -1) {
            ClosableTabHeader closableHeader = new ClosableTabHeader();
            closableHeader.setTitle(name);
            closableHeader.setCanClose(canClose);
            contentTabbedPane.addTab(name, container);
            contentTabbedPane.setSelectedComponent(container);
            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(name), closableHeader);
            closableHeader.getCloseTab().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton button = (JButton)e.getSource();
                    ClosableTabHeader closableTab = (ClosableTabHeader)button.getParent();
                    String name = closableTab.getTitle();
                    contentTabbedPane.remove(contentTabbedPane.indexOfTab(name));
                }
            });
        } else {
            contentTabbedPane.setSelectedIndex(contentTabbedPane.indexOfTab(name));
        }
    }

    protected void showTab(MainView ui, String name, Component container) {
        this.showTab(ui, name, container, true);
    }

    public void showFiscalControlExport(JAXXContext rootContext) {
        MainView mainView = this.getUI(rootContext);
        FiscalControlExportView fiscalControlExportView = new FiscalControlExportView((JAXXContext)mainView);
        fiscalControlExportView.setLocationRelativeTo(mainView);
        fiscalControlExportView.setVisible(true);
    }

    protected static class OnTabChangeListener
    implements ChangeListener {
        protected final HomeView homeView;

        public OnTabChangeListener(HomeView homeView) {
            this.homeView = homeView;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane source = (JTabbedPane)e.getSource();
            if (source.getSelectedIndex() == 0) {
                this.homeView.refresh();
            }
        }
    }
}

