package org.chorem.lima.ui.entrybook;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.EntryBook;
import static org.nuiton.i18n.I18n.t;

public class EntryBookForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";
    public static final String PROPERTY_ENTRY_BOOK = "entryBook";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CODE_TEXT_FIELD_ENABLED = "codeTextField.enabled";
    public static final String BINDING_CODE_TEXT_FIELD_TEXT = "codeTextField.text";
    public static final String BINDING_LABEL_TEXT_FIELD_TEXT = "labelTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1WS2/TQBDeGJI0KeXRQOkLqUCRWg4OHDigVtAXEa3CQ7SHilzY2NvU7cZr7DF1qUD8BH4C3LkgceOEOHDmwAXxFxDiwBUxu3HsOHVpoIco3fnm+2bGO5/z5jvJei45v0WDQHd9G6wm01fm19fv1beYAUvMM1zLAeGS1l9GI1qN9JvRuQfkYq0q08thenlRNB1hM7sje6ZKih7scuZtMgZAziUzDM8rr0bhmcDx3TZrVFQa66ufP7SX5ovXGiGBg9UNYCsTh2XFnRytEs0ygQyi0hNa5tRuYBmuZTew3gF5tsip592lTfaYPCf5Ksk51EUyIBd6b1lxqPzAAVJCkLu7IMR2RbjNJYty0QByWbgN3dgULmvq3GpS3bd0BawjUL/VmeI4iiwHpBBRAZnoJsCYBbtxapzWR01zFSgwIKdkj7rsW0cMZ9SOYfnJNVrn7AqQ4cREvR2cj65iElmIyzGEyaq0zjhOVBIHIXZFHUrUYAQekOA1FkDFYhwfwVAiIQokk4qTS8Lwm9gaVjXSmQGYoLeDcQ9FLpUj+bNJuuMqmtAaPUjwqjw51zHEyZX71Gb8Snev6jQ5mJxBbUNOpZRALvgAwpaYyQiqiW35bTo8dclYYva4J3q8J/FFztRI1vXxGB9Wbf9qPcBQa6mGu5ZKEqro76HSl/ff3lXam9SP2mdSoR1GgDfccYXDXLCk9InWGvlg8fId6szUSMFjHF1EucR4SmGrYRiLQ73WbZTp+m3qbSJFNv/1w8ehR5+PEK2CD1NQs0IlfpkUYNPFKQhuBs7NOVXRsZ0+/DwpawOSxdvPcUSl9jK0tkDfwA0KcBDjKYOIqqkXPv0qrb6daw8jg8WNHAiPB5J9SHKWzS2bKWMJPSPVSPodj/mmiL0hzS1Iul044TW8qj6v7Wtfw+uprjam4FPZS6zaMyBH5bbsH42EBb6kvK56lt9mSOde9yCcZ7Z0Btzo43uWNx86zdR0LDu612AQ2dLUtI7/LqICYtLUk0bxb62f3EtueFzE6a7eFS5NvsNBDtPOROxjKS0qigN67DKiHpoMhfpVG217KeJuWMJeNoQdmU6aXBjqXSavZORrJiGBZpVGr8mXzaGjOmOyDepzWOTCY/fQQ6gkxlnMmhToRN2yTXTJG/sEMvKz2INAjtNd4YOM+//Pkm0Kk8oX2mxrsSco4A+Eug/sv0uTx0//UtYlZPgDHvrATJcJAAA=";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    private static final Log log = LogFactory.getLog(EntryBookForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean addState;
    protected JButton cancel;
    protected JLabel codeLabel;
    protected JTextField codeTextField;
    protected EntryBook entryBook;
    protected EntryBookForm entryBookFormDialog = this;
    protected JLabel labelLabel;
    protected JTextField labelTextField;
    protected JButton ok;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Document $Document0;
    private Document $Document1;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            setEntryBook(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EntryBookForm() {
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Window param0) {
        super(param0);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEntryBook().setCode(getCodeTextField().getText());
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEntryBook().setLabel(getLabelTextField().getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEntryBook().setCode(getCodeTextField().getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEntryBook().setLabel(getLabelTextField().getText());
    }

    public void doWindowClosing__on__entryBookFormDialog(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAddState() {
        return addState;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JLabel getCodeLabel() {
        return codeLabel;
    }

    public JTextField getCodeTextField() {
        return codeTextField;
    }

    public EntryBook getEntryBook() {
        return entryBook;
    }

    public JLabel getLabelLabel() {
        return labelLabel;
    }

    public JTextField getLabelTextField() {
        return labelTextField;
    }

    public JButton getOk() {
        return ok;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    public void setEntryBook(EntryBook entryBook) {
        EntryBook oldValue = this.entryBook;
        this.entryBook = entryBook;
        firePropertyChange(PROPERTY_ENTRY_BOOK, oldValue, entryBook);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Document get$Document0() {
        return $Document0;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEntryBookFormDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCodeLabel() {
        $objectMap.put("codeLabel", codeLabel = new JLabel());
        
        codeLabel.setName("codeLabel");
        codeLabel.setText(t("lima.entryBook.code"));
    }

    protected void createCodeTextField() {
        $objectMap.put("codeTextField", codeTextField = new JTextField());
        
        codeTextField.setName("codeTextField");
        codeTextField.setColumns(15);
    }

    protected void createEntryBook() {
        $objectMap.put("entryBook", entryBook = null);
    }

    protected void createLabelLabel() {
        $objectMap.put("labelLabel", labelLabel = new JLabel());
        
        labelLabel.setName("labelLabel");
        labelLabel.setText(t("lima.entryBook.label"));
    }

    protected void createLabelTextField() {
        $objectMap.put("labelTextField", labelTextField = new JTextField());
        
        labelTextField.setName("labelTextField");
        labelTextField.setColumns(15);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEntryBookFormDialog();
        // inline complete setup of $Table0
        $Table0.add(codeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(codeTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(labelLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(labelTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(cancel);
        $JPanel0.add(ok);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        codeLabel.setLabelFor(codeTextField);
        labelLabel.setLabelFor(labelTextField);
        cancel.setIcon(SwingUtil.createActionIcon("cancel"));
        ok.setIcon(SwingUtil.createActionIcon("ok"));
        // late initializer
        entryBookFormDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("entryBookFormDialog", entryBookFormDialog);
        createEntryBook();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createCodeLabel();
        createCodeTextField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = getCodeTextField().getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        createLabelLabel();
        createLabelTextField();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = getLabelTextField().getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancel();
        createOk();
        // inline creation of entryBookFormDialog
        setName("entryBookFormDialog");
        entryBookFormDialog.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(t("lima.entryBook.form"));
        entryBookFormDialog.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__entryBookFormDialog"));
        
        getRootPane().setDefaultButton(ok);// registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CODE_TEXT_FIELD_ENABLED, true ,"addState") {
        
            @Override
            public void processDataBinding() {
                codeTextField.setEnabled(isAddState());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CODE_TEXT_FIELD_TEXT, true ,"entryBook") {
        
            @Override
            public void processDataBinding() {
                if (getEntryBook() != null) {
                    SwingUtil.setText(codeTextField, getEntryBook().getCode());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_TEXT_FIELD_TEXT, true ,"entryBook") {
        
            @Override
            public void processDataBinding() {
                if (getEntryBook() != null) {
                    SwingUtil.setText(labelTextField, getEntryBook().getLabel());
                }
            }
        });
    }

}