package org.chorem.lima.ui.Filter.fiscalPeriodCondition;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.LimaRendererUtil;
import static org.nuiton.i18n.I18n.t;

public class FiscalPeriodConditionView extends JInternalFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1US08TURQ+VAqURwCJCIiKSgwkOi1uWQjpI5QMj7RAiF3gZebSXnI7d7z3llYJxp/gT9C9GxN3rowL1y7cGP+CMS7cGs+dPoHxsXAWk+l5n+87X199haiScOOQ1GqWrHialam1ury7u7F/SB2dosqRzNdCQv3pikCkAANuy6403CrYJj3eSI8nRdkXHvU6shdt6Ff6MaeqRKnWcPV0hqNUPN9yL9b8imxWbQ0VVvXF92+R5+6zlxGAmo/TdeMqM3/Lam/SbUOEuRouYqcjEufEK+IYknlFnHfI2JKcKLVOyvQRPIVeG3p8IrGYhpv/vnJQI8iv+RqmDphyCN+kkgk3KTyXaSa8jMQeGrJCFi2nJCQtW5yViVVhVoZxTaUVmobOEOsOo1XfD1r2aOgtEc/lVGqw/0v1lXq5doOh2dW8IwXnm8SjCQ2XDXA1S1URR6vDZcJjrayRzpY2U4jp6KlEYzOxwz6SeuUUqXguVvtc2nx2FSAqK2jWMFE4f2E5dNVva+LMbZmCgffn+Nint1/eZJoHFcHel0JDO/SARPtS+AgxM62H69dU0YzH14i/WICYohzFFIhlOmSwfMONw2G/AAbLpFsrRJWwRLT387v34w8/XoBIBvq5IG6GmPgsxHRJIgqCuzX//lIw0WC1D98jZngNUc00R4hGA747IUfefEkPqJTUzbMnGDN57NHqTAqH8hTyPHcvkbgzs5BIzJ/UELLpEMhac+/HPvwYy79easLWhWtM/ja8DV30AfQwjzOPBkpsiCxUeQO+ohVXtMUUJi/4o778xs1OBe9r5/DqRkzqTGHGmnARk8SxOcN8p5Fba9v2VnbTTu9l17fSuZ1ley+fttPJrezG+gnSf8QU2+c0J6pJUTH/FZG7CxoGHcp5jnoulUaLSSxcJs3f24ZsRD9FHSEJQmS6JjsS5jqlaDlm5Xns1ccxLkU00XD9uKFzq0h15oy25gyHZunZgBzzdRtCNIgI/QILmfGKEQYAAA==";
    private static final Log log = LogFactory.getLog(FiscalPeriodConditionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected FiscalPeriodConditionView fiscalPeriodConditionFrame = this;
    protected JList fiscalPeriodList;
    protected FiscalPeriodConditionHandler handler;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FiscalPeriodConditionView(String param0) {
        super(param0);
        $initialize();
    }

    public FiscalPeriodConditionView(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalPeriodConditionView() {
        $initialize();
    }

    public FiscalPeriodConditionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalPeriodConditionView(String param0, boolean param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FiscalPeriodConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalPeriodConditionView(String param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FiscalPeriodConditionView(JAXXContext parentContext, String param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalPeriodConditionView(String param0, boolean param1, boolean param2, boolean param3, boolean param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public FiscalPeriodConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4, boolean param5) {
        super(param1 ,param2 ,param3 ,param4 ,param5);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalPeriodConditionView(String param0, boolean param1, boolean param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FiscalPeriodConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doInternalFrameClosed__on__fiscalPeriodConditionFrame(InternalFrameEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.delete();
    }

    public void doValueChanged__on__fiscalPeriodList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setFiscalPeriod(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JList getFiscalPeriodList() {
        return fiscalPeriodList;
    }

    public FiscalPeriodConditionHandler getHandler() {
        return handler;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(FiscalPeriodConditionHandler handler) {
        FiscalPeriodConditionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFiscalPeriodConditionFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0);
    }

    protected void createFiscalPeriodList() {
        $objectMap.put("fiscalPeriodList", fiscalPeriodList = new JList());
        
        fiscalPeriodList.setName("fiscalPeriodList");
        fiscalPeriodList.setVisibleRowCount(-1);
        fiscalPeriodList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__fiscalPeriodList"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FiscalPeriodConditionHandler(this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFiscalPeriodConditionFrame();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fiscalPeriodList);
        
        // apply 4 property setters
        setPreferredSize(new Dimension(200, 100));
        fiscalPeriodList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        fiscalPeriodList.setCellRenderer(LimaRendererUtil.newDecoratorListCellRenderer(FiscalPeriod.class));
        fiscalPeriodList.setListData(handler.getFiscalPeriodList());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("fiscalPeriodConditionFrame", fiscalPeriodConditionFrame);
        createHandler();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFiscalPeriodList();
        // inline creation of fiscalPeriodConditionFrame
        setName("fiscalPeriodConditionFrame");
        setVisible(true);
        setClosable(true);
        setDefaultCloseOperation(2);
        setTitle(t("lima.fiscalPeriod"));
        fiscalPeriodConditionFrame.addInternalFrameListener(JAXXUtil.getEventListener(InternalFrameListener.class, "internalFrameClosed", this, "doInternalFrameClosed__on__fiscalPeriodConditionFrame"));
        
        fiscalPeriodConditionFrame.pack();
        $completeSetup();
    }

}