package org.chorem.lima.ui.fiscalperiod;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.ui.combobox.EntryBookComboBoxModel;
import org.chorem.lima.ui.common.EntryBookListRenderer;
import static org.nuiton.i18n.I18n.t;

public class RetainedEarningsEntryBookForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_VALIDATE = "validate";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CODE_FIELD_VISIBLE = "codeField.visible";
    public static final String BINDING_CODE_LABEL_VISIBLE = "codeLabel.visible";
    public static final String BINDING_ENTRY_BOOK_COMBO_BOX_VISIBLE = "entryBookComboBox.visible";
    public static final String BINDING_ENTRY_BOOK_SELECTOR_LABEL_VISIBLE = "entryBookSelectorLabel.visible";
    public static final String BINDING_LABEL_FIELD_VISIBLE = "labelField.visible";
    public static final String BINDING_LABEL_LABEL_VISIBLE = "labelLabel.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAL1Wz28bRRQem9qJHSi0IaEVQXLbSBgprEMFFVJKCflh0cj9oaaHqrkwuzuNp5mdWWZmkzURiD8BLpzhzgWJGyfEgTMHLoh/ASEOXBFvZu1db7xJlwbVsq3VvPe+9723872Zb/9ANSXRpcc4jh0ZcU0D4mx98ODBHfcx8fQGUZ6koRYSJZ9KFVV30IyfriuNruz0THhnGN5ZF0EoOOFj0Ss91FR6wIjqE6I1ei0f4SnV2U7NK3EYyRFqSqoI9eu//qx+4X/+TRWhOAR2Z6GU1pOiskrO9FCV+hqdh0z7uMMw3wUakvJd4PuCWVtnWKnbOCAfo8/QVA/VQywBTKPL5Uu2GDY+DqFZkmhMOfE3seSQSW1yLQdrQux1hQw2KGZiV6P3hNx1vL6QJHAYDbATUecRVR5mIZFU+M69k1DC0OarazS9jxn1sSYanTP1OKZGB/wYwTxze5mTgxRhvU+8vTURazRnQmJHHUAGZ2u0bmIaaejU4n3sMrKs0YVc45Mga8sHzJNRom3CYIsJ2cMuYfAWctnsogk5n0UGwics4ykCV1ieVwu65RmrK2Jnwv+WQclqP0cmAY8UPlzPs2l4gJOyfKXA2KWEwe6az4HdJ7G2hnxAkxmk4+ASaxp2OW+dXty6izlhy0d7aFfz3a97mHum27M5z7VIa8GNz+upa1Xsmael4apEr+ZeMGjWyTSbiaqyg2oygmXYETuTMr8HpkTgF44I3ABa6z/zs7/+8Pv33ZGqX4Lcc4WuY0MJ1BZKAerQ1KR+MZF0pCnr3MLhyg5qqOF2A+tCAbHRbgRykC9Riwl3PsSqDxC1qd9+/Gn+o1+eQ9UuvBCB/S42/jdRQ/cldEEwPw7fX7WMnj+YNsThV9Wopqlm0KK23ZuJjO8mMnaZ8PacoyNBo5mAchpEwTb9BAIvHoI+WxvAlCsqePvqO8tLrbeuLb/xaQx9XCjoY1qM2/j579nt71ZHvaxAbRePdc/6WXuI6pQzYGVn5HD8Fc7EmVCRyBfZmCsafKjc5AuHunzb/r9b1M0zGhQEaJPNTIWsHE8SO/TqrpA+7An05uGafUre2WDosBmEepAY2teWWsOvaatJf8P2yzytomNmZHm+Zy3flCIMzn2qqGv2xeLhpSJsh6rkvRC/XUzpmFH6JFKV/yX55Nws34zZfDMcMy3HSV05fDpO2Uz+Tz04VTo7lcuX3rSls+TIOz2FsXPjmZQ8dhKVr3nG1jw6eZogQZhiNz3B0/OoKNXQVD7NlE1jtJVLAedYETwsl+jYnE8e4YjpdSYUuQPHCzbAIOfrcKvCLZdyH0bZjYkEFfPfLJGgzvBARNrYv3x6lBpcjbC5Q11PhnYLa7jHupEmp6BWs/etE5gtlACZhvsyjFciT4Vjlr86AaENCP8C/7gCScsMAAA=";
    private static final Log log = LogFactory.getLog(RetainedEarningsEntryBookForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancel;
    protected JTextField codeField;
    protected JLabel codeLabel;
    protected JComboBox entryBookComboBox;
    protected JLabel entryBookSelectorLabel;
    protected JTextField labelField;
    protected JLabel labelLabel;
    protected EntryBookComboBoxModel modelEntryBookComboBox;
    protected JCheckBox newEntryBookCheckBox;
    protected JButton ok;
    protected RetainedEarningsEntryBookForm retainedEarningsEntryBookFormDialog = this;
    protected Boolean validate;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        
        /**
         * Sets null to EntryBook and closes JDialog
         */
        protected void performOk() {
            setValidate(true);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RetainedEarningsEntryBookForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm() {
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Window param0) {
        super(param0);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public RetainedEarningsEntryBookForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performOk();
    }

    public void doWindowClosing__on__retainedEarningsEntryBookFormDialog(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancel() {
        return cancel;
    }

    public JTextField getCodeField() {
        return codeField;
    }

    public JLabel getCodeLabel() {
        return codeLabel;
    }

    public JComboBox getEntryBookComboBox() {
        return entryBookComboBox;
    }

    public JLabel getEntryBookSelectorLabel() {
        return entryBookSelectorLabel;
    }

    public JTextField getLabelField() {
        return labelField;
    }

    public JLabel getLabelLabel() {
        return labelLabel;
    }

    public EntryBookComboBoxModel getModelEntryBookComboBox() {
        return modelEntryBookComboBox;
    }

    public JCheckBox getNewEntryBookCheckBox() {
        return newEntryBookCheckBox;
    }

    public JButton getOk() {
        return ok;
    }

    public Boolean getValidate() {
        return validate;
    }

    public Boolean isValidate() {
        return validate !=null && validate;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setValidate(Boolean validate) {
        Boolean oldValue = this.validate;
        this.validate = validate;
        firePropertyChange(PROPERTY_VALIDATE, oldValue, validate);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToRetainedEarningsEntryBookFormDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(newEntryBookCheckBox, BorderLayout.NORTH);
        add($Table0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCodeField() {
        $objectMap.put("codeField", codeField = new JTextField());
        
        codeField.setName("codeField");
        codeField.setColumns(15);
    }

    protected void createCodeLabel() {
        $objectMap.put("codeLabel", codeLabel = new JLabel());
        
        codeLabel.setName("codeLabel");
        codeLabel.setText(t("lima.entryBook.code"));
    }

    protected void createEntryBookComboBox() {
        $objectMap.put("entryBookComboBox", entryBookComboBox = new JComboBox());
        
        entryBookComboBox.setName("entryBookComboBox");
    }

    protected void createEntryBookSelectorLabel() {
        $objectMap.put("entryBookSelectorLabel", entryBookSelectorLabel = new JLabel());
        
        entryBookSelectorLabel.setName("entryBookSelectorLabel");
        entryBookSelectorLabel.setText(t("lima.entryBook"));
    }

    protected void createLabelField() {
        $objectMap.put("labelField", labelField = new JTextField());
        
        labelField.setName("labelField");
        labelField.setColumns(15);
    }

    protected void createLabelLabel() {
        $objectMap.put("labelLabel", labelLabel = new JLabel());
        
        labelLabel.setName("labelLabel");
        labelLabel.setText(t("lima.label"));
    }

    protected void createModelEntryBookComboBox() {
        $objectMap.put("modelEntryBookComboBox", modelEntryBookComboBox = new EntryBookComboBoxModel());
    }

    protected void createNewEntryBookCheckBox() {
        $objectMap.put("newEntryBookCheckBox", newEntryBookCheckBox = new JCheckBox());
        
        newEntryBookCheckBox.setName("newEntryBookCheckBox");
        newEntryBookCheckBox.setText(t("lima.fiscalPeriod.entryBooks.create"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createValidate() {
        $objectMap.put("validate", validate = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToRetainedEarningsEntryBookFormDialog();
        // inline complete setup of $Table0
        $Table0.add(entryBookSelectorLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(entryBookComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(codeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(codeField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(labelLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(labelField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(cancel);
        $JPanel0.add(ok);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        entryBookComboBox.setModel(getModelEntryBookComboBox());
        entryBookComboBox.setRenderer(new EntryBookListRenderer());
        setMinimumSize(new Dimension(250, 160));
        newEntryBookCheckBox.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        cancel.setIcon(SwingUtil.createActionIcon("cancel"));
        ok.setIcon(SwingUtil.createActionIcon("ok"));
        // late initializer
        retainedEarningsEntryBookFormDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("retainedEarningsEntryBookFormDialog", retainedEarningsEntryBookFormDialog);
        createValidate();
        createNewEntryBookCheckBox();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createEntryBookSelectorLabel();
        createModelEntryBookComboBox();
        createEntryBookComboBox();
        createCodeLabel();
        createCodeField();
        createLabelLabel();
        createLabelField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancel();
        createOk();
        // inline creation of retainedEarningsEntryBookFormDialog
        setName("retainedEarningsEntryBookFormDialog");
        retainedEarningsEntryBookFormDialog.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(t("lima.fiscalPeriod.block.retainedEarnings"));
        retainedEarningsEntryBookFormDialog.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__retainedEarningsEntryBookFormDialog"));
        
        getRootPane().setDefaultButton(ok);// registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ENTRY_BOOK_SELECTOR_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (newEntryBookCheckBox != null) {
                    $bindingSources.put("newEntryBookCheckBox.getModel()", newEntryBookCheckBox.getModel());
                    newEntryBookCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    newEntryBookCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm.this, BINDING_ENTRY_BOOK_SELECTOR_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newEntryBookCheckBox != null) {
                    entryBookSelectorLabel.setVisible(!newEntryBookCheckBox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newEntryBookCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("newEntryBookCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    newEntryBookCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm.this, BINDING_ENTRY_BOOK_SELECTOR_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ENTRY_BOOK_COMBO_BOX_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (newEntryBookCheckBox != null) {
                    $bindingSources.put("newEntryBookCheckBox.getModel()", newEntryBookCheckBox.getModel());
                    newEntryBookCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    newEntryBookCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm.this, BINDING_ENTRY_BOOK_COMBO_BOX_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newEntryBookCheckBox != null) {
                    entryBookComboBox.setVisible(!newEntryBookCheckBox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newEntryBookCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("newEntryBookCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    newEntryBookCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm.this, BINDING_ENTRY_BOOK_COMBO_BOX_VISIBLE));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CODE_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (newEntryBookCheckBox != null) {
                    $bindingSources.put("newEntryBookCheckBox.getModel()", newEntryBookCheckBox.getModel());
                    newEntryBookCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    newEntryBookCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm.this, BINDING_CODE_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newEntryBookCheckBox != null) {
                    codeLabel.setVisible(newEntryBookCheckBox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newEntryBookCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("newEntryBookCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    newEntryBookCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm.this, BINDING_CODE_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CODE_FIELD_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (newEntryBookCheckBox != null) {
                    $bindingSources.put("newEntryBookCheckBox.getModel()", newEntryBookCheckBox.getModel());
                    newEntryBookCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    newEntryBookCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm.this, BINDING_CODE_FIELD_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newEntryBookCheckBox != null) {
                    codeField.setVisible(newEntryBookCheckBox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newEntryBookCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("newEntryBookCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    newEntryBookCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm.this, BINDING_CODE_FIELD_VISIBLE));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LABEL_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (newEntryBookCheckBox != null) {
                    $bindingSources.put("newEntryBookCheckBox.getModel()", newEntryBookCheckBox.getModel());
                    newEntryBookCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    newEntryBookCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm.this, BINDING_LABEL_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newEntryBookCheckBox != null) {
                    labelLabel.setVisible(newEntryBookCheckBox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newEntryBookCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("newEntryBookCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    newEntryBookCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm.this, BINDING_LABEL_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LABEL_FIELD_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (newEntryBookCheckBox != null) {
                    $bindingSources.put("newEntryBookCheckBox.getModel()", newEntryBookCheckBox.getModel());
                    newEntryBookCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    newEntryBookCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm.this, BINDING_LABEL_FIELD_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newEntryBookCheckBox != null) {
                    labelField.setVisible(newEntryBookCheckBox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newEntryBookCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("newEntryBookCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    newEntryBookCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.fiscalperiod.RetainedEarningsEntryBookForm.this, BINDING_LABEL_FIELD_VISIBLE));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}