package org.chorem.lima.ui.financialstatementchart;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.FinancialStatementWayEnum;
import org.chorem.lima.entity.FinancialStatement;
import org.chorem.lima.entity.FinancialStatementImpl;
import org.chorem.lima.ui.common.LabelListCellRenderer;
import static org.nuiton.i18n.I18n.t;

public class FinancialStatementHeaderForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";
    public static final String PROPERTY_FINANCIAL_STATEMENT = "financialStatement";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HEADER_AMOUNT_CHECK_BOX_SELECTED = "headerAmountCheckBox.selected";
    public static final String BINDING_LABEL_TEXT_FIELD_TEXT = "labelTextField.text";
    public static final String BINDING_SUB_AMOUNT_CHECK_BOX_ENABLED = "subAmountCheckBox.enabled";
    public static final String BINDING_SUB_AMOUNT_CHECK_BOX_SELECTED = "subAmountCheckBox.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz2/cRBSebLObXy3QhqStmkrbNkS7VfFGHHpootIm7ZJG2xa6lajYS8f2JOtmPGNmxo1XURH8B/wJcOeCxI0T4sCZAxfEv4AQB66IN2OvN157E0vswbLmvfe9b974+2a/+xNVpUDXXuEoskTIlOcTa/f+ixdP7VfEUQ+IdIQXKC5Q/JuqoEoPLbjpulToRq+jy1tJeWub+wFnhB2r3uigeakGlMg+IUqhq9kKR8pWNw1vREEohqgpqSLUb/7+q/K1++W3FYSiANidg63UT6sa7WS6gyqeq9AF6PQatyhm+0BDeGwf+J7Ta9sUS/kE++Rz9AWa6aBagAWAKXS9/JYNhqmPAoVW9jyGmeNh2lVYER9qdgh2iWhz4Sv0ERf7ltPngvgW9XxshZ6VVshhhdPHQlntE5CCwLSswebyDRVqjreBVU8NCiBHQLPYdc2yQuf1bCw9L2uLc0owG6XNrD7HNiXrCl3KnIQ8hLlaJqYz59KCeYptQjv6AWw1cpQk75pFnXYhzX7LZD8nkWp7hMLhLWcq0kC2avYQD1Kwi/kYnJ/NFVrKYJnFLR5l09/tmyHf9zlsbLtPnANIyZUm69nS8zK0s3U6cH2Mzurux5gRuj4+DLOaHV3NgdPSY1vMZG6FSnGmc95LUyv8QL/dTFYFupI5HVCgNVLgSCJTPVQVISzDcfbyon0GoViul8bkqgFN9N/lxd9+/OOH9lCjZ6H3UmHqMYsB7QSCB0QoT7d+OxZoqDzaeoyDjR6ak4SCPxn/WSkg1k3CQA76xd+rLrd2sOwDRHXm959+Xn756xlUacMXyLHbxjr/EZpTfQFT4NSNgg/vGUZnD2fh+Y7mplAVhEJhRDeMbvLisuLvw9oDFUYwmJWCwaTs7Llf/lnsfn9vOJwpIHt5YvpoQNXPUM1j1GPEWFjiToWWtRBIErp85EJFvoROMaYg0fcH5nm7aC7TCqQHzj5pLEa3Uajr75id6rdNlNF/+TZXJrUBMRc1SQ3gtBYVOGGfu1pUd48YOaw/IHs4pGpoBo91rJH3yU/x4CELfes1piGRjWbzDTSFuwIGCF8xumqwDIOOJ9U2ofRZEmw030xibJqWYDwbq4GAHd482icqT6/RtDy5c8y5GppgMszVkz/luKCIY6EXnsZ3Gu4IwvQ9AHQbmu5OAYoh3E22Zcge2+QnJ2yyO/TYRrO+tlYvDZ/M4tqkWaTeDbZrc+HqU33/aMu8xd4xsBxBIP2hH6hBHGis36rfvlWH53rxKeevhBLHnVBdMFSHV8A8cPA4e+Rwll4MRR2TUPk2M6YNPxhrARdKETwsl1DxkpuoinJJnoLPYw0Mt/umixWu2x5z4Sa7m2swpZ/zJRpoDWP9f2Iztsk6VvDHzg4V+R+gZiA6+lUxxuUSGDWKBzw8CWUNUP4DTUhkfZcLAAA=";
    private static final Log log = LogFactory.getLog(FinancialStatementHeaderForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean addState;
    protected JButton cancel;
    protected FinancialStatement financialStatement;
    protected FinancialStatementHeaderForm financialStatementHeaderForm = this;
    protected JCheckBox headerAmountCheckBox;
    protected JLabel labelLabel;
    protected JTextField labelTextField;
    protected JButton ok;
    protected JCheckBox subAmountCheckBox;
    protected JComboBox wayCombo;
    protected JLabel wayLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void getFinancialStatementWayValue(){
        
            FinancialStatementWayEnum fSWE =
                (FinancialStatementWayEnum) wayCombo.getSelectedItem();
    
            if (fSWE == null){
                fSWE = FinancialStatementWayEnum.BOTH;
            }
            getFinancialStatement().setWay(fSWE);
        }
        protected void performCancel() {
            setFinancialStatement(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialStatementHeaderForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm() {
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementHeaderForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementHeaderForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__headerAmountCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setHeaderAmount(headerAmountCheckBox.isSelected());
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__subAmountCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setSubAmount(subAmountCheckBox.isSelected());
    }

    public void doActionPerformed__on__wayCombo(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatementWayValue();
    }

    public void doKeyReleased__on__labelTextField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setLabel(labelTextField.getText());
    }

    public void doWindowClosing__on__financialStatementHeaderForm(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAddState() {
        return addState;
    }

    public JButton getCancel() {
        return cancel;
    }

    public FinancialStatement getFinancialStatement() {
        return financialStatement;
    }

    public JCheckBox getHeaderAmountCheckBox() {
        return headerAmountCheckBox;
    }

    public JLabel getLabelLabel() {
        return labelLabel;
    }

    public JTextField getLabelTextField() {
        return labelTextField;
    }

    public JButton getOk() {
        return ok;
    }

    public JCheckBox getSubAmountCheckBox() {
        return subAmountCheckBox;
    }

    public JComboBox getWayCombo() {
        return wayCombo;
    }

    public JLabel getWayLabel() {
        return wayLabel;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    public void setFinancialStatement(FinancialStatement financialStatement) {
        FinancialStatement oldValue = this.financialStatement;
        this.financialStatement = financialStatement;
        firePropertyChange(PROPERTY_FINANCIAL_STATEMENT, oldValue, financialStatement);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFinancialStatementHeaderForm() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createFinancialStatement() {
        $objectMap.put("financialStatement", financialStatement = null);
    }

    protected void createHeaderAmountCheckBox() {
        $objectMap.put("headerAmountCheckBox", headerAmountCheckBox = new JCheckBox());
        
        headerAmountCheckBox.setName("headerAmountCheckBox");
        headerAmountCheckBox.setText(t("lima.financialStatement.headerAmount"));
        headerAmountCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__headerAmountCheckBox"));
    }

    protected void createLabelLabel() {
        $objectMap.put("labelLabel", labelLabel = new JLabel());
        
        labelLabel.setName("labelLabel");
        labelLabel.setText(t("lima.financialStatement.label"));
    }

    protected void createLabelTextField() {
        $objectMap.put("labelTextField", labelTextField = new JTextField());
        
        labelTextField.setName("labelTextField");
        labelTextField.setColumns(15);
        labelTextField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__labelTextField"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createSubAmountCheckBox() {
        $objectMap.put("subAmountCheckBox", subAmountCheckBox = new JCheckBox());
        
        subAmountCheckBox.setName("subAmountCheckBox");
        subAmountCheckBox.setText(t("lima.financialStatement.subAmount"));
        subAmountCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__subAmountCheckBox"));
    }

    protected void createWayCombo() {
        $objectMap.put("wayCombo", wayCombo = new JComboBox());
        
        wayCombo.setName("wayCombo");
        wayCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__wayCombo"));
    }

    protected void createWayLabel() {
        $objectMap.put("wayLabel", wayLabel = new JLabel());
        
        wayLabel.setName("wayLabel");
        wayLabel.setText(t("lima.financialStatement.way"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFinancialStatementHeaderForm();
        // inline complete setup of $Table0
        $Table0.add(labelLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(labelTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(wayLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(wayCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(headerAmountCheckBox, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(subAmountCheckBox, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(cancel);
        $JPanel0.add(ok);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        wayCombo.setModel(new DefaultComboBoxModel(FinancialStatementWayEnum.values()));
        wayCombo.setRenderer(new LabelListCellRenderer());
        subAmountCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        cancel.setIcon(SwingUtil.createActionIcon("cancel"));
        ok.setIcon(SwingUtil.createActionIcon("ok"));
        // late initializer
        financialStatementHeaderForm.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("financialStatementHeaderForm", financialStatementHeaderForm);
        createFinancialStatement();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createLabelLabel();
        createLabelTextField();
        createWayLabel();
        createWayCombo();
        createHeaderAmountCheckBox();
        createSubAmountCheckBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancel();
        createOk();
        // inline creation of financialStatementHeaderForm
        setName("financialStatementHeaderForm");
        setModal(true);
        setTitle(t("lima.financialStatement.header.form"));
        financialStatementHeaderForm.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__financialStatementHeaderForm"));
        
        getRootPane().setDefaultButton(ok);// registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_TEXT_FIELD_TEXT, true ,"financialStatement") {
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(labelTextField, getFinancialStatement().getLabel());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HEADER_AMOUNT_CHECK_BOX_SELECTED, true ,"financialStatement") {
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    headerAmountCheckBox.setSelected(getFinancialStatement().isHeaderAmount());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUB_AMOUNT_CHECK_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getHeaderAmountCheckBox() != null) {
                    $bindingSources.put("getHeaderAmountCheckBox().getModel()", getHeaderAmountCheckBox().getModel());
                    getHeaderAmountCheckBox().getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    getHeaderAmountCheckBox().addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.financialstatementchart.FinancialStatementHeaderForm.this, BINDING_SUB_AMOUNT_CHECK_BOX_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getHeaderAmountCheckBox() != null) {
                    subAmountCheckBox.setEnabled(getHeaderAmountCheckBox().isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getHeaderAmountCheckBox() != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("getHeaderAmountCheckBox().getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    getHeaderAmountCheckBox().removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.financialstatementchart.FinancialStatementHeaderForm.this, BINDING_SUB_AMOUNT_CHECK_BOX_ENABLED));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUB_AMOUNT_CHECK_BOX_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("financialStatement", this);
                if (getHeaderAmountCheckBox() != null) {
                    $bindingSources.put(" getHeaderAmountCheckBox().getModel()",  getHeaderAmountCheckBox().getModel());
                     getHeaderAmountCheckBox().getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    getHeaderAmountCheckBox().addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.financialstatementchart.FinancialStatementHeaderForm.this, BINDING_SUB_AMOUNT_CHECK_BOX_SELECTED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null && getHeaderAmountCheckBox() != null) {
                    subAmountCheckBox.setSelected(getFinancialStatement().isSubAmount() && getHeaderAmountCheckBox().isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("financialStatement", this);
                if (getHeaderAmountCheckBox() != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove(" getHeaderAmountCheckBox().getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    getHeaderAmountCheckBox().removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.chorem.lima.ui.financialstatementchart.FinancialStatementHeaderForm.this, BINDING_SUB_AMOUNT_CHECK_BOX_SELECTED));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}