/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialperiod;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.exceptions.NotLockedClosedPeriodicEntryBooksException;
import org.chorem.lima.business.exceptions.UnbalancedFinancialTransactionsException;
import org.chorem.lima.business.exceptions.UnfilledEntriesException;
import org.chorem.lima.business.exceptions.WithoutEntryBookFinancialTransactionsException;
import org.chorem.lima.business.utils.FinancialPeriodComparator;
import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTable;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTableModel;
import org.chorem.lima.ui.financialperiod.FinancialPeriodView;
import org.chorem.lima.util.BigDecimalToString;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public class FinancialPeriodViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(FinancialPeriodViewHandler.class);
    protected FinancialPeriodService financialPeriodService;
    protected FinancialPeriodView view;
    protected ErrorHelper errorHelper;

    protected FinancialPeriodViewHandler(FinancialPeriodView view) {
        this.view = view;
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, (ServiceListener)this);
        this.errorHelper = new ErrorHelper(LimaSwingConfig.getInstance());
    }

    public void init() {
        InputMap inputMap = this.view.getInputMap(1);
        ActionMap actionMap = this.view.getActionMap();
        String binding = "close-FinancialPeriod";
        inputMap.put(KeyStroke.getKeyStroke(66, 128), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 4933544189561608564L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialPeriodViewHandler.this.blockFinancialPeriod();
            }
        });
        List closedPeriodicEntryBooks = this.financialPeriodService.getAllClosedPeriodicEntryBooksFromUnblockedFiscalPeriod();
        Collections.sort(closedPeriodicEntryBooks, new FinancialPeriodComparator());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded %d closed periodic entry book", closedPeriodicEntryBooks.size()));
        }
        this.view.getFinancialPeriodTableModel().setValues(closedPeriodicEntryBooks);
    }

    public void blockFinancialPeriod() {
        FinancialPeriodTable financialPeriodeTable = this.view.getFinancialPeriodTable();
        int selectedRow = financialPeriodeTable.getSelectedRow();
        FinancialPeriodTableModel model = (FinancialPeriodTableModel)this.view.getFinancialPeriodTable().getModel();
        ClosedPeriodicEntryBook closedPeriodicEntryBook = (ClosedPeriodicEntryBook)model.get(selectedRow);
        int response = JOptionPane.showConfirmDialog(this.view, I18n.t((String)"lima.financialPeriod.block.confirm", (Object[])new Object[0]), I18n.t((String)"lima.financialPeriod.block.title", (Object[])new Object[0]), 0, 3);
        if (response == 0) {
            try {
                closedPeriodicEntryBook = this.financialPeriodService.blockClosedPeriodicEntryBook(closedPeriodicEntryBook);
                model.setValue(selectedRow, closedPeriodicEntryBook);
            }
            catch (UnbalancedFinancialTransactionsException e) {
                StringBuilder message = new StringBuilder(I18n.t((String)"lima.financialPeriod.block.error.unbalanced.main", (Object[])new Object[0]));
                for (FinancialTransaction transaction : e.getFinancialTransactions()) {
                    message.append("\n    - ");
                    message.append(I18n.t((String)"lima.financialPeriod.block.error.unbalanced.transaction", (Object[])new Object[]{transaction.getTransactionDate(), BigDecimalToString.format(transaction.getAmountDebit()), BigDecimalToString.format(transaction.getAmountCredit())}));
                }
                this.errorHelper.showErrorMessage(message.toString());
            }
            catch (UnfilledEntriesException e) {
                StringBuilder message = new StringBuilder(I18n.t((String)"lima.financialPeriod.block.error.unfilled.main", (Object[])new Object[0]));
                for (Entry entry : e.getEntries()) {
                    message.append("\n    - ");
                    message.append(I18n.t((String)"lima.financialPeriod.block.error.unfilled.entry", (Object[])new Object[]{entry.getFinancialTransaction().getTransactionDate(), BigDecimalToString.format(entry.getAmount())}));
                    if (entry.getAccount() == null) {
                        message.append("\n        - ");
                        message.append(I18n.t((String)"lima.financialPeriod.block.error.unfilled.noAccount", (Object[])new Object[0]));
                    }
                    if (StringUtils.isBlank((CharSequence)entry.getVoucher())) {
                        message.append("\n        - ");
                        message.append(I18n.t((String)"lima.financialPeriod.block.error.unfilled.noVoucher", (Object[])new Object[0]));
                    }
                    if (!StringUtils.isBlank((CharSequence)entry.getDescription())) continue;
                    message.append("\n        - ");
                    message.append(I18n.t((String)"lima.financialPeriod.block.error.unfilled.noDescription", (Object[])new Object[0]));
                }
                this.errorHelper.showErrorMessage(message.toString());
            }
            catch (WithoutEntryBookFinancialTransactionsException e) {
                StringBuilder message = new StringBuilder(I18n.t((String)"lima.financialPeriod.block.error.withoutEntryBook.main", (Object[])new Object[0]));
                for (FinancialTransaction transaction : e.getFinancialTransactions()) {
                    message.append("\n    - ");
                    message.append(I18n.t((String)"lima.financialPeriod.block.error.withoutEntryBook.transaction", (Object[])new Object[]{transaction.getTransactionDate(), BigDecimalToString.format(transaction.getAmountCredit())}));
                }
                this.errorHelper.showErrorMessage(message.toString());
            }
            catch (NotLockedClosedPeriodicEntryBooksException e) {
                StringBuilder message = new StringBuilder(I18n.t((String)"lima.financialPeriod.block.error.noLockedPreviousEntryBook.main", (Object[])new Object[0]));
                for (ClosedPeriodicEntryBook previousClosedPeriodicEntryBook : e.getClosedPeriodicEntryBooks()) {
                    message.append("\n    - ");
                    message.append(I18n.t((String)"lima.financialPeriod.block.error.noLockedPreviousEntryBook.previousEntryBook", (Object[])new Object[]{previousClosedPeriodicEntryBook.getFinancialPeriod().getBeginDate(), previousClosedPeriodicEntryBook.getFinancialPeriod().getEndDate()}));
                }
                this.errorHelper.showErrorMessage(message.toString());
            }
        }
    }

    public void notifyMethod(String serviceName, String methodName) {
        if (serviceName.contains("FiscalPeriod") || methodName.contains("importAll")) {
            this.init();
        }
    }
}

