package org.chorem.lima.ui.vatchart;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.VatStatementsChartEnum;
import org.chorem.lima.ui.common.LabelListCellRenderer;
import static org.nuiton.i18n.I18n.t;

public class VatChartImportForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTW8bRRh+7dbOV/lI0oQgWuFCDolUxq2EekkFJWkjErkUNaiq8IXx7jTeZnZnO/Nus1FVxE/gJ8CdCxI3TogDZw5cEH8BIQ5cEe/MrtfeeJ1axbJWm/fzmWfe93G++xMaRsOVxzxNmU4iDELB9j96+PBe77Hw8LYwng5iVBqyT60O9S4s+IXdILzb7dj0dp7e3lFhrCIRjWRvdWDe4IkUpi8EIlwuZ3jGtA8K91YaJ3pQtQBVVfWbv/+qf+1/9W0dII0J3QIdpfWirOFJznegHvgIS9TpKW9LHh0SDB1Eh4T3FWvbkdyYT3gonsCXMNOBZsw1FUN4Z/ojuxouP40RVp9yPECOIqToPcrSuKt0iMCUPmReX2kRMhmEnCUBo1ivzzWyBxx37MswIY5dzSbCLPd9VxFh0WJm9hxsWykpeDQMK+4sUBEd2UamzBzTYdl+h/eEtHFzw6rr+5/ySMhrp2OdtRw7s/4Z70lBoWsl8rMM57ORS0XCqjvVgxEmCgSL9rFyRiRR3VMIKyVQzrit0nLyG76QAkUp25Yby+4L7yjPXhpj4Lr9+2L5xE2PR56QCMulQtsJoopsTKsIrasj+7aeWzW8VeKIRp8NR384m7UuNHRCZiK1O74t98mV7cnaqT2xBZ3339Xl337844fdwXJcoN4rlaEju01DG2sVC42Bbf1athkJBrJ9l8dbXZgzxKmXLf6lCmAHuZvAUb9sIG06+5ibPpVozPz+08+rX/x6Duq7MC8V93e5jd+DOexrYkFJP40/vOUQXTiepefrFhtCAwOk64Q1tx2ja8QCtxYpsXGpgo0CUm/ul3+WD76/NWCkRgjfnBg+ZKXxOTSDSAaRcIKRa0GlQCzERiS+Gu58lQoAjWa1DBzG+cJedc9rYzzUEc6jSGmE1yfRwEqL3uwp7dN1wnvPtt1bRvcJ87SgvDthjCeZY+PG1Vb+3XyeJrb/+44k+3YDygryIpy1AufiGM6q2hMUYQo6GqHy7SZuPYvEceu2eMQTiQM9uGt9G6NljVOAO1ESEiaZCLOxufmclp1knTiwRF12hVz7TmBwR0h5P3duVBMzQaSmAD+bbZOgH6HGIy6NKGh7+4zrtaJWhWOS3k0/VAuu60Dc5mlU6K73PDdImbWqb+6avs2Ma6OOTrUgqawqT+Ypxm3Fz69eKiPukYLxbAFevelz5K1eEPmk0R+MNajZ5/wUDZqSn6gErT9++Sp2XDlxu3QzU5QWR/qPo5egeGlo1pycAWv5f1e4QhX+A3L+NMYqCgAA";
    private static final Log log = LogFactory.getLog(VatChartImportForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean addState;
    protected JButton cancel;
    protected JComboBox chartVatStatementCombo;
    protected JLabel chartVatStatementLabel;
    protected JCheckBox deleteVatStatementChart;
    protected JLabel description;
    protected JButton ok;
    protected VatChartImportForm vatStatementImportForm = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            getChartVatStatementCombo().setSelectedItem(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VatChartImportForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm() {
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Window param0) {
        super(param0);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doWindowClosing__on__vatStatementImportForm(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAddState() {
        return addState;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JComboBox getChartVatStatementCombo() {
        return chartVatStatementCombo;
    }

    public JLabel getChartVatStatementLabel() {
        return chartVatStatementLabel;
    }

    public JCheckBox getDeleteVatStatementChart() {
        return deleteVatStatementChart;
    }

    public JLabel getDescription() {
        return description;
    }

    public JButton getOk() {
        return ok;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToVatStatementImportForm() {
        if (!allComponentsCreated) {
            return;
        }
        add(description, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChartVatStatementCombo() {
        $objectMap.put("chartVatStatementCombo", chartVatStatementCombo = new JComboBox());
        
        chartVatStatementCombo.setName("chartVatStatementCombo");
    }

    protected void createChartVatStatementLabel() {
        $objectMap.put("chartVatStatementLabel", chartVatStatementLabel = new JLabel());
        
        chartVatStatementLabel.setName("chartVatStatementLabel");
        chartVatStatementLabel.setText(t("lima.vatStatement"));
    }

    protected void createDeleteVatStatementChart() {
        $objectMap.put("deleteVatStatementChart", deleteVatStatementChart = new JCheckBox());
        
        deleteVatStatementChart.setName("deleteVatStatementChart");
        deleteVatStatementChart.setText(t("lima.vatStatement.import.delete"));
        deleteVatStatementChart.setSelected(false);
    }

    protected void createDescription() {
        $objectMap.put("description", description = new JLabel());
        
        description.setName("description");
        description.setText(t("lima.vatStatement.import.description"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToVatStatementImportForm();
        // inline complete setup of $JPanel0
        $JPanel0.add($Table0, BorderLayout.CENTER);
        $JPanel0.add(deleteVatStatementChart, BorderLayout.SOUTH);
        // inline complete setup of $Table0
        $Table0.add(chartVatStatementLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(chartVatStatementCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add(cancel);
        $JPanel1.add(ok);
        
        // apply 9 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        description.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        chartVatStatementCombo.setModel(new DefaultComboBoxModel(VatStatementsChartEnum.values()));
        chartVatStatementCombo.setRenderer(new LabelListCellRenderer());
        cancel.setIcon(SwingUtil.createActionIcon("cancel"));
        ok.setIcon(SwingUtil.createActionIcon("ok"));
        // late initializer
        vatStatementImportForm.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("vatStatementImportForm", vatStatementImportForm);
        createAddState();
        createDescription();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createChartVatStatementLabel();
        createChartVatStatementCombo();
        createDeleteVatStatementChart();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createCancel();
        createOk();
        // inline creation of vatStatementImportForm
        setName("vatStatementImportForm");
        vatStatementImportForm.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        vatStatementImportForm.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__vatStatementImportForm"));
        
        getRootPane().setDefaultButton(ok);$completeSetup();
    }

}