/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionunbalanced;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.common.FinancialTransactionTableModel;
import org.chorem.lima.ui.financialtransaction.AccountColumn;
import org.chorem.lima.ui.financialtransaction.CreditColumn;
import org.chorem.lima.ui.financialtransaction.DateColumn;
import org.chorem.lima.ui.financialtransaction.DebitColumn;
import org.chorem.lima.ui.financialtransaction.DescriptionColumn;
import org.chorem.lima.ui.financialtransaction.EntryBookColumn;
import org.chorem.lima.ui.financialtransaction.VoucherColumn;

public class FinancialTransactionUnbalancedTableModel
extends FinancialTransactionTableModel {
    private static final long serialVersionUID = 3914954536809622358L;
    protected FiscalPeriod selectedFiscalPeriod;

    @Override
    protected void initColumn() {
        this.addColumn(new DateColumn());
        this.addColumn(new EntryBookColumn());
        this.addColumn(new VoucherColumn());
        this.addColumn(new AccountColumn());
        this.addColumn(new DescriptionColumn());
        this.addColumn(new DebitColumn());
        this.addColumn(new CreditColumn());
    }

    protected void refresh() {
        this.clear();
        if (this.selectedFiscalPeriod != null) {
            List financialTransactions = this.financialTransactionService.getAllInexactFinancialTransactions(this.selectedFiscalPeriod);
            LinkedList entries = Lists.newLinkedList();
            for (FinancialTransaction transaction : financialTransactions) {
                entries.addAll(transaction.getEntry());
            }
            this.addAll(entries);
        }
    }

    public void setFiscalPeriod(FiscalPeriod fiscalPeriod) {
        this.selectedFiscalPeriod = fiscalPeriod;
    }
}

