/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.chorem.lima.LimaSwingApplicationContext;
import org.chorem.lima.LimaSwingConfig;

public class BigDecimalToString {
    public static String format(BigDecimal value) {
        DecimalFormat formatter = BigDecimalToString.getDecimalFormat();
        String result = formatter.format(value);
        return result;
    }

    public static DecimalFormat getDecimalFormat() {
        LimaSwingConfig config = LimaSwingApplicationContext.getContext().getConfig();
        StringBuilder scale = new StringBuilder();
        for (int i = 0; i < config.getScale(); ++i) {
            scale.append("0");
        }
        String currency = "";
        if (config.getCurrency()) {
            currency = " \u00a4";
        }
        DecimalFormat formatter = new DecimalFormat("##0." + scale.toString() + currency);
        DecimalFormatSymbols symbol = new DecimalFormatSymbols();
        symbol.setDecimalSeparator(config.getDecimalSeparator());
        symbol.setMonetaryDecimalSeparator(config.getDecimalSeparator());
        symbol.setGroupingSeparator(config.getThousandSeparator());
        formatter.setDecimalFormatSymbols(symbol);
        formatter.setGroupingUsed(true);
        formatter.setGroupingSize(3);
        return formatter;
    }
}

