/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.actions.MiscAction;
import org.chorem.lima.business.api.OptionsService;
import org.chorem.lima.entity.LimaCallaoEntityEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.converter.ConverterUtil;
import org.nuiton.i18n.I18n;
import org.nuiton.util.version.Version;
import org.nuiton.util.version.VersionBuilder;

public class LimaSwingConfig
extends ApplicationConfig {
    private static Log log = LogFactory.getLog(LimaSwingConfig.class);
    public static final Set<Character> NUMBER_SEPARATOR = ImmutableSet.of((Object)Character.valueOf(' '), (Object)Character.valueOf(','), (Object)Character.valueOf('.'), (Object)Character.valueOf(';'));
    public static final Set<Integer> NUMBER_DECIMALS = ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object[])new Integer[]{6});
    private static LimaSwingConfig instance;
    private static final String configFile = "lima-config.properties";
    protected OptionsService optionsService;
    protected Version version;
    protected static final String[] DEFAULT_JAXX_PCS;

    public String getCopyrightText() {
        return "Version " + this.getVersion() + " Codelutin @ 2008-2012";
    }

    public String getVersion() {
        return this.version.toString();
    }

    public LimaSwingConfig() {
        this.loadDefaultOptions(Option.values());
        for (Action a : Action.values()) {
            for (String alias : a.aliases) {
                this.addActionAlias(alias, a.action);
            }
        }
        this.addAlias("--disableui", new String[]{"--launchui false"});
    }

    public static synchronized LimaSwingConfig getInstance() {
        if (instance == null) {
            instance = new LimaSwingConfig();
            instance.loadConfiguration(configFile);
        }
        return instance;
    }

    protected void loadConfiguration(String configFileName) {
        block2: {
            instance.setConfigFileName(configFileName);
            try {
                instance.parse(new String[0]);
            }
            catch (ArgumentsParserException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't read configuration", (Throwable)ex);
            }
        }
        instance.setOption("topia.persistence.classes", LimaCallaoEntityEnum.getImplementationClassesAsString());
    }

    public ApplicationConfig parse(String ... args) throws ArgumentsParserException {
        super.parse(args);
        VersionBuilder nb = new VersionBuilder();
        nb.setVersion(this.getOption("application.version"));
        this.version = nb.build();
        return this;
    }

    public Locale getLocale() {
        String local = this.getOption(Option.LOCALE.key);
        Locale result = (Locale)ConverterUtil.convert(Locale.class, (Object)local);
        return result;
    }

    public void setLocale(String locale) {
        this.setOption(Option.LOCALE.key, locale);
    }

    public void setLocale(Locale newLocale) {
        this.setOption(Option.LOCALE.key, newLocale.toString());
        this.saveForUser(new String[0]);
        this.firePropertyChange("locale", null, newLocale);
    }

    public char getDecimalSeparator() {
        char decimalSeparator = this.getOption(Option.DECIMAL_SEPARATOR.key).charAt(0);
        return decimalSeparator;
    }

    public void setDecimalSeparator(String decimalSeparator) {
        this.setOption(Option.DECIMAL_SEPARATOR.key, decimalSeparator);
        this.optionsService.setDecimalSeparator(decimalSeparator);
        this.saveForUser(new String[0]);
        this.firePropertyChange("decimalSeparator", null, decimalSeparator);
    }

    public int getScale() {
        return this.getOptionAsInt(Option.SCALE.key);
    }

    public void setScale(String scale) {
        this.setOption(Option.SCALE.key, scale);
        this.optionsService.setScale(scale);
        this.saveForUser(new String[0]);
        this.firePropertyChange("scale", null, scale);
        if (log.isInfoEnabled()) {
            log.info((Object)("new scale" + scale));
        }
    }

    public char getThousandSeparator() {
        return this.getOption(Option.THOUSAND_SEPARATOR.key).charAt(0);
    }

    public void setThousandSeparator(String thousandSeparator) {
        this.setOption(Option.THOUSAND_SEPARATOR.key, thousandSeparator);
        this.optionsService.setThousandSeparator(thousandSeparator);
        this.saveForUser(new String[0]);
        this.firePropertyChange("thousandSeparator", null, thousandSeparator);
    }

    public boolean getCurrency() {
        return this.getOptionAsBoolean(Option.CURRENCY.key);
    }

    public void setCurrency(boolean currency) {
        this.setOption(Option.CURRENCY.key, Boolean.toString(currency));
        this.optionsService.setCurrency(currency);
        this.saveForUser(new String[0]);
        this.firePropertyChange("currency", null, currency);
    }

    public boolean isLaunchui() {
        boolean launchUI = this.getOptionAsBoolean(Option.LAUNCH_UI.key);
        return launchUI;
    }

    public void setLaunchui(String launchui) {
        this.setOption(Option.LAUNCH_UI.key, launchui);
    }

    public String getSupportEmail() {
        return this.getOption(Option.SUPPORT_EMAIL.key);
    }

    public boolean isEJBRemoteMode() {
        boolean result = this.getOptionAsBoolean(Option.OPENEJB_REMOTE_MODE.key);
        return result;
    }

    public File getDataDirectory() {
        File result = this.getOptionAsFile(Option.DATA_DIR.key);
        return result;
    }

    public File getLimaStateFile() {
        File result = this.getOptionAsFile(Option.LIMA_STATE_FILE.key);
        return result;
    }

    public File getResourcesDirectory() {
        File result = this.getOptionAsFile(Option.RESOURCES_DIRECTORY.key);
        return result;
    }

    public File getI18nDirectory() {
        File result = this.getOptionAsFile(Option.I18N_DIRECTORY.key);
        return result;
    }

    public String getHostAdress() {
        return this.getOption(Option.LIMA_HOST_ADDRESS.key);
    }

    public void setColorSelectionFocus(String color) {
        this.setOption(Option.COLOR_SELECTION_FOCUS.key, color);
    }

    public Color getColorSelectionFocus() {
        return this.getOptionAsColor(Option.COLOR_SELECTION_FOCUS.key);
    }

    public void setSelectAllEditingCell(boolean selectAllEditingCell) {
        this.setOption(Option.SELECT_ALL_EDITING_CELL.key, Boolean.toString(selectAllEditingCell));
    }

    public boolean isSelectAllEditingCell() {
        return this.getOptionAsBoolean(Option.SELECT_ALL_EDITING_CELL.key);
    }

    public File getReportsDir() {
        String reportsDirPath = this.getOption(Option.REPORTS_DIR.key);
        File reportsDir = new File(reportsDirPath);
        return reportsDir;
    }

    public String getAccountDocumentReportModelPath() {
        String result = this.getOption(Option.ACCOUNT_DOCUMENT_REPORT_MODEL_PATH.key);
        return result;
    }

    public String getBalanceDocumentReportModelPath() {
        String result = this.getOption(Option.BALANCE_DOCUMENT_REPORT_MODEL_PATH.key);
        return result;
    }

    public String getBalanceAccountReportModelPath() {
        String result = this.getOption(Option.BALANCE_ACCOUNT_REPORT_MODEL_PATH.key);
        return result;
    }

    public String getBalanceSubAccountReportModelPath() {
        String result = this.getOption(Option.BALANCE_SUB_ACCOUNT_REPORT_MODEL_PATH.key);
        return result;
    }

    public String getGeneralEntryBookDocumentReportModelPath() {
        String result = this.getOption(Option.GENERAL_ENTRY_BOOK_DOCUMENT_REPORT_MODEL_PATH.key);
        return result;
    }

    public String getGeneralEntryBookReportModelPath() {
        String result = this.getOption(Option.GENERAL_ENTRY_BOOK_REPORT_MODEL_PATH.key);
        return result;
    }

    public String getGeneralEntryBookGeneralEntryBookEntryReportPath() {
        String result = this.getOption(Option.GENERAL_ENTRY_BOOK_ENTRY_REPORT_MODEL_PATH.key);
        return result;
    }

    public String getProvisionalEntryBookEntryBookMainReportPath() {
        String result = this.getOption(Option.ENTRY_BOOK_DOCUMENT_REPORT_MODEL_PATH.getKey());
        return result;
    }

    public String getProvisionalEntryBookEntryBookReportPath() {
        String result = this.getOption(Option.ENTRY_BOOK_ENTRY_BOOK_REPORT_MODEL_PATH.getKey());
        return result;
    }

    public String getProvisionalEntryBookFinancialPeriodReportPath() {
        String result = this.getOption(Option.ENTRY_BOOK_FINANCIAL_PERIOD_REPORT_MODEL_PATH.getKey());
        return result;
    }

    public String getProvisionalEntryBookTransactionReportPath() {
        String result = this.getOption(Option.ENTRY_BOOK_TRANSACTION_REPORT_MODEL_PATH.getKey());
        return result;
    }

    public void removeJaxxPropertyChangeListener() {
        PropertyChangeListener[] toRemove = JAXXUtil.findJaxxPropertyChangeListener((String[])DEFAULT_JAXX_PCS, (PropertyChangeListener[])this.getPropertyChangeListeners());
        if (toRemove == null || toRemove.length == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("before remove : " + this.getPropertyChangeListeners().length));
            log.debug((Object)("toRemove : " + toRemove.length));
        }
        for (PropertyChangeListener listener : toRemove) {
            this.removePropertyChangeListener(listener);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("after remove : " + this.getPropertyChangeListeners().length));
        }
    }

    public void save(File file, boolean forceAll, String ... excludeKeys) throws IOException {
        super.save(file, forceAll, excludeKeys);
        this.optionsService = (OptionsService)LimaServiceFactory.getService(OptionsService.class);
        String scaleOption = this.getOption(Option.SCALE.key);
        if (StringUtils.isNotBlank((CharSequence)scaleOption)) {
            this.optionsService.setScale(scaleOption);
        }
    }

    static {
        DEFAULT_JAXX_PCS = new String[]{"fullScreen", "locale", "decimalSeparator", "scale", "thousandSeparator", "currency"};
    }

    public static enum Action {
        HELP(I18n.n((String)"lima.action.commandline.help", (Object[])new Object[0]), MiscAction.class.getName() + "#help", "-h", "--help");

        public static final int BEFORE_EXIT_STEP = 0;
        public static final int AFTER_INIT_STEP = 1;
        public String description;
        public String action;
        public String[] aliases;

        private Action(String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }

        public String getDescription() {
            return I18n.t((String)this.description, (Object[])new Object[0]);
        }
    }

    public static enum Option implements ConfigOptionDef
    {
        CONFIG_FILE("config.file", I18n.t((String)"lima.config.configFileName.label", (Object[])new Object[0]), I18n.n((String)"lima.config.configFileName.description", (Object[])new Object[0]), "lima-config.properties", String.class, true, true),
        DATA_DIR("lima.data.dir", I18n.t((String)"lima.config.data.dir.label", (Object[])new Object[0]), I18n.n((String)"lima.config.data.dir.description", (Object[])new Object[0]), "${user.home}/.lima", File.class, false, false),
        RESOURCES_DIRECTORY("lima.resources.dir", I18n.t((String)"lima.config.resources.dir.label", (Object[])new Object[0]), I18n.n((String)"lima.config.resources.dir.description", (Object[])new Object[0]), "${lima.data.dir}/resources-${application.version}", String.class, false, false),
        I18N_DIRECTORY("lima.i18n.dir", I18n.t((String)"lima.config.i18n.dir.label", (Object[])new Object[0]), I18n.n((String)"lima.config.i18n.dir.description", (Object[])new Object[0]), "${lima.resources.dir}/i18n", String.class, false, false),
        LOCALE("lima.ui.locale", I18n.t((String)"lima.config.locale.label", (Object[])new Object[0]), I18n.n((String)"lima.config.locale.description", (Object[])new Object[0]), "fr_FR", Locale.class, false, false),
        DECIMAL_SEPARATOR("lima.data.bigDecimal.decimalSeparator", I18n.t((String)"lima.config.decimalSeparator.label", (Object[])new Object[0]), I18n.n((String)"lima.config.decimalSeparator.description", (Object[])new Object[0]), ",", Character.class, false, false),
        SCALE("lima.data.bigDecimal.scale", I18n.t((String)"lima.config.scale.label", (Object[])new Object[0]), I18n.n((String)"lima.config.scale.description", (Object[])new Object[0]), "2", Integer.class, false, false),
        THOUSAND_SEPARATOR("lima.thousandSeparator", I18n.t((String)"lima.config.thousandSeparator.label", (Object[])new Object[0]), I18n.n((String)"lima.config.thousandSeparator.description", (Object[])new Object[0]), " ", Character.class, false, false),
        CURRENCY("lima.config.currency", I18n.t((String)"lima.config.currency.label", (Object[])new Object[0]), I18n.n((String)"lima.config.currency.description", (Object[])new Object[0]), "false", Boolean.class, false, false),
        LAUNCH_UI("lima.ui.launchui", I18n.t((String)"lima.config.ui.launchUi.label", (Object[])new Object[0]), I18n.n((String)"lima.config.ui.launchUi.description", (Object[])new Object[0]), "true", Boolean.class, true, true),
        SUPPORT_EMAIL("lima.email.support", I18n.t((String)"lima.email.support.label", (Object[])new Object[0]), I18n.n((String)"lima.email.support.description", (Object[])new Object[0]), "support@codelutin.com", String.class, false, false),
        OPENEJB_REMOTE_MODE("lima.openEjb.remote.mode", I18n.t((String)"lima.openEjb.remote.mode.label", (Object[])new Object[0]), I18n.n((String)"lima.openEjb.remote.mode.description", (Object[])new Object[0]), "false", String.class, false, false),
        LIMA_HOST_ADDRESS("lima.host.address", I18n.t((String)"lima.config.host.address.label", (Object[])new Object[0]), I18n.n((String)"lima.config.host.address.description", (Object[])new Object[0]), "localhost", String.class, false, false),
        LIMA_STATE_FILE("lima.ui.state.file", I18n.t((String)"lima.config.state.file.label", (Object[])new Object[0]), I18n.n((String)"lima.config.state.file.description", (Object[])new Object[0]), "${lima.data.dir}/limaState.xml", String.class, false, false),
        COLOR_SELECTION_FOCUS("lima.ui.table.cell.colorSelectionFocus", I18n.t((String)"lima.config.color.selection.focus.label", (Object[])new Object[0]), I18n.n((String)"lima.config.color.selection.focus.description", (Object[])new Object[0]), "#000000", Color.class, false, false),
        SELECT_ALL_EDITING_CELL("lima.ui.table.cell.selectAllEditingCell", I18n.t((String)"lima.config.selectAllEditingCell.label", (Object[])new Object[0]), I18n.n((String)"lima.config.selectAllEditingCell.description", (Object[])new Object[0]), "true", Boolean.class, false, false),
        TABLE_CELL_BACKGROUND("lima.ui.table.cell.background", I18n.t((String)"lima.config.cell.background.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.background.description", (Object[])new Object[0]), "#FFFFFF", Color.class, false, false),
        TABLE_CELL_FOREGROUND("lima.ui.table.cell.foreground", I18n.t((String)"lima.config.cell.foreground.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.foreground.description", (Object[])new Object[0]), "#000000", Color.class, false, false),
        TABLE_CELL_PAIR_BACKGROUND("lima.ui.table.cell.pair.background", I18n.t((String)"lima.config.cell.pair.background.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.pair.background.description", (Object[])new Object[0]), "#EEEEEE", Color.class, false, false),
        TABLE_CELL_PAIR_FOREGROUND("lima.ui.table.cell.pair.foreground", I18n.t((String)"lima.config.cell.pair.foreground.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.pair.foreground.description", (Object[])new Object[0]), "#000000", Color.class, false, false),
        TABLE_CELL_SELECTED_BACKGROUND("lima.ui.table.cell.selected.background", I18n.t((String)"lima.config.cell.selected.background.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.selected.background.description", (Object[])new Object[0]), "#0066CC", Color.class, false, false),
        TABLE_CELL_SELECTED_FOREGROUND("lima.ui.table.cell.selected.foreground", I18n.t((String)"lima.config.cell.selected.foreground.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.selected.foreground.description", (Object[])new Object[0]), "#FFFFFF", Color.class, false, false),
        TABLE_CELL_PAIR_SELECTED_BACKGROUND("lima.ui.table.cell.pair.selected.background", I18n.t((String)"lima.config.cell.pair.selected.background.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.pair.selected.background.description", (Object[])new Object[0]), "#006699", Color.class, false, false),
        TABLE_CELL_PAIR_SELECTED_FOREGROUND("lima.ui.table.cell.pair.selected.foreground", I18n.t((String)"lima.config.cell.pair.selected.foreground.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.pair.selected.foreground.description", (Object[])new Object[0]), "#FFFFFF", Color.class, false, false),
        TABLE_CELL_ERROR_BACKGROUND("lima.ui.table.cell.error.background", I18n.t((String)"lima.config.cell.error.background.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.error.background.description", (Object[])new Object[0]), "#FFFFFF", Color.class, false, false),
        TABLE_CELL_ERROR_FOREGROUND("lima.ui.table.cell.error.foreground", I18n.t((String)"lima.config.cell.error.foreground.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.error.foreground.description", (Object[])new Object[0]), "#FF0936", Color.class, false, false),
        TABLE_CELL_PAIR_ERROR_BACKGROUND("lima.ui.table.cell.pair.error.background", I18n.t((String)"lima.config.cell.pair.error.background.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.pair.error.background.description", (Object[])new Object[0]), "#EEEEEE", Color.class, false, false),
        TABLE_CELL_PAIR_ERROR_FOREGROUND("lima.ui.table.cell.pair.error.foreground", I18n.t((String)"lima.config.cell.pair.error.foreground.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.pair.error.foreground.description", (Object[])new Object[0]), "#FC0625", Color.class, false, false),
        TABLE_CELL_SELECTED_ERROR_BACKGROUND("lima.ui.table.cell.selected.error.background", I18n.t((String)"lima.config.cell.selected.error.background.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.selected.error.background.description", (Object[])new Object[0]), "#0066CC", Color.class, false, false),
        TABLE_CELL_SELECTED_ERROR_FOREGROUND("lima.ui.table.cell.selected.error.foreground", I18n.t((String)"lima.config.cell.selected.error.foreground.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.selected.error.foreground.description", (Object[])new Object[0]), "#C998C1", Color.class, false, false),
        TABLE_CELL_PAIR_SELECTED_ERROR_BACKGROUND("lima.ui.table.cell.pair.selected.error.background", I18n.t((String)"lima.config.cell.pair.selected.error.background.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.pair.selected.error.background.description", (Object[])new Object[0]), "#006699", Color.class, false, false),
        TABLE_CELL_PAIR_SELECTED_ERROR_FOREGROUND("lima.ui.table.cell.pair.selected.error.foreground", I18n.t((String)"lima.config.cell.pair.selected.error.foreground.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.pair.selected.error.foreground.description", (Object[])new Object[0]), "#C96678", Color.class, false, false),
        TABLE_CELL_MANDATORY_BACKGROUND("lima.ui.table.cell.mandatory.background", I18n.t((String)"lima.config.cell.mandatory.background.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.mandatory.background.description", (Object[])new Object[0]), "#FFCCCC", Color.class, false, false),
        TABLE_CELL_MANDATORY_FOREGROUND("lima.ui.table.cell.mandatory.foreground", I18n.t((String)"lima.config.cell.mandatory.foreground.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.mandatory.foreground.description", (Object[])new Object[0]), "#000000", Color.class, false, false),
        TABLE_CELL_PAIR_MANDATORY_BACKGROUND("lima.ui.table.cell.pair.mandatory.background", I18n.t((String)"lima.config.cell.pair.mandatory.background.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.pair.mandatory.background.description", (Object[])new Object[0]), "#FF99CC", Color.class, false, false),
        TABLE_CELL_PAIR_MANDATORY_FOREGROUND("lima.ui.table.cell.pair.mandatory.foreground", I18n.t((String)"lima.config.cell.pair.mandatory.foreground.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.pair.mandatory.foreground.description", (Object[])new Object[0]), "#000000", Color.class, false, false),
        TABLE_CELL_SELECTED_MANDATORY_BACKGROUND("lima.ui.table.cell.selected.mandatory.background", I18n.t((String)"lima.config.cell.selected.mandatory.background.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.selected.mandatory.background.description", (Object[])new Object[0]), "#FF0000", Color.class, false, false),
        TABLE_CELL_SELECTED_MANDATORY_FOREGROUND("lima.ui.table.cell.selected.mandatory.foreground", I18n.t((String)"lima.config.cell.selected.mandatory.foreground.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.selected.mandatory.foreground.description", (Object[])new Object[0]), "#FFFFFF", Color.class, false, false),
        TABLE_CELL_PAIR_SELECTED_MANDATORY_BACKGROUND("lima.ui.table.cell.pair.selected.mandatory.background", I18n.t((String)"lima.config.cell.pair.selected.mandatory.background.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.pair.selected.mandatory.background.description", (Object[])new Object[0]), "#990000", Color.class, false, false),
        TABLE_CELL_PAIR_SELECTED_MANDATORY_FOREGROUND("lima.ui.table.cell.pair.selected.mandatory.foreground", I18n.t((String)"lima.config.cell.pair.selected.mandatory.foreground.label", (Object[])new Object[0]), I18n.n((String)"lima.config.cell.pair.selected.mandatory.foreground.description", (Object[])new Object[0]), "#000000", Color.class, false, false),
        REPORTS_DIR("lima.reports.dir", "", I18n.n((String)"lima.config.reports.dir.description", (Object[])new Object[0]), "${lima.data.dir}/reports", File.class, false, false),
        ACCOUNT_DOCUMENT_REPORT_MODEL_PATH("lima.config.documentReport.account.documentReportModelPath", "", I18n.n((String)"lima.config.documentReport.account.documentReportModelPath.description", (Object[])new Object[0]), "/jasperreports/account/DocumentReport.jrxml", String.class, false, false),
        BALANCE_DOCUMENT_REPORT_MODEL_PATH("lima.config.documentReport.balance.documentReportModelPath", "", I18n.n((String)"lima.config.documentReport.balance.documentReportModelPath.description", (Object[])new Object[0]), "/jasperreports/balance/DocumentReport.jrxml", String.class, false, false),
        BALANCE_ACCOUNT_REPORT_MODEL_PATH("lima.config.documentReport.balance.balanceAccountReportModelPath", "", I18n.n((String)"lima.config.documentReport.balance.balanceAccountReportModelPath.description", (Object[])new Object[0]), "/jasperreports/balance/BalanceReportAccountReport.jrxml", String.class, false, false),
        BALANCE_SUB_ACCOUNT_REPORT_MODEL_PATH("lima.config.documentReport.balance.balanceSubAccountReportModelPath", "", I18n.n((String)"lima.config.documentReport.balance.balanceSubAccountReportModelPath.description", (Object[])new Object[0]), "/jasperreports/balance/BalanceSubAccountsReport.jrxml", String.class, false, false),
        GENERAL_ENTRY_BOOK_DOCUMENT_REPORT_MODEL_PATH("lima.config.documentReport.generalEntrybook.documentReportModelPath", "", I18n.n((String)"lima.config.documentReport.generalEntrybook.documentReportModelPath.description", (Object[])new Object[0]), "/jasperreports/generalEntryBook/DocumentReport.jrxml", String.class, false, false),
        GENERAL_ENTRY_BOOK_REPORT_MODEL_PATH("lima.config.documentReport.generalEntrybook.generalEntryBookModelPath", "", I18n.n((String)"lima.config.documentReport.generalEntrybook.generalEntryBookModelPath.description", (Object[])new Object[0]), "/jasperreports/generalEntryBook/EntryBookPeriodReport.jrxml", String.class, false, false),
        GENERAL_ENTRY_BOOK_ENTRY_REPORT_MODEL_PATH("lima.config.documentReport.generalEntrybook.generalEntryBookEntryModelPath", "", I18n.n((String)"blima.config.documentReport.generalEntrybook.generalEntryBookEntryModelPath.description", (Object[])new Object[0]), "/jasperreports/generalEntryBook/GeneralEntryBookEntryReport.jrxml", String.class, false, false),
        ENTRY_BOOK_DOCUMENT_REPORT_MODEL_PATH("lima.config.documentReport.entrybook.documentReportModelPath", "", I18n.n((String)"lima.config.documentReport.entrybook.documentReportModelPath.description", (Object[])new Object[0]), "/jasperreports/entryBook/DocumentReport.jrxml", String.class, false, false),
        ENTRY_BOOK_ENTRY_BOOK_REPORT_MODEL_PATH("lima.config.documentReport.entrybook.entryBookModelPath", "", I18n.n((String)"lima.config.documentReport.entrybook.entryBookModelPath.description", (Object[])new Object[0]), "/jasperreports/entryBook/EntryBookReport.jrxml", String.class, false, false),
        ENTRY_BOOK_FINANCIAL_PERIOD_REPORT_MODEL_PATH("lima.config.documentReport.entrybook.financialPeriodModelPath", "", I18n.n((String)"lima.config.documentReport.entrybook.financialPeriodModelPath.description", (Object[])new Object[0]), "/jasperreports/entryBook/FinancialPeriodReport.jrxml", String.class, false, false),
        ENTRY_BOOK_TRANSACTION_REPORT_MODEL_PATH("lima.config.documentReport.entrybook.transactionReportModelPath", "", I18n.n((String)"lima.config.documentReport.entrybook.transactionReportModelPath.description", (Object[])new Object[0]), "/jasperreports/entryBook/TransactionReport.jrxml", String.class, false, false);

        protected final String key;
        protected final String label;
        protected final String description;
        protected String defaultValue;
        protected final Class<?> type;
        protected boolean _transient;
        protected boolean _final;

        private Option(String key, String label, String description, String defaultValue, Class<?> type, boolean _transient, boolean _final) {
            this.key = key;
            this.label = label;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this._final = _final;
            this._transient = _transient;
        }

        public boolean isFinal() {
            return this._final;
        }

        public void setFinal(boolean _final) {
            this._final = _final;
        }

        public boolean isTransient() {
            return this._transient;
        }

        public void setTransient(boolean _transient) {
            this._transient = _transient;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return I18n.t((String)this.description, (Object[])new Object[0]);
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }

        protected static enum ComportmentEditingCellEnum {
            ALL,
            NOTHING;

        }
    }
}

