package org.chorem.lima.ui.financialtransaction;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.common.EntryBookComboBoxModel;
import org.chorem.lima.ui.common.EntryBookListRenderer;
import org.chorem.lima.ui.common.FinancialPeriodComboBoxModel;
import org.chorem.lima.ui.common.FinancialTransactionTableModel;
import org.chorem.lima.ui.common.FiscalPeriodComboBoxModel;
import static org.nuiton.i18n.I18n.t;

public class FinancialTransactionView extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ASSIGNABLE_IN_ALL_ENTRIES = "assignableInAllEntries";
    public static final String PROPERTY_BALANCE = "balance";
    public static final String PROPERTY_ENTRY_IN_CLIP_BOARD = "entryInClipBoard";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";
    public static final String PROPERTY_STATUS_TEXT = "statusText";
    public static final String PROPERTY_TRANSACTION_IN_CLIP_BOARD = "transactionInClipBoard";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ENTRY_ENABLED = "addEntry.enabled";
    public static final String BINDING_ASSIGN_ENTRIES_ENABLED = "assignEntries.enabled";
    public static final String BINDING_BALANCE_BUTTON_ENABLED = "balanceButton.enabled";
    public static final String BINDING_COPY_ENTRY_ENABLED = "copyEntry.enabled";
    public static final String BINDING_COPY_TRANSACTION_ENABLED = "copyTransaction.enabled";
    public static final String BINDING_PASTE_ENTRY_ENABLED = "pasteEntry.enabled";
    public static final String BINDING_PAST_TRANSACTION_ENABLED = "pastTransaction.enabled";
    public static final String BINDING_REMOVE_ENTRY_ENABLED = "removeEntry.enabled";
    public static final String BINDING_REMOVE_TRANSACTION_ENABLED = "removeTransaction.enabled";
    public static final String BINDING_STATUS_LABEL_TEXT = "statusLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(FinancialTransactionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addEntry;
    protected JButton addTransaction;
    protected JButton assignEntries;
    protected Boolean assignableInAllEntries;
    protected JButton back;
    protected Boolean balance;
    protected JButton balanceButton;
    protected JButton copyEntry;
    protected JButton copyTransaction;
    protected JComboBox entryBookComboBox;
    protected EntryBookComboBoxModel entryBookComboBoxModel;
    protected JLabel entryBookLabel;
    protected Boolean entryInClipBoard;
    protected JComboBox financialPeriodComboBox;
    protected FinancialPeriodComboBoxModel financialPeriodComboBoxModel;
    protected JLabel financialPeriodLabel;
    protected FinancialTransactionTable financialTransactionTable;
    protected FinancialTransactionTableModel financialTransactionTableModel;
    protected JComboBox fiscalPeriodComboBox;
    protected FiscalPeriodComboBoxModel fiscalPeriodComboBoxModel;
    protected JLabel fiscalPeriodLabel;
    protected FinancialTransactionViewHandler handler;
    protected JButton next;
    protected JButton pastTransaction;
    protected JButton pasteEntry;
    protected JButton removeEntry;
    protected JButton removeTransaction;
    protected Boolean selectedRow;
    protected ListSelectionModel selectionModel;
    protected JLabel statusLabel;
    protected String statusText;
    protected JToolBar toolbar;
    protected Boolean transactionInClipBoard;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FinancialTransactionView $JPanel0 = this;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;
    private Separator $JToolBar$Separator0;
    private Separator $JToolBar$Separator1;
    private Separator $JToolBar$Separator2;
    private Separator $JToolBar$Separator3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            handler.init();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialTransactionView(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialTransactionView(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionView() {
        $initialize();
    }

    public FinancialTransactionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionView(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FinancialTransactionView(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialTransactionView(boolean param0) {
        super(param0);
        $initialize();
    }

    public FinancialTransactionView(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addEntry(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addEntry();
    }

    public void doActionPerformed__on__addTransaction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addFinancialTransaction();
    }

    public void doActionPerformed__on__assignEntries(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.assignAllEntries();
    }

    public void doActionPerformed__on__back(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.back(financialPeriodComboBox);
    }

    public void doActionPerformed__on__balanceButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.balanceTransaction();
    }

    public void doActionPerformed__on__copyEntry(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.copyEntry();
    }

    public void doActionPerformed__on__copyTransaction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.copyTransaction();
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.next(financialPeriodComboBox);
    }

    public void doActionPerformed__on__pastTransaction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.pasteTransaction();
    }

    public void doActionPerformed__on__pasteEntry(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.pasteEntry();
    }

    public void doActionPerformed__on__removeEntry(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.deleteSelectedEntry();
    }

    public void doActionPerformed__on__removeTransaction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.deleteSelectedTransaction();
    }

    public void doItemStateChanged__on__entryBookComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.entryBookSelected(event);
    }

    public void doItemStateChanged__on__financialPeriodComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.financialPeriodSelected(event);
    }

    public void doItemStateChanged__on__fiscalPeriodComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.fiscalPeriodSelected(event);
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectionChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddEntry() {
        return addEntry;
    }

    public JButton getAddTransaction() {
        return addTransaction;
    }

    public JButton getAssignEntries() {
        return assignEntries;
    }

    public Boolean getAssignableInAllEntries() {
        return assignableInAllEntries;
    }

    public JButton getBack() {
        return back;
    }

    public Boolean getBalance() {
        return balance;
    }

    public JButton getBalanceButton() {
        return balanceButton;
    }

    public JButton getCopyEntry() {
        return copyEntry;
    }

    public JButton getCopyTransaction() {
        return copyTransaction;
    }

    public JComboBox getEntryBookComboBox() {
        return entryBookComboBox;
    }

    public EntryBookComboBoxModel getEntryBookComboBoxModel() {
        return entryBookComboBoxModel;
    }

    public JLabel getEntryBookLabel() {
        return entryBookLabel;
    }

    public Boolean getEntryInClipBoard() {
        return entryInClipBoard;
    }

    public JComboBox getFinancialPeriodComboBox() {
        return financialPeriodComboBox;
    }

    public FinancialPeriodComboBoxModel getFinancialPeriodComboBoxModel() {
        return financialPeriodComboBoxModel;
    }

    public JLabel getFinancialPeriodLabel() {
        return financialPeriodLabel;
    }

    public FinancialTransactionTable getFinancialTransactionTable() {
        return financialTransactionTable;
    }

    public FinancialTransactionTableModel getFinancialTransactionTableModel() {
        return financialTransactionTableModel;
    }

    public JComboBox getFiscalPeriodComboBox() {
        return fiscalPeriodComboBox;
    }

    public FiscalPeriodComboBoxModel getFiscalPeriodComboBoxModel() {
        return fiscalPeriodComboBoxModel;
    }

    public JLabel getFiscalPeriodLabel() {
        return fiscalPeriodLabel;
    }

    public FinancialTransactionViewHandler getHandler() {
        return handler;
    }

    public JButton getNext() {
        return next;
    }

    public JButton getPastTransaction() {
        return pastTransaction;
    }

    public JButton getPasteEntry() {
        return pasteEntry;
    }

    public JButton getRemoveEntry() {
        return removeEntry;
    }

    public JButton getRemoveTransaction() {
        return removeTransaction;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public JLabel getStatusLabel() {
        return statusLabel;
    }

    public String getStatusText() {
        return statusText;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public Boolean getTransactionInClipBoard() {
        return transactionInClipBoard;
    }

    public Boolean isAssignableInAllEntries() {
        return assignableInAllEntries !=null && assignableInAllEntries;
    }

    public Boolean isBalance() {
        return balance !=null && balance;
    }

    public Boolean isEntryInClipBoard() {
        return entryInClipBoard !=null && entryInClipBoard;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    public Boolean isTransactionInClipBoard() {
        return transactionInClipBoard !=null && transactionInClipBoard;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAssignableInAllEntries(Boolean assignableInAllEntries) {
        Boolean oldValue = this.assignableInAllEntries;
        this.assignableInAllEntries = assignableInAllEntries;
        firePropertyChange(PROPERTY_ASSIGNABLE_IN_ALL_ENTRIES, oldValue, assignableInAllEntries);
    }

    public void setBalance(Boolean balance) {
        Boolean oldValue = this.balance;
        this.balance = balance;
        firePropertyChange(PROPERTY_BALANCE, oldValue, balance);
    }

    public void setEntryInClipBoard(Boolean entryInClipBoard) {
        Boolean oldValue = this.entryInClipBoard;
        this.entryInClipBoard = entryInClipBoard;
        firePropertyChange(PROPERTY_ENTRY_IN_CLIP_BOARD, oldValue, entryInClipBoard);
    }

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    public void setStatusText(String statusText) {
        String oldValue = this.statusText;
        this.statusText = statusText;
        firePropertyChange(PROPERTY_STATUS_TEXT, oldValue, statusText);
    }

    public void setTransactionInClipBoard(Boolean transactionInClipBoard) {
        Boolean oldValue = this.transactionInClipBoard;
        this.transactionInClipBoard = transactionInClipBoard;
        firePropertyChange(PROPERTY_TRANSACTION_IN_CLIP_BOARD, oldValue, transactionInClipBoard);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected Separator get$JToolBar$Separator1() {
        return $JToolBar$Separator1;
    }

    protected Separator get$JToolBar$Separator2() {
        return $JToolBar$Separator2;
    }

    protected Separator get$JToolBar$Separator3() {
        return $JToolBar$Separator3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(addTransaction);
        toolbar.add(removeTransaction);
        toolbar.add(copyTransaction);
        toolbar.add(pastTransaction);
        toolbar.add($JToolBar$Separator0);
        toolbar.add(addEntry);
        toolbar.add(removeEntry);
        toolbar.add(copyEntry);
        toolbar.add(pasteEntry);
        toolbar.add(assignEntries);
        toolbar.add($JToolBar$Separator1);
        toolbar.add(balanceButton);
        toolbar.add($JToolBar$Separator2);
        toolbar.add(fiscalPeriodLabel);
        toolbar.add(fiscalPeriodComboBox);
        toolbar.add(financialPeriodLabel);
        toolbar.add(financialPeriodComboBox);
        toolbar.add(back);
        toolbar.add(next);
        toolbar.add($JToolBar$Separator3);
        toolbar.add(entryBookLabel);
        toolbar.add(entryBookComboBox);
    }

    protected void createAddEntry() {
        $objectMap.put("addEntry", addEntry = new JButton());
        
        addEntry.setName("addEntry");
        addEntry.setToolTipText(t("lima.entries.addEntry"));
        addEntry.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addEntry"));
    }

    protected void createAddTransaction() {
        $objectMap.put("addTransaction", addTransaction = new JButton());
        
        addTransaction.setName("addTransaction");
        addTransaction.setToolTipText(t("lima.entries.addTransaction"));
        addTransaction.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addTransaction"));
    }

    protected void createAssignEntries() {
        $objectMap.put("assignEntries", assignEntries = new JButton());
        
        assignEntries.setName("assignEntries");
        assignEntries.setToolTipText(t("lima.entries.assign.entries"));
        assignEntries.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__assignEntries"));
    }

    protected void createAssignableInAllEntries() {
        $objectMap.put("assignableInAllEntries", assignableInAllEntries = false);
    }

    protected void createBack() {
        $objectMap.put("back", back = new JButton());
        
        back.setName("back");
        back.setToolTipText(t("lima.financialTransaction.previousFinancialPeriod"));
        back.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__back"));
    }

    protected void createBalance() {
        $objectMap.put("balance", balance = true);
    }

    protected void createBalanceButton() {
        $objectMap.put("balanceButton", balanceButton = new JButton());
        
        balanceButton.setName("balanceButton");
        balanceButton.setToolTipText(t("lima.entries.balance"));
        balanceButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__balanceButton"));
    }

    protected void createCopyEntry() {
        $objectMap.put("copyEntry", copyEntry = new JButton());
        
        copyEntry.setName("copyEntry");
        copyEntry.setToolTipText(t("lima.entries.copy.entry"));
        copyEntry.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__copyEntry"));
    }

    protected void createCopyTransaction() {
        $objectMap.put("copyTransaction", copyTransaction = new JButton());
        
        copyTransaction.setName("copyTransaction");
        copyTransaction.setToolTipText(t("lima.entries.copy.transaction"));
        copyTransaction.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__copyTransaction"));
    }

    protected void createEntryBookComboBox() {
        $objectMap.put("entryBookComboBox", entryBookComboBox = new JComboBox());
        
        entryBookComboBox.setName("entryBookComboBox");
        entryBookComboBox.setToolTipText(t("lima.entries.entryBook"));
        entryBookComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__entryBookComboBox"));
    }

    protected void createEntryBookComboBoxModel() {
        $objectMap.put("entryBookComboBoxModel", entryBookComboBoxModel = new EntryBookComboBoxModel());
    }

    protected void createEntryBookLabel() {
        $objectMap.put("entryBookLabel", entryBookLabel = new JLabel());
        
        entryBookLabel.setName("entryBookLabel");
    }

    protected void createEntryInClipBoard() {
        $objectMap.put("entryInClipBoard", entryInClipBoard = false);
    }

    protected void createFinancialPeriodComboBox() {
        $objectMap.put("financialPeriodComboBox", financialPeriodComboBox = new JComboBox());
        
        financialPeriodComboBox.setName("financialPeriodComboBox");
        financialPeriodComboBox.setToolTipText(t("lima.entries.financialPeriod"));
        financialPeriodComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__financialPeriodComboBox"));
    }

    protected void createFinancialPeriodComboBoxModel() {
        $objectMap.put("financialPeriodComboBoxModel", financialPeriodComboBoxModel = new FinancialPeriodComboBoxModel());
    }

    protected void createFinancialPeriodLabel() {
        $objectMap.put("financialPeriodLabel", financialPeriodLabel = new JLabel());
        
        financialPeriodLabel.setName("financialPeriodLabel");
    }

    protected void createFinancialTransactionTable() {
        $objectMap.put("financialTransactionTable", financialTransactionTable = new FinancialTransactionTable(handler));
        
        financialTransactionTable.setName("financialTransactionTable");
        financialTransactionTable.setRowHeight(22);
    }

    protected void createFinancialTransactionTableModel() {
        $objectMap.put("financialTransactionTableModel", financialTransactionTableModel = new FinancialTransactionTableModel());
    }

    protected void createFiscalPeriodComboBox() {
        $objectMap.put("fiscalPeriodComboBox", fiscalPeriodComboBox = new JComboBox());
        
        fiscalPeriodComboBox.setName("fiscalPeriodComboBox");
        fiscalPeriodComboBox.setToolTipText(t("lima.entries.fiscalYear"));
        fiscalPeriodComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fiscalPeriodComboBox"));
    }

    protected void createFiscalPeriodComboBoxModel() {
        $objectMap.put("fiscalPeriodComboBoxModel", fiscalPeriodComboBoxModel = new FiscalPeriodComboBoxModel());
    }

    protected void createFiscalPeriodLabel() {
        $objectMap.put("fiscalPeriodLabel", fiscalPeriodLabel = new JLabel());
        
        fiscalPeriodLabel.setName("fiscalPeriodLabel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialTransactionViewHandler(this));
    }

    protected void createNext() {
        $objectMap.put("next", next = new JButton());
        
        next.setName("next");
        next.setToolTipText(t("lima.financialTransaction.nextFinancialPeriod"));
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createPastTransaction() {
        $objectMap.put("pastTransaction", pastTransaction = new JButton());
        
        pastTransaction.setName("pastTransaction");
        pastTransaction.setToolTipText(t("lima.entries.paste.transaction"));
        pastTransaction.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__pastTransaction"));
    }

    protected void createPasteEntry() {
        $objectMap.put("pasteEntry", pasteEntry = new JButton());
        
        pasteEntry.setName("pasteEntry");
        pasteEntry.setToolTipText(t("lima.entries.paste.entry"));
        pasteEntry.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__pasteEntry"));
    }

    protected void createRemoveEntry() {
        $objectMap.put("removeEntry", removeEntry = new JButton());
        
        removeEntry.setName("removeEntry");
        removeEntry.setToolTipText(t("lima.entries.remove.entry"));
        removeEntry.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeEntry"));
    }

    protected void createRemoveTransaction() {
        $objectMap.put("removeTransaction", removeTransaction = new JButton());
        
        removeTransaction.setName("removeTransaction");
        removeTransaction.setToolTipText(t("lima.entries.remove.transaction"));
        removeTransaction.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeTransaction"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createStatusLabel() {
        $objectMap.put("statusLabel", statusLabel = new JLabel());
        
        statusLabel.setName("statusLabel");
    }

    protected void createStatusText() {
        $objectMap.put("statusText", statusText = new String());
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
    }

    protected void createTransactionInClipBoard() {
        $objectMap.put("transactionInClipBoard", transactionInClipBoard = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(toolbar, BorderLayout.PAGE_START);
        add($JScrollPane0, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
        addChildrenToToolbar();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(financialTransactionTable);
        // inline complete setup of $JPanel1
        $JPanel1.add(statusLabel, BorderLayout.EAST);
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 31 property setters
        selectionModel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        fiscalPeriodComboBox.setModel(fiscalPeriodComboBoxModel);
        financialPeriodComboBox.setModel(financialPeriodComboBoxModel);
        entryBookComboBox.setModel(entryBookComboBoxModel);
        financialTransactionTable.setModel(financialTransactionTableModel);
        financialTransactionTable.setSelectionModel(selectionModel);
        addTransaction.setIcon(SwingUtil.createActionIcon("add-financial-transaction"));
        removeTransaction.setIcon(SwingUtil.createActionIcon("delete-financial-transaction"));
        copyTransaction.setIcon(SwingUtil.createActionIcon("copy"));
        pastTransaction.setIcon(SwingUtil.createActionIcon("paste"));
        addEntry.setIcon(SwingUtil.createActionIcon("add-entry"));
        removeEntry.setIcon(SwingUtil.createActionIcon("delete-entry"));
        copyEntry.setIcon(SwingUtil.createActionIcon("copy"));
        pasteEntry.setIcon(SwingUtil.createActionIcon("paste"));
        assignEntries.setIcon(SwingUtil.createActionIcon("assign-all-entries-in-transaction"));
        balanceButton.setIcon(SwingUtil.createActionIcon("balance"));
        fiscalPeriodLabel.setLabelFor(fiscalPeriodComboBox);
        fiscalPeriodLabel.setIcon(SwingUtil.createActionIcon("choose-fiscal-year"));
        fiscalPeriodComboBox.setRenderer(new org.chorem.lima.ui.common.FiscalPeriodListRenderer());
        financialPeriodLabel.setLabelFor(financialPeriodComboBox);
        financialPeriodLabel.setIcon(SwingUtil.createActionIcon("choose-fiscal-period"));
        financialPeriodComboBox.setRenderer(new org.chorem.lima.ui.common.FinancialPeriodListRenderer());
        back.setIcon(SwingUtil.createActionIcon("previous"));
        next.setIcon(SwingUtil.createActionIcon("next"));
        entryBookLabel.setLabelFor(entryBookComboBox);
        entryBookLabel.setIcon(SwingUtil.createActionIcon("choose-book"));
        entryBookComboBox.setRenderer(new org.chorem.lima.ui.common.EntryBookListRenderer());
        statusLabel.setHorizontalTextPosition(JLabel.RIGHT);
        statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createSelectionModel();
        createSelectedRow();
        createTransactionInClipBoard();
        createEntryInClipBoard();
        createBalance();
        createAssignableInAllEntries();
        createToolbar();
        createAddTransaction();
        createRemoveTransaction();
        createCopyTransaction();
        createPastTransaction();
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        createAddEntry();
        createRemoveEntry();
        createCopyEntry();
        createPasteEntry();
        createAssignEntries();
        // inline creation of $JToolBar$Separator1
        $objectMap.put("$JToolBar$Separator1", $JToolBar$Separator1 = new Separator());
        
        $JToolBar$Separator1.setName("$JToolBar$Separator1");
        createBalanceButton();
        // inline creation of $JToolBar$Separator2
        $objectMap.put("$JToolBar$Separator2", $JToolBar$Separator2 = new Separator());
        
        $JToolBar$Separator2.setName("$JToolBar$Separator2");
        createFiscalPeriodLabel();
        createFiscalPeriodComboBoxModel();
        createFiscalPeriodComboBox();
        createFinancialPeriodLabel();
        createFinancialPeriodComboBoxModel();
        createFinancialPeriodComboBox();
        createBack();
        createNext();
        // inline creation of $JToolBar$Separator3
        $objectMap.put("$JToolBar$Separator3", $JToolBar$Separator3 = new Separator());
        
        $JToolBar$Separator3.setName("$JToolBar$Separator3");
        createEntryBookLabel();
        createEntryBookComboBoxModel();
        createEntryBookComboBox();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFinancialTransactionTableModel();
        createFinancialTransactionTable();
        createStatusText();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createStatusLabel();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_TRANSACTION_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                removeTransaction.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COPY_TRANSACTION_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                copyTransaction.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PAST_TRANSACTION_ENABLED, true ,"transactionInClipBoard") {
        
            @Override
            public void processDataBinding() {
                pastTransaction.setEnabled(isTransactionInClipBoard());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_ENTRY_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                addEntry.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ENTRY_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                removeEntry.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COPY_ENTRY_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                copyEntry.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PASTE_ENTRY_ENABLED, true ,"entryInClipBoard" ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                pasteEntry.setEnabled(isEntryInClipBoard() && isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ASSIGN_ENTRIES_ENABLED, true ,"assignableInAllEntries" ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                assignEntries.setEnabled(isAssignableInAllEntries() && isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BALANCE_BUTTON_ENABLED, true ,"balance") {
        
            @Override
            public void processDataBinding() {
                balanceButton.setEnabled(!isBalance());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STATUS_LABEL_TEXT, true ,"statusText") {
        
            @Override
            public void processDataBinding() {
                statusLabel.setText(t(getStatusText()));
            }
        });
    }

}