/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.lettering;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.chorem.lima.LimaContext;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.util.decorator.DecoratorProvider;

public class LetteringTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected Date selectedBeginDate;
    protected Date selectedEndDate;
    protected List<Entry> entries;
    protected List<Date> datesEntree;
    protected List<String> entryBooks;
    protected final Decorator<Account> accountDecorator;

    public LetteringTableModel() {
        DecoratorProvider decoratorProvider = LimaContext.get().getDecoratorProvider();
        this.accountDecorator = decoratorProvider.getDecoratorByType(Account.class);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public Date getDateEntree(int row) {
        return this.datesEntree.get(row);
    }

    public Integer getIndexOfEntry(Entry entrySearch) {
        return this.entries.indexOf(entrySearch);
    }

    public int getNumberOfEntries() {
        return this.entries.size();
    }

    public void updateEntries(List<Entry> entries, List<Date> datesEntree, List<String> entryBooks) {
        this.entries = entries;
        this.setDate(datesEntree);
        this.setJournal(entryBooks);
        this.fireTableDataChanged();
    }

    protected void setDate(List<Date> datesEntree) {
        this.datesEntree = datesEntree;
    }

    protected void setJournal(List<String> entryBooks) {
        this.entryBooks = entryBooks;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    public Entry getEntryAt(int row) {
        if (row == -1) {
            return null;
        }
        return this.entries.get(row);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class result = String.class;
        switch (column) {
            case 0: {
                result = Date.class;
                break;
            }
            case 1: {
                result = String.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            case 3: {
                result = Account.class;
                break;
            }
            case 4: {
                result = String.class;
                break;
            }
            case 5: {
                result = BigDecimal.class;
                break;
            }
            case 6: {
                result = BigDecimal.class;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String result = "n/a";
        switch (column) {
            case 0: {
                result = I18n._((String)"lima.table.date", (Object[])new Object[0]);
                break;
            }
            case 1: {
                result = I18n._((String)"lima.table.account", (Object[])new Object[0]);
                break;
            }
            case 2: {
                result = I18n._((String)"lima.table.voucher", (Object[])new Object[0]);
                break;
            }
            case 3: {
                result = I18n._((String)"lima.table.description", (Object[])new Object[0]);
                break;
            }
            case 4: {
                result = I18n._((String)"lima.table.letter", (Object[])new Object[0]);
                break;
            }
            case 5: {
                result = I18n._((String)"lima.table.debit", (Object[])new Object[0]);
                break;
            }
            case 6: {
                result = I18n._((String)"lima.table.credit", (Object[])new Object[0]);
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        if (this.entries != null) {
            return this.entries.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (this.entries.size() > 0) {
            Entry currentEntry = this.entries.get(row);
            switch (column) {
                case 0: {
                    result = this.datesEntree.get(row);
                    break;
                }
                case 1: {
                    Account acc = currentEntry.getAccount();
                    result = this.accountDecorator.toString((Object)acc);
                    break;
                }
                case 2: {
                    result = currentEntry.getVoucher();
                    break;
                }
                case 3: {
                    result = currentEntry.getDescription();
                    break;
                }
                case 4: {
                    result = currentEntry.getLettering();
                    break;
                }
                case 5: {
                    result = currentEntry.getDebit() ? currentEntry.getAmount() : BigDecimal.ZERO;
                    break;
                }
                case 6: {
                    result = currentEntry.getDebit() ? BigDecimal.ZERO : currentEntry.getAmount();
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getElementAt(int row) {
        return this.entries.get(row);
    }

    public void addEntry(Entry entry, Date dateEntree) {
        this.entries.add(entry);
        this.datesEntree.add(dateEntree);
        int row = this.entries.indexOf(entry);
        this.fireTableRowsInserted(row, row);
    }

    public void updateLettersSelectedEntries(int[] entries, String letters) {
        for (int rowEntry : entries) {
            this.getEntryAt(rowEntry).setLettering(letters);
            this.fireTableRowsUpdated(rowEntry, rowEntry);
        }
    }
}

