/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.util.List;
import org.chorem.lima.beans.FinancialTransactionCondition;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialtransaction.AccountColumn;
import org.chorem.lima.ui.financialtransaction.BalanceColumn;
import org.chorem.lima.ui.financialtransaction.CreditColumn;
import org.chorem.lima.ui.financialtransaction.DateColumn;
import org.chorem.lima.ui.financialtransaction.DebitColumn;
import org.chorem.lima.ui.financialtransaction.DescriptionColumn;
import org.chorem.lima.ui.financialtransaction.EntryBookColumn;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.chorem.lima.ui.financialtransaction.LetterColumn;
import org.chorem.lima.ui.financialtransaction.VoucherColumn;

public class FinancialTransactionSearchTableModel
extends FinancialTransactionTableModel {
    private static final long serialVersionUID = 1L;
    protected final FinancialPeriodService financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
    protected FiscalPeriod selectedFiscalPeriod;
    protected FinancialTransactionCondition financialTransactionCondition;

    protected void refresh(FinancialTransactionCondition financialTransactionCondition) {
        this.financialTransactionCondition = financialTransactionCondition;
        List transactions = this.financialTransactionService.searchFinancialTransaction(this.financialTransactionCondition);
        this.setTransactions(transactions);
    }

    @Override
    protected void initColumns() {
        this.columns.add(new DateColumn(this));
        this.columns.add(new EntryBookColumn(this));
        this.columns.add(new VoucherColumn(this));
        this.columns.add(new AccountColumn(this));
        this.columns.add(new DescriptionColumn(this));
        this.columns.add(new LetterColumn(this));
        this.columns.add(new DebitColumn(this));
        this.columns.add(new CreditColumn(this));
        this.columns.add(new BalanceColumn(this));
    }

    public void setFiscalPeriod(FiscalPeriod fiscalPeriod) {
        this.selectedFiscalPeriod = fiscalPeriod;
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if ((serviceName.contains("FinancialTransaction") || methodeName.contains("importEntries") || methodeName.contains("importAll")) && !methodeName.contains("search")) {
            this.refresh(this.financialTransactionCondition);
        }
    }
}

