/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.celleditor.EntryTableCellRenderer;
import org.chorem.lima.ui.celleditor.StringTableCellEditor;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionColumn;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.nuiton.i18n.I18n;

public class LetterColumn
extends FinancialTransactionColumn {
    public LetterColumn(FinancialTransactionTableModel tableModel) {
        super(tableModel);
        this.renderer = new EntryTableCellRenderer();
        this.editor = new StringTableCellEditor();
    }

    @Override
    public Class<?> getColumnClass() {
        return String.class;
    }

    @Override
    public String getColumnName() {
        return I18n._((String)"lima.table.letter", (Object[])new Object[0]);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = this.tableModel.getEntryAt(row);
        return entry.getLettering();
    }

    @Override
    public boolean isCellEditable(int row) {
        return true;
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        boolean update;
        Entry entry = this.tableModel.getEntryAt(row);
        String letter = ((String)value).trim();
        boolean bl = update = entry.getLettering() == null || entry.getLettering().compareTo(letter) != 0;
        if (update) {
            entry.setLettering(letter);
            this.tableModel.updateEntry(entry);
        }
        return update;
    }
}

