/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.common.CellRouteHorizontalAction;
import org.chorem.lima.ui.common.CellRouteVerticalAction;
import org.chorem.lima.ui.common.Column;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTable;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;

public class FinancialTransactionDefaultTable
extends JTable {
    private static final long serialVersionUID = 3133690382049594727L;
    private static final Log log = LogFactory.getLog(FinancialTransactionTable.class);

    public FinancialTransactionDefaultTable() {
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
        this.setGridColor(new Color(210, 210, 210));
        this.initNavigation();
        this.addMouseListener(new MyMouseAdapter());
    }

    protected void initNavigation() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        Object binding = inputMap.get(KeyStroke.getKeyStroke(9, 0));
        actionMap.put(binding, new CellRouteHorizontalAction(this, true));
        binding = inputMap.get(KeyStroke.getKeyStroke(9, 64));
        actionMap.put(binding, new CellRouteHorizontalAction(this, false));
        binding = inputMap.get(KeyStroke.getKeyStroke(10, 0));
        actionMap.put(binding, new CellRouteVerticalAction(this, true));
        binding = inputMap.get(KeyStroke.getKeyStroke(10, 64));
        actionMap.put(binding, new CellRouteVerticalAction(this, false));
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        FinancialTransactionTableModel tableModel = (FinancialTransactionTableModel)this.getModel();
        Column columnTable = tableModel.getColumn(column);
        TableCellRenderer renderer = columnTable.getCellRenderer(row);
        if (renderer == null) {
            renderer = super.getCellRenderer(row, column);
        }
        return renderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        FinancialTransactionTableModel tableModel = (FinancialTransactionTableModel)this.getModel();
        Column columnTable = tableModel.getColumn(column);
        TableCellEditor editor = columnTable.getCellEditor(row);
        if (editor == null) {
            editor = super.getCellEditor(row, column);
        }
        return editor;
    }

    public void exit() {
        if (this.isEditing()) {
            TableCellEditor editor = this.getCellEditor();
            editor.stopCellEditing();
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (FinancialTransactionDefaultTable.this.rowAtPoint(e.getPoint()) == -1) {
                FinancialTransactionDefaultTable.this.clearSelection();
            }
        }
    }
}

