/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.celleditor.EntryBookTableCellEditor;
import org.chorem.lima.ui.celleditor.EntryBookTableCellRender;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionColumn;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.nuiton.i18n.I18n;

public class EntryBookColumn
extends FinancialTransactionColumn {
    public EntryBookColumn(FinancialTransactionTableModel tableModel) {
        super(tableModel);
        this.renderer = new EntryBookTableCellRender();
        this.editor = new EntryBookTableCellEditor();
    }

    @Override
    public Class<?> getColumnClass() {
        return EntryBook.class;
    }

    @Override
    public String getColumnName() {
        return I18n._((String)"lima.table.entrybook", (Object[])new Object[0]);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = this.tableModel.getEntryAt(row);
        FinancialTransaction transaction = entry.getFinancialTransaction();
        Object result = row == 0 || this.tableModel.getEntryAt(row - 1).getFinancialTransaction() != transaction ? transaction.getEntryBook() : null;
        return result;
    }

    @Override
    public boolean isCellEditable(int row) {
        return row == 0 || this.tableModel.getEntryAt(row).getFinancialTransaction() != this.tableModel.getEntryAt(row - 1).getFinancialTransaction();
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        boolean update;
        FinancialTransaction transaction = this.tableModel.getTransactionAt(row);
        EntryBook entryBook = (EntryBook)value;
        boolean bl = update = transaction.getEntryBook().getCode().compareTo(entryBook.getCode()) != 0;
        if (update) {
            transaction.setEntryBook(entryBook);
            this.tableModel.updateTransaction(transaction);
        }
        return update;
    }
}

