/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.celleditor.EntryTableCellRenderer;
import org.chorem.lima.ui.celleditor.StringTableCellEditor;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionColumn;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.nuiton.i18n.I18n;

public class DescriptionColumn
extends FinancialTransactionColumn {
    public DescriptionColumn(FinancialTransactionTableModel tableModel) {
        super(tableModel);
        this.renderer = new EntryTableCellRenderer();
        this.editor = new StringTableCellEditor();
    }

    @Override
    public Class<?> getColumnClass() {
        return String.class;
    }

    @Override
    public String getColumnName() {
        return I18n._((String)"lima.ui.financialtransaction.description", (Object[])new Object[0]);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = this.tableModel.getEntryAt(row);
        return entry.getDescription();
    }

    @Override
    public boolean isCellEditable(int row) {
        return true;
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        boolean update;
        Entry entry = this.tableModel.getEntryAt(row);
        String description = ((String)value).trim();
        boolean bl = update = entry.getDescription() == null || entry.getDescription().compareTo(description) != 0;
        if (update) {
            entry.setDescription(description);
            this.tableModel.updateEntry(entry);
        }
        return update;
    }
}

