/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.math.BigDecimal;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionColumn;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.nuiton.i18n.I18n;

public class CreditColumn
extends FinancialTransactionColumn {
    public CreditColumn(FinancialTransactionTableModel tableModel) {
        super(tableModel);
        this.renderer = new BigDecimalTableCellRenderer();
        this.editor = new BigDecimalTableCellEditor();
    }

    @Override
    public Class<?> getColumnClass() {
        return BigDecimal.class;
    }

    @Override
    public String getColumnName() {
        return I18n._((String)"lima.ui.financialtransaction.credit", (Object[])new Object[0]);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = this.tableModel.getEntryAt(row);
        return entry.getDebit() ? BigDecimal.ZERO : entry.getAmount();
    }

    @Override
    public boolean isCellEditable(int row) {
        return true;
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        boolean update;
        Entry entry = this.tableModel.getEntryAt(row);
        BigDecimal credit = (BigDecimal)value;
        boolean bl = update = credit.signum() > 0 && (entry.isDebit() || entry.getAmount().compareTo(credit) != 0);
        if (update) {
            entry.setAmount(credit);
            entry.setDebit(false);
            this.tableModel.updateEntry(entry);
            this.tableModel.fireTransaction(entry.getFinancialTransaction());
        }
        return update;
    }
}

