/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.math.BigDecimal;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionColumn;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.nuiton.i18n.I18n;

public class BalanceColumn
extends FinancialTransactionColumn {
    public BalanceColumn(FinancialTransactionTableModel tableModel) {
        super(tableModel);
        this.renderer = new BigDecimalTableCellRenderer();
    }

    @Override
    public Class<?> getColumnClass() {
        return BigDecimal.class;
    }

    @Override
    public String getColumnName() {
        return I18n._((String)"lima.table.balance", (Object[])new Object[0]);
    }

    @Override
    public Object getValueAt(int row) {
        FinancialTransaction transaction = this.tableModel.getTransactionAt(row);
        BigDecimal result = row == 0 || this.tableModel.getEntryAt(row - 1).getFinancialTransaction() != transaction ? transaction.getAmountDebit().subtract(transaction.getAmountCredit()) : BigDecimal.ZERO;
        return result;
    }

    @Override
    public boolean isCellEditable(int row) {
        return false;
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        return false;
    }
}

