package org.chorem.lima.ui.lettering;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.LetteringFilter;
import org.chorem.lima.beans.LetteringFilterImpl;
import org.chorem.lima.entity.Account;
import org.chorem.lima.ui.common.AccountComboBoxModel;
import org.chorem.lima.ui.common.FinancialPeriodComboBoxModel;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n._;

public class LetteringView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREDIT_TEXT_FIELD_TEXT = "creditTextField.text";
    public static final String BINDING_DEBIT_TEXTT_FIELD_TEXT = "debitTexttField.text";
    public static final String BINDING_LETTERED_ENABLED = "lettered.enabled";
    public static final String BINDING_NO_LETTERED_ENABLED = "noLettered.enabled";
    public static final String BINDING_ROUND_ENABLED = "round.enabled";
    public static final String BINDING_SOLDE_TEXT_FIELD_TEXT = "soldeTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWYz2/cRBTHJ0vzY5OmhYQuQU2lEAIirfAmDeVXSsivLsmyLaEbIDRCMLYnWSezHmPPNg5CqP8B/RPgzqUSN06IA2cOCAlx4MIRIQ5cEe+Nd+048XqNnIOzO2++n3nv+c3MS775k/R7LnnmgPq+5rZsaTWZVl3Z2XlHP2CGXGee4VqOFC4JfvoKpLBLRsxw3JPk2d0aystteXlNNB1hM/uEerFGhj15zJnXYExKciWuMDyvXA/Ni77TcjvU0Kkk6ld//1V4aD74ukCI74B3sxDKVC9VFMm5GilYpiRjsNJ9WubU3gc3XMveB39HcWyNU8+7Q5vsU/IFGayRAYe6AJNkOnvIiqH0viPJ4Mw21Tmbk+SqcPc1oyFc1tS41aRay9I4JIehA1qt8+l9ix05jgIMgLxBbZMzV5L57PKNQBNRhiX6cFuYjEsylw20HUoizsiexcHaBs2eBumM2l5EqKjJm03nBKHITEu29eVsjtzqKCJKCaehrc44VK0l7DZyoSfyrCrCPulQm/EVwxDwmuEV62JV+FAuWBm+5h0ho7qFc1BQjHQ0Lmk7oyU4Y4hmU9jaSoIg8uMiPe3CpZgLnXGcfjlKrU6NwzXUSTIem7/aklLYp2bbzJdqNg48HzdOqkRULJvahkX5FqRPmCdXvRJPQLvI5yWZiO3GYH1lw5mzoWBoplqjOuNzp7OrRnHStajoHMs4ZO460yEMMoVJPYDz6FAKJ1D5WnVnnUq2pebFxZ2F5vH7XNxWDMAQJg4sxI3DsLnd4/BlJwd8Hb++iI9Xo2JQtcnMW6hfazDjUL3BiViYd6lpiei1vH7G3+uhv5GtZItaAhutS8mUhQTKCOU8g/SlBOmopzZOe/3uaVkI07J5hnsj5L4d1bvJdEtuQ0HKisU4nNClWLbQogxxWQf5chLScPGkiSnfTZa/kiC/4AlusjT1eapOEK9bhQwFxw4zw+11L6qt4EV2sQ66bM+FmzHB1O/Chk3SjM5U64YrOEd3YFM9FctfZIr72K+uBUmu/Y8bAaVmSBjrRKkq6i1wD6686YQzAFuMoN7VJDjrXHI5Ng96Ai3qCaJLu28Xwm7BMOyh3bNtxF0wBQ3ExKkGAoHK+m9p/Ofvfvu20ukayrD2pcSpJ5oeuM0dVzhw81q49MWgZWhJi5dvU2dxlxSDzaA6oskEx+ptMzgH6z2Bcg3l2gb1GoDoH/z1+x9Kn/z0GClUyDAX1KxQnL9JirKB7x8q0HfeXFYenT8agufj6JskA7pwTWwJLtw0qaRTumWbkOMlH5IwmZCE0BO9+OM/4/VHy51E9IFjT3edHiWj/x4ZsGxu2Uw1UO3eKLFhGnE81jJF1AMldUV9+HvSaV94rnreT4yU02PRUjfUsd/CX58pt/HT55kp/U28XlMg0xkgQ9AHQtKD+yUH55zEY46M3QwSOkWxJYGbjS0lM5/rycThL/HxMJnwQiaCnxLX1UyEB7kJaVGUcxNu5M7Da7nz0JsAF7QenZMp4byROyHLmQiPUgirWTZOp2nIxekVy3ruWCq5fdjIXWDV3AXWm4CtCbY9FZF2lN3JnY3eBPAEe7ROV9GFs5WBU9wTRsvLDQpD6pKUbIRfUgj13GnNRvg9hfBeJsIfuQlpmcxGSMvkB7kzmY2QlskPc2cyGyEtk70J8BcFs3FvmCmYj3KnMxOhr5Tiw8e5fchECHzoQqC5fchESM2DkduH3gQ4M11xtMGs/YZMATUygC54sX+npQSWhTbkCbfXlYCc/wCQadVtyRYAAA==";
    private static final Log log = LogFactory.getLog(LetteringView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComboBox accountComboBox;
    protected AccountComboBoxModel accountComboBoxModel;
    protected JPanel actionsPanel;
    protected JRadioButton allCheckBox;
    protected JButton backCount;
    protected JTextField creditTextField;
    protected JTextField debitTexttField;
    protected LetteringEditModel editModel;
    protected JPanel entryPanel;
    protected LetteringFilterImpl filterModel;
    protected LetteringViewHandler handler;
    protected JButton lettered;
    protected JAXXButtonGroup letteredCheckGroup;
    protected JRadioButton lettredEntryCheckBox;
    protected LettringSelectionModel lettringSelectionModel;
    protected JButton nextCount;
    protected JButton noLettered;
    protected JRadioButton noLettredEntryCheckBox;
    protected JPanel panelAccountComboBox;
    protected JPanel panelFinancialPeriodComboBox;
    protected JXDatePicker pickerDebut;
    protected JXDatePicker pickerFin;
    protected JButton refresh;
    protected JButton round;
    protected JPanel selectedEntry;
    protected JTextField soldeTextField;
    protected LetteringTable table;
    protected LetteringTableModel tableModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JScrollPane $JScrollPane0;
    private LetteringView $Table0 = this;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            handler.init();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LetteringView() {
        $initialize();
    }

    public LetteringView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__accountComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        filterModel.setAccount((Account)accountComboBoxModel.getSelectedItem());
    }

    public void doActionPerformed__on__allCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        filterModel.setDisplayLettered(false) ; filterModel.setDisplayUnlettred(false);
    }

    public void doActionPerformed__on__backCount(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.back(accountComboBox);
    }

    public void doActionPerformed__on__lettered(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addLetter();
    }

    public void doActionPerformed__on__lettredEntryCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        filterModel.setDisplayLettered(true) ; filterModel.setDisplayUnlettred(false);
    }

    public void doActionPerformed__on__nextCount(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.next(accountComboBox);
    }

    public void doActionPerformed__on__noLettered(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeLetter();
    }

    public void doActionPerformed__on__noLettredEntryCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        filterModel.setDisplayUnlettred(true); filterModel.setDisplayLettered(false);
    }

    public void doActionPerformed__on__pickerDebut(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        filterModel.setDateStart(pickerDebut.getDate());
    }

    public void doActionPerformed__on__pickerFin(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        filterModel.setDateEnd(pickerFin.getDate());
    }

    public void doActionPerformed__on__refresh(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateAllEntries();
    }

    public void doActionPerformed__on__round(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.roundAndCreateEntry();
    }

    public void doValueChanged__on__lettringSelectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.balanceAndActions();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JComboBox getAccountComboBox() {
        return accountComboBox;
    }

    public AccountComboBoxModel getAccountComboBoxModel() {
        return accountComboBoxModel;
    }

    public JPanel getActionsPanel() {
        return actionsPanel;
    }

    public JRadioButton getAllCheckBox() {
        return allCheckBox;
    }

    public JButton getBackCount() {
        return backCount;
    }

    public JTextField getCreditTextField() {
        return creditTextField;
    }

    public JTextField getDebitTexttField() {
        return debitTexttField;
    }

    public LetteringEditModel getEditModel() {
        return editModel;
    }

    public JPanel getEntryPanel() {
        return entryPanel;
    }

    public LetteringFilterImpl getFilterModel() {
        return filterModel;
    }

    public LetteringViewHandler getHandler() {
        return handler;
    }

    public JButton getLettered() {
        return lettered;
    }

    public JAXXButtonGroup getLetteredCheckGroup() {
        return letteredCheckGroup;
    }

    public JRadioButton getLettredEntryCheckBox() {
        return lettredEntryCheckBox;
    }

    public LettringSelectionModel getLettringSelectionModel() {
        return lettringSelectionModel;
    }

    public JButton getNextCount() {
        return nextCount;
    }

    public JButton getNoLettered() {
        return noLettered;
    }

    public JRadioButton getNoLettredEntryCheckBox() {
        return noLettredEntryCheckBox;
    }

    public JPanel getPanelAccountComboBox() {
        return panelAccountComboBox;
    }

    public JPanel getPanelFinancialPeriodComboBox() {
        return panelFinancialPeriodComboBox;
    }

    public JXDatePicker getPickerDebut() {
        return pickerDebut;
    }

    public JXDatePicker getPickerFin() {
        return pickerFin;
    }

    public JButton getRefresh() {
        return refresh;
    }

    public JButton getRound() {
        return round;
    }

    public JPanel getSelectedEntry() {
        return selectedEntry;
    }

    public JTextField getSoldeTextField() {
        return soldeTextField;
    }

    public LetteringTable getTable() {
        return table;
    }

    public LetteringTableModel getTableModel() {
        return tableModel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionsPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionsPanel.add(lettered);
        actionsPanel.add(noLettered);
        actionsPanel.add(refresh);
        actionsPanel.add(round);
    }

    protected void addChildrenToAllCheckBox() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = letteredCheckGroup; allCheckBox.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(allCheckBox); }
    }

    protected void addChildrenToEntryPanel() {
        if (!allComponentsCreated) {
            return;
        }
        entryPanel.add($Table2, BorderLayout.NORTH);
    }

    protected void addChildrenToLettredEntryCheckBox() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = letteredCheckGroup; lettredEntryCheckBox.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(lettredEntryCheckBox); }
    }

    protected void addChildrenToNoLettredEntryCheckBox() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = letteredCheckGroup; noLettredEntryCheckBox.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(noLettredEntryCheckBox); }
    }

    protected void addChildrenToPanelAccountComboBox() {
        if (!allComponentsCreated) {
            return;
        }
        panelAccountComboBox.add(accountComboBox, BorderLayout.WEST);
        panelAccountComboBox.add(backCount, BorderLayout.CENTER);
        panelAccountComboBox.add(nextCount, BorderLayout.EAST);
    }

    protected void addChildrenToPanelFinancialPeriodComboBox() {
        if (!allComponentsCreated) {
            return;
        }
        panelFinancialPeriodComboBox.add($Table1, BorderLayout.NORTH);
    }

    protected void addChildrenToSelectedEntry() {
        if (!allComponentsCreated) {
            return;
        }
        selectedEntry.add($Table3, BorderLayout.NORTH);
    }

    protected void createAccountComboBox() {
        $objectMap.put("accountComboBox", accountComboBox = new JComboBox());
        
        accountComboBox.setName("accountComboBox");
        accountComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__accountComboBox"));
    }

    protected void createAccountComboBoxModel() {
        $objectMap.put("accountComboBoxModel", accountComboBoxModel = new AccountComboBoxModel());
    }

    protected void createActionsPanel() {
        $objectMap.put("actionsPanel", actionsPanel = new JPanel());
        
        actionsPanel.setName("actionsPanel");
    }

    protected void createAllCheckBox() {
        $objectMap.put("allCheckBox", allCheckBox = new JRadioButton());
        
        allCheckBox.setName("allCheckBox");
        allCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__allCheckBox"));
    }

    protected void createBackCount() {
        $objectMap.put("backCount", backCount = new JButton());
        
        backCount.setName("backCount");
        backCount.setText(_("lima.ui.account.buttonback"));
        backCount.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__backCount"));
    }

    protected void createCreditTextField() {
        $objectMap.put("creditTextField", creditTextField = new JTextField());
        
        creditTextField.setName("creditTextField");
        creditTextField.setColumns(15);
        creditTextField.setEditable(false);
        creditTextField.setFocusable(false);
    }

    protected void createDebitTexttField() {
        $objectMap.put("debitTexttField", debitTexttField = new JTextField());
        
        debitTexttField.setName("debitTexttField");
        debitTexttField.setColumns(15);
        debitTexttField.setEditable(false);
        debitTexttField.setFocusable(false);
    }

    protected void createEditModel() {
        $objectMap.put("editModel", editModel = new LetteringEditModel());
    }

    protected void createEntryPanel() {
        $objectMap.put("entryPanel", entryPanel = new JPanel());
        
        entryPanel.setName("entryPanel");
        entryPanel.setLayout(new BorderLayout());
    }

    protected void createFilterModel() {
        $objectMap.put("filterModel", filterModel = new LetteringFilterImpl());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new LetteringViewHandler(this));
    }

    protected void createLettered() {
        $objectMap.put("lettered", lettered = new JButton());
        
        lettered.setName("lettered");
        lettered.setText(_("lima.ui.lettering.buttonLettered"));
        lettered.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lettered"));
    }

    protected void createLetteredCheckGroup() {
        $objectMap.put("letteredCheckGroup", letteredCheckGroup = new JAXXButtonGroup());
    }

    protected void createLettredEntryCheckBox() {
        $objectMap.put("lettredEntryCheckBox", lettredEntryCheckBox = new JRadioButton());
        
        lettredEntryCheckBox.setName("lettredEntryCheckBox");
        lettredEntryCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lettredEntryCheckBox"));
    }

    protected void createLettringSelectionModel() {
        $objectMap.put("lettringSelectionModel", lettringSelectionModel = new LettringSelectionModel(tableModel));
        
        lettringSelectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__lettringSelectionModel"));
    }

    protected void createNextCount() {
        $objectMap.put("nextCount", nextCount = new JButton());
        
        nextCount.setName("nextCount");
        nextCount.setText(_("lima.ui.account.buttonnext"));
        nextCount.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__nextCount"));
    }

    protected void createNoLettered() {
        $objectMap.put("noLettered", noLettered = new JButton());
        
        noLettered.setName("noLettered");
        noLettered.setText(_("lima.ui.lettering.buttonNoLettered"));
        noLettered.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__noLettered"));
    }

    protected void createNoLettredEntryCheckBox() {
        $objectMap.put("noLettredEntryCheckBox", noLettredEntryCheckBox = new JRadioButton());
        
        noLettredEntryCheckBox.setName("noLettredEntryCheckBox");
        noLettredEntryCheckBox.setSelected(true);
        noLettredEntryCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__noLettredEntryCheckBox"));
    }

    protected void createPanelAccountComboBox() {
        $objectMap.put("panelAccountComboBox", panelAccountComboBox = new JPanel());
        
        panelAccountComboBox.setName("panelAccountComboBox");
        panelAccountComboBox.setLayout(new BorderLayout());
    }

    protected void createPanelFinancialPeriodComboBox() {
        $objectMap.put("panelFinancialPeriodComboBox", panelFinancialPeriodComboBox = new JPanel());
        
        panelFinancialPeriodComboBox.setName("panelFinancialPeriodComboBox");
        panelFinancialPeriodComboBox.setLayout(new BorderLayout());
    }

    protected void createPickerDebut() {
        $objectMap.put("pickerDebut", pickerDebut = new JXDatePicker());
        
        pickerDebut.setName("pickerDebut");
        pickerDebut.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__pickerDebut"));
    }

    protected void createPickerFin() {
        $objectMap.put("pickerFin", pickerFin = new JXDatePicker());
        
        pickerFin.setName("pickerFin");
        pickerFin.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__pickerFin"));
    }

    protected void createRefresh() {
        $objectMap.put("refresh", refresh = new JButton());
        
        refresh.setName("refresh");
        refresh.setEnabled(true);
        refresh.setText(_("lima.ui.lettering.buttonRefresh"));
        refresh.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__refresh"));
    }

    protected void createRound() {
        $objectMap.put("round", round = new JButton());
        
        round.setName("round");
        round.setText(_("lima.ui.lettering.buttonEqualize"));
        round.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__round"));
    }

    protected void createSelectedEntry() {
        $objectMap.put("selectedEntry", selectedEntry = new JPanel());
        
        selectedEntry.setName("selectedEntry");
        selectedEntry.setLayout(new BorderLayout());
    }

    protected void createSoldeTextField() {
        $objectMap.put("soldeTextField", soldeTextField = new JTextField());
        
        soldeTextField.setName("soldeTextField");
        soldeTextField.setColumns(15);
        soldeTextField.setEditable(false);
        soldeTextField.setFocusable(false);
    }

    protected void createTable() {
        $objectMap.put("table", table = new LetteringTable(getTableModel()));
        
        table.setName("table");
        table.setRowHeight(22);
        table.setSortable(false);
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = new LetteringTableModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(panelAccountComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(panelFinancialPeriodComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(entryPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(selectedEntry, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(actionsPanel, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToPanelAccountComboBox();
        addChildrenToPanelFinancialPeriodComboBox();
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(pickerDebut, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(pickerFin, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToEntryPanel();
        // inline complete setup of $Table2
        $Table2.add(lettredEntryCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(noLettredEntryCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel3, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(allCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel4, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToLettredEntryCheckBox();
        addChildrenToNoLettredEntryCheckBox();
        addChildrenToAllCheckBox();
        addChildrenToSelectedEntry();
        // inline complete setup of $Table3
        $Table3.add($JLabel5, new GridBagConstraints(0, 0, 1, 1, 0.6, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(debitTexttField, new GridBagConstraints(1, 0, 1, 1, 0.6, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel6, new GridBagConstraints(2, 0, 1, 1, 0.6, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(creditTextField, new GridBagConstraints(3, 0, 1, 1, 0.6, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel7, new GridBagConstraints(4, 0, 1, 1, 0.6, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(soldeTextField, new GridBagConstraints(5, 0, 1, 1, 0.6, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToActionsPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(table);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        panelAccountComboBox.setBorder(new TitledBorder(_("lima.ui.lettering.account")));
        accountComboBox.setModel(accountComboBoxModel);
        accountComboBox.setRenderer(new org.chorem.lima.ui.common.AccountListRenderer());
        panelFinancialPeriodComboBox.setBorder(new TitledBorder(_("lima.ui.lettering.period")));
        entryPanel.setBorder(new TitledBorder(_("lima.ui.lettering.entry")));
        selectedEntry.setBorder(new TitledBorder(_("lima.ui.lettering.selectEntry")));
        $JLabel5.setLabelFor(debitTexttField);
        $JLabel6.setLabelFor(creditTextField);
        $JLabel7.setLabelFor(soldeTextField);
        table.setSelectionModel(lettringSelectionModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createTableModel();
        createFilterModel();
        createEditModel();
        createLettringSelectionModel();
        createPanelAccountComboBox();
        createAccountComboBoxModel();
        createAccountComboBox();
        createBackCount();
        createNextCount();
        createPanelFinancialPeriodComboBox();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.ui.lettering.beginFinancialPeriod"));
        createPickerDebut();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.ui.lettering.endFinancialPeriod"));
        createPickerFin();
        createEntryPanel();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createLettredEntryCheckBox();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("lima.ui.lettering.checkLettredEntry"));
        createNoLettredEntryCheckBox();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("lima.ui.lettering.checkNoLettredEntry"));
        createAllCheckBox();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("lima.ui.lettering.checkAll"));
        createSelectedEntry();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("lima.ui.lettering.selectDebit"));
        createDebitTexttField();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("lima.ui.lettering.selectCredit"));
        createCreditTextField();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("lima.ui.lettering.selectSolde"));
        createSoldeTextField();
        createActionsPanel();
        createLettered();
        createNoLettered();
        createRefresh();
        createRound();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTable();
        createLetteredCheckGroup();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEBIT_TEXTT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("debit", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null && editModel.getDebit() != null) {
                    SwingUtil.setText(debitTexttField, editModel.getDebit().toString());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("debit", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREDIT_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("credit", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null && editModel.getCredit() != null) {
                    SwingUtil.setText(creditTextField, editModel.getCredit().toString());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("credit", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOLDE_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("solde", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null && editModel.getSolde() != null) {
                    SwingUtil.setText(soldeTextField, editModel.getSolde().toString());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("solde", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LETTERED_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("lettred", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null) {
                    lettered.setEnabled(editModel.isLettred());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("lettred", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NO_LETTERED_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("unLettred", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null) {
                    noLettered.setEnabled(editModel.isUnLettred());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("unLettred", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ROUND_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (editModel != null) {
                    editModel.addPropertyChangeListener("equalized", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editModel != null) {
                    round.setEnabled(editModel.isEqualized());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editModel != null) {
                    editModel.removePropertyChangeListener("equalized", this);
                }
            }
        });
    }

}