/*
 * #%L
 * Lima Swing
 * *
 * $Id: LetteringTable.java 3557 2012-08-01 09:07:09Z mallon $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/lettering/LetteringTable.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.lettering;

import org.chorem.lima.LimaConfig;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.ui.celleditor.AccountTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellEditor;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.chorem.lima.ui.celleditor.DateTableCellEditor;
import org.chorem.lima.ui.celleditor.EntryBookTableCellEditor;
import org.jdesktop.swingx.JXTable;

import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.util.Date;


/**
 * Table des transaction qui ajoute des comportement (keys).
 *
 * @author jpepin
 */
public class LetteringTable extends JXTable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3133690382049594727L;

    protected LetteringViewHandler handler;

    public LetteringTable(LetteringTableModel letteringTableModel) {
        super(letteringTableModel);

        //To block reaction of the dual key 'ctrl+a' (Selection of all lines)
        InputMap im = getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        im.put(KeyStroke.getKeyStroke(KeyEvent.VK_A, InputEvent.CTRL_MASK), "none");

        //Get new date editor
        setDefaultEditor(Date.class, new DateTableCellEditor());

        //Get new account editor
        setDefaultEditor(String.class, new DefaultCellEditor(new JTextField()));

        //Get new entry book editor
        setDefaultEditor(EntryBook.class, new EntryBookTableCellEditor());
        //Get new account editor
        setDefaultEditor(Account.class, new AccountTableCellEditor());

        //Get new amount editor
        setDefaultEditor(BigDecimal.class, new BigDecimalTableCellEditor());
        //Get new BigDecimal renderer
        setDefaultRenderer(BigDecimal.class, new BigDecimalTableCellRenderer());
    }
}
