/*
 * #%L
 * Lima Swing
 * 
 * $Id: LedgerTable.java 3557 2012-08-01 09:07:09Z mallon $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/ledger/LedgerTable.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.ledger;

import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;

/**
 * Table des transaction qui ajoute des comportement (keys).
 *
 * @author ore
 * @author Rémi Chapelet
 */
public class LedgerTable extends JXTable implements KeyListener, MouseListener {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3133690382049594727L;

    private Highlighter colorReportsDatas;

    public LedgerTable() {

        addKeyListener(this);
        addMouseListener(this);

        //Get new BigDecimal renderer
        setDefaultRenderer(BigDecimal.class, new BigDecimalTableCellRenderer());

        //highlight financial financial transactions
        addColorReportsDatas();
    }

    /**
     * Cette méthode permet de colorer toutes les reportsdatas dans le tableau
     * afin de bien distinguer les entête de comptes et les entrées comptables.
     * On récupère la première cellule, on vérifie que c'est pas null
     */
    protected void addColorReportsDatas() {
        if (colorReportsDatas != null) {
            removeHighlighter(colorReportsDatas);
        }
        HighlightPredicate predicate = new HighlightPredicate() {
            @Override
            public boolean isHighlighted(Component renderer,
                                         ComponentAdapter adapter) {
                return adapter.getValueAt(adapter.row, 0) != null;
            }
        };
        colorReportsDatas =
                new ColorHighlighter(predicate, new Color(222, 222, 222), null);
        addHighlighter(colorReportsDatas);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (rowAtPoint(e.getPoint()) == -1) {
            clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /**
     * for each action combination key are think
     * for extend keyboard and laptop keyboard
     */
    @Override
    public void keyPressed(KeyEvent e) {
        // clear row selection with the key: escape
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
            if (!isEditing()) {
                clearSelection();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}
