package org.chorem.lima.ui.home;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class HomeView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FIXED_SIZE = "fixedSize";
    public static final String PROPERTY_MINI_SIZE = "miniSize";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCOUNT_PANEL_MINIMUM_SIZE = "accountPanel.minimumSize";
    public static final String BINDING_ACCOUNT_PANEL_PREFERRED_SIZE = "accountPanel.preferredSize";
    public static final String BINDING_ENTRY_BOOK_PANEL_MINIMUM_SIZE = "entryBookPanel.minimumSize";
    public static final String BINDING_ENTRY_BOOK_PANEL_PREFERRED_SIZE = "entryBookPanel.preferredSize";
    public static final String BINDING_FINANCIAL_TRANSACTION_PANEL_MINIMUM_SIZE = "financialTransactionPanel.minimumSize";
    public static final String BINDING_FINANCIAL_TRANSACTION_PANEL_PREFERRED_SIZE = "financialTransactionPanel.preferredSize";
    public static final String BINDING_FISCAL_PERIOD_PANEL_MINIMUM_SIZE = "fiscalPeriodPanel.minimumSize";
    public static final String BINDING_FISCAL_PERIOD_PANEL_PREFERRED_SIZE = "fiscalPeriodPanel.preferredSize";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVy27TQBSGp6G3tLTQFnpRuaRQIQGS0ysgWpV71UYBKlpQ1SxgYk+aKc6MGY+pywLxCDwC7NkgsWOFWLBmwQbxCgixYIs446R2TYxr4SyceM453/xz8vv4zXfUZgs0toVdVxMOk7RGtMK19fW75S2iy5vE1gW1JBeo/mnJoEwJdRv+ui3R6VJRlecb5fkbvGZxRtie6rki6rLljknsKiFSouPhCt2286t+eM61HLFL9UVFUV/9/JF5abx4nUHItUDdEBwlt19VcJLWIspQQ6J+2OkpzpuYbYIMQdkm6O1RazdMbNt3cI08Qc9RRxG1W1gATKJTyY/sMbx615KoY3wNl00yIVGOi01Nr3JBappJa1hzqFbloHkJLg8o2bYsr6xdomyFusRYpc8IiFW6NLwttZuwM7MpZ0FiZ40yqvLUfW+wfhDrOgetK5gRs8FwNXsbjqoVvEWVmPXzGyonJRoOtbNe4cVUZl+w8XihiMvEnPgb7q2qpCNNuZPqfiQc6xkv3DIotE+JAthQCBaEwlW90Hmxc53zx/5ZBiIPNKVuB9XlZJOcKV/OWFNsOiIWkuqd5UQ4oa9CbR2bK0RQbuwjbNoXdrZp8xl/8/NNsdmIWEjYlC8sSBipUIaZTrG5JjCzsS7BRPsInPEFTjeJuOCLmG2KXYyIhQRO+wIhQaDRkN9gMGjBYAie3JYSahMOLINBS82z5B6E6lNk+K8pooBe9PfgwJf3394t7o6OHOx9NDJ1z+SDR9oS3CJCUrX1ofrccCQ187exNVdCWZuYMDa9sXgsQthqIwziYL8+71FW5doStquAaOv4+uHj4KPPB1BmEXWZHBuLWOUvo6ysCugCNw3XunLVU3RwuxOuh5U2idrLXBggDPXOG1jiXJkyA56ZBReacCyiCb6ScvbTr4HVt1d3G9ECwkb+mR40o20DtVNmUka8KdoYkJFTs9uyiWPwYBBGjcYW9d1vNWbWde+6GHlSE+9wR6r4suuor4InW/0qJqZ0q0lZc2q7wzIFqscSpEKEqE/olLBWqnMWwxhOwqhwFtef0QSMrgq8mDYFvDSMlKRWSVx4Y/bP192SwxJesWVHkoX/ZarlpRhVuUSEldSE+6kJG6kJD2MI44kIcf/vmUQEmprgOZ6nIcT54VxqPyQjxPkhGSHOD8kIcX7QUvthIrUfkhHi/JCMEOeHmdR+SEaI80MyQpwfkhHi/HAptR8up/ZDMkKcHxThD4A8y3vHDgAA";
    private static final Log log = LogFactory.getLog(HomeView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel accountPanel;
    protected JPanel entryBookPanel;
    protected JPanel financialTransactionPanel;
    protected JPanel fiscalPeriodPanel;
    protected Dimension fixedSize;
    protected Dimension miniSize;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JEditorPane $JEditorPane0;
    private JEditorPane $JEditorPane1;
    private JEditorPane $JEditorPane2;
    private JEditorPane $JEditorPane3;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private HomeView $Table0 = this;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;
    private Table $Table4;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public HomeView() {
        $initialize();
    }

    public HomeView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getAccountPanel() {
        return accountPanel;
    }

    public JPanel getEntryBookPanel() {
        return entryBookPanel;
    }

    public JPanel getFinancialTransactionPanel() {
        return financialTransactionPanel;
    }

    public JPanel getFiscalPeriodPanel() {
        return fiscalPeriodPanel;
    }

    public Dimension getFixedSize() {
        return fixedSize;
    }

    public Dimension getMiniSize() {
        return miniSize;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFixedSize(Dimension fixedSize) {
        Dimension oldValue = this.fixedSize;
        this.fixedSize = fixedSize;
        firePropertyChange(PROPERTY_FIXED_SIZE, oldValue, fixedSize);
    }

    public void setMiniSize(Dimension miniSize) {
        Dimension oldValue = this.miniSize;
        this.miniSize = miniSize;
        firePropertyChange(PROPERTY_MINI_SIZE, oldValue, miniSize);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JEditorPane get$JEditorPane0() {
        return $JEditorPane0;
    }

    protected JEditorPane get$JEditorPane1() {
        return $JEditorPane1;
    }

    protected JEditorPane get$JEditorPane2() {
        return $JEditorPane2;
    }

    protected JEditorPane get$JEditorPane3() {
        return $JEditorPane3;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccountPanel() {
        if (!allComponentsCreated) {
            return;
        }
        accountPanel.add($Table1);
    }

    protected void addChildrenToEntryBookPanel() {
        if (!allComponentsCreated) {
            return;
        }
        entryBookPanel.add($Table2);
    }

    protected void addChildrenToFinancialTransactionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        financialTransactionPanel.add($Table4);
    }

    protected void addChildrenToFiscalPeriodPanel() {
        if (!allComponentsCreated) {
            return;
        }
        fiscalPeriodPanel.add($Table3);
    }

    protected void createAccountPanel() {
        $objectMap.put("accountPanel", accountPanel = new JPanel());
        
        accountPanel.setName("accountPanel");
        accountPanel.setLayout(new BoxLayout(accountPanel, BoxLayout.X_AXIS));
    }

    protected void createEntryBookPanel() {
        $objectMap.put("entryBookPanel", entryBookPanel = new JPanel());
        
        entryBookPanel.setName("entryBookPanel");
        entryBookPanel.setLayout(new BoxLayout(entryBookPanel, BoxLayout.X_AXIS));
    }

    protected void createFinancialTransactionPanel() {
        $objectMap.put("financialTransactionPanel", financialTransactionPanel = new JPanel());
        
        financialTransactionPanel.setName("financialTransactionPanel");
        financialTransactionPanel.setLayout(new BoxLayout(financialTransactionPanel, BoxLayout.X_AXIS));
    }

    protected void createFiscalPeriodPanel() {
        $objectMap.put("fiscalPeriodPanel", fiscalPeriodPanel = new JPanel());
        
        fiscalPeriodPanel.setName("fiscalPeriodPanel");
        fiscalPeriodPanel.setLayout(new BoxLayout(fiscalPeriodPanel, BoxLayout.X_AXIS));
    }

    protected void createFixedSize() {
        $objectMap.put("fixedSize", fixedSize = new Dimension(500,200));
    }

    protected void createMiniSize() {
        $objectMap.put("miniSize", miniSize = new Dimension(300,150));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(accountPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(entryBookPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(fiscalPeriodPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(financialTransactionPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToAccountPanel();
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JEditorPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToEntryBookPanel();
        // inline complete setup of $Table2
        $Table2.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel3, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JEditorPane1, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFiscalPeriodPanel();
        // inline complete setup of $Table3
        $Table3.add($JLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel5, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JEditorPane2, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFinancialTransactionPanel();
        // inline complete setup of $Table4
        $Table4.add($JLabel6, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel7, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JEditorPane3, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 20 property setters
        accountPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        $JLabel0.setIcon(SwingUtil.createImageIcon("accounts.png"));
        $JLabel1.setFont(new Font("sans-serif", Font.BOLD, 16));
        $JLabel1.setForeground(Color.DARK_GRAY);
        entryBookPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        $JLabel2.setIcon(SwingUtil.createImageIcon("entrybooks.png"));
        $JLabel3.setFont(new Font("sans-serif", Font.BOLD, 16));
        $JLabel3.setForeground(Color.DARK_GRAY);
        fiscalPeriodPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        $JLabel4.setIcon(SwingUtil.createImageIcon("fiscalperiods.png"));
        $JLabel5.setFont(new Font("sans-serif", Font.BOLD, 16));
        $JLabel5.setForeground(Color.DARK_GRAY);
        financialTransactionPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        $JLabel6.setIcon(SwingUtil.createImageIcon("entries.png"));
        $JLabel7.setFont(new Font("sans-serif", Font.BOLD, 16));
        $JLabel7.setForeground(Color.DARK_GRAY);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createFixedSize();
        createMiniSize();
        createAccountPanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.ui.home.account"));
        // inline creation of $JEditorPane0
        $objectMap.put("$JEditorPane0", $JEditorPane0 = new AccountsPane(this));
        
        $JEditorPane0.setName("$JEditorPane0");
        createEntryBookPanel();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("lima.ui.home.entrybooks"));
        // inline creation of $JEditorPane1
        $objectMap.put("$JEditorPane1", $JEditorPane1 = new EntryBooksPane(this));
        
        $JEditorPane1.setName("$JEditorPane1");
        createFiscalPeriodPanel();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("lima.ui.home.fiscalyear"));
        // inline creation of $JEditorPane2
        $objectMap.put("$JEditorPane2", $JEditorPane2 = new FiscalPeriodsPane(this));
        
        $JEditorPane2.setName("$JEditorPane2");
        createFinancialTransactionPanel();
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("lima.ui.home.daily"));
        // inline creation of $JEditorPane3
        $objectMap.put("$JEditorPane3", $JEditorPane3 = new FinancialTransactionsPane(this));
        
        $JEditorPane3.setName("$JEditorPane3");
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ACCOUNT_PANEL_MINIMUM_SIZE, true ,"miniSize") {
        
            @Override
            public void processDataBinding() {
                accountPanel.setMinimumSize(getMiniSize());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ACCOUNT_PANEL_PREFERRED_SIZE, true ,"fixedSize") {
        
            @Override
            public void processDataBinding() {
                accountPanel.setPreferredSize(getFixedSize());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ENTRY_BOOK_PANEL_MINIMUM_SIZE, true ,"miniSize") {
        
            @Override
            public void processDataBinding() {
                entryBookPanel.setMinimumSize(getMiniSize());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ENTRY_BOOK_PANEL_PREFERRED_SIZE, true ,"fixedSize") {
        
            @Override
            public void processDataBinding() {
                entryBookPanel.setPreferredSize(getFixedSize());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FISCAL_PERIOD_PANEL_MINIMUM_SIZE, true ,"miniSize") {
        
            @Override
            public void processDataBinding() {
                fiscalPeriodPanel.setMinimumSize(getMiniSize());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FISCAL_PERIOD_PANEL_PREFERRED_SIZE, true ,"fixedSize") {
        
            @Override
            public void processDataBinding() {
                fiscalPeriodPanel.setPreferredSize(getFixedSize());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FINANCIAL_TRANSACTION_PANEL_MINIMUM_SIZE, true ,"miniSize") {
        
            @Override
            public void processDataBinding() {
                financialTransactionPanel.setMinimumSize(getMiniSize());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FINANCIAL_TRANSACTION_PANEL_PREFERRED_SIZE, true ,"fixedSize") {
        
            @Override
            public void processDataBinding() {
                financialTransactionPanel.setPreferredSize(getFixedSize());
            }
        });
    }

}