package org.chorem.lima.ui.fiscalperiod;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import static org.nuiton.i18n.I18n._;

public class FiscalPeriodView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BLOCK_BUTTON_ENABLED = "blockButton.enabled";
    public static final String BINDING_DELETE_BUTTON_ENABLED = "deleteButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRR+rZRSfqhQRYyoFTl52IIajYEoimmAFCFUCbEXp7tDOzjdWWdm7Xox/gn+CXr3YuLNk/Hg2YMX479gjAevxpnZ0m2hlhZ62Hbfe9/3vvf63nv3ExKCw6UdFAQW911Jqthaubu1tVbawba8j4XNiScZh/ATi0O8CENOwy4kXC7mNTxbh2cXWdVjLnab0HN5GBTyBcWigrGUcL4VYQuRLTTcc4Hn813Whqh2rG9+/4q/dl69jQMEnlI3qErJHISKKunLQ5w4EsZUpucoS5FbVjI4cctK74i2LVIkxANUxc/gJSTz0O8hrsgkTHVfsuEw+MCTkJx+iEoUz0iYYbxs2RXGcdWipIosn1jbRNiIepgT5lg587JuXjYJrnmeoelXJBXkOhRzCTd7JVkKkRHX+HZThNG2yhxMJdzohToCRszHBaZqhghz64wXdEsDS9RUh608EbLQEhAhE9UQcK0XCYbj0XLEMjK9UrA5o3QdubrhZ5rTN7l0eKqBGt3XDwmzPbdCk000OFPIce75UjJXQrpFRWhtVTBUosx+Gnkyre5hVSaWeL+fw7mW2VdbZUVbFY19rAgJ7iuzhIni/kXcUK5wBSf2rKAmNN6/4+lvH398yDXv3em2oU1nQ+2Dx5lqmCQ69Ylw6XxJaHYVeXNFSIXzYm7KZBthhbpbiVP5RjXc0nBrCYmKokgkv3/6PP7k6zGI52CQMuTkkI5fhpSscNUFRp3Au7NgFA3XBtTzpNamJqVlUtXkzjtIokyJuI76l24HqheTbXrREFRKffmTLrxf2O1HTOk7+9/wqCeJx9BPXEpcbC5R/ci0vTxDnsC+w6Jj0u68xPR32quvwBXztNoVfMpm1K+6i2og1RZsEkHMnI/Nh2oySKozWPIlVrVrkqumKP3ruskx2UWOFGe1JUzKFalDbh2eaM8d0XGzh2cbEIzL3RU9gqo+iYNOlV3sgiOJXa3E6VDS1IE02rzaQUh3DBsdNEwfWYNm+Ac0fwQaawgAAA==";
    private static final Log log = LogFactory.getLog(FiscalPeriodView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected JButton blockButton;
    protected JButton deleteButton;
    protected FiscalPeriodTable fiscalPeriodTable;
    protected FiscalPeriodTableModel fiscalPeriodTableModel;
    protected FiscalPeriodViewHandler handler;
    protected FiscalPeriodModelUI model;
    protected ListSelectionModel selectionModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private FiscalPeriodView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            getHandler().init();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FiscalPeriodView() {
        $initialize();
    }

    public FiscalPeriodView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addFiscalPeriod();
    }

    public void doActionPerformed__on__blockButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().blockFiscalPeriod();
    }

    public void doActionPerformed__on__deleteButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().deleteFiscalPeriod();
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onSelectionChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public JButton getBlockButton() {
        return blockButton;
    }

    public JButton getDeleteButton() {
        return deleteButton;
    }

    public FiscalPeriodTable getFiscalPeriodTable() {
        return fiscalPeriodTable;
    }

    public FiscalPeriodTableModel getFiscalPeriodTableModel() {
        return fiscalPeriodTableModel;
    }

    public FiscalPeriodViewHandler getHandler() {
        return handler;
    }

    public FiscalPeriodModelUI getModel() {
        return model;
    }

    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(FiscalPeriodModelUI model) {
        FiscalPeriodModelUI oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.setText(_("lima.charts.fiscalperiod.add"));
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createBlockButton() {
        $objectMap.put("blockButton", blockButton = new JButton());
        
        blockButton.setName("blockButton");
        blockButton.setText(_("lima.charts.fiscalperiod.block"));
        blockButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__blockButton"));
    }

    protected void createDeleteButton() {
        $objectMap.put("deleteButton", deleteButton = new JButton());
        
        deleteButton.setName("deleteButton");
        deleteButton.setText(_("lima.charts.fiscalperiod.delete"));
        deleteButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__deleteButton"));
    }

    protected void createFiscalPeriodTable() {
        $objectMap.put("fiscalPeriodTable", fiscalPeriodTable = new FiscalPeriodTable(getFiscalPeriodTableModel()));
        
        fiscalPeriodTable.setName("fiscalPeriodTable");
        fiscalPeriodTable.setColumnControlVisible(true);
        fiscalPeriodTable.setRowHeight(24);
        fiscalPeriodTable.setSortable(false);
    }

    protected void createFiscalPeriodTableModel() {
        $objectMap.put("fiscalPeriodTableModel", fiscalPeriodTableModel = new FiscalPeriodTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FiscalPeriodViewHandler(this));
    }

    protected void createModel() {
        $objectMap.put("model", model = new FiscalPeriodModelUI());
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JScrollPane0, new GridBagConstraints(0, 0, 1, 5, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(blockButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(deleteButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fiscalPeriodTable);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        selectionModel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        fiscalPeriodTable.setSelectionModel(selectionModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createFiscalPeriodTableModel();
        createSelectionModel();
        createModel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFiscalPeriodTable();
        createAddButton();
        createBlockButton();
        createDeleteButton();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BLOCK_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("blockEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    blockButton.setEnabled(model.isBlockEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("blockEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("deleteEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    deleteButton.setEnabled(model.isDeleteEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("deleteEnabled", this);
                }
            }
        });
    }

}