/*
 * #%L
 * Lima Swing
 * 
 * $Id: FiscalPeriodTableModel.java 3606 2012-08-14 13:05:05Z mallon $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/fiscalperiod/FiscalPeriodTableModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.fiscalperiod;

import static org.nuiton.i18n.I18n._;

import java.text.SimpleDateFormat;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.FiscalPeriod;

/**
 * Modele de Fiscal period (rendu de list)
 *
 * @author chatellier
 * @version $Revision: 3606 $
 *          <p/>
 *          Last update : $Date: 2012-08-14 15:05:05 +0200 (Tue, 14 Aug 2012) $
 *          By : $Author: mallon $
 */
public class FiscalPeriodTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 77027335135838258L;

    private static final Log log = LogFactory.getLog(FiscalPeriodTableModel.class);

    protected List<FiscalPeriod> fiscalPeriods;

    public void setFiscalPeriods(List<FiscalPeriod> fiscalPeriods) {
        this.fiscalPeriods = fiscalPeriods;
        fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (fiscalPeriods != null) {
            result = fiscalPeriods.size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public FiscalPeriod getFiscalPeriodAt(int row) {
        if (row == -1) {
            return null;
        }
        FiscalPeriod result = fiscalPeriods.get(row);
        return result;
    }

    public int getRow(FiscalPeriod period) {
        if (period == null) {
            return -1;
        }
        return fiscalPeriods.indexOf(period);
    }

    @Override
    public String getColumnName(int columnIndex) {

        String result = "n/a";

        switch (columnIndex) {
            case 0:
                result = _("lima.ui.fiscalperiod.fiscalperiod");
                break;
            case 1:
                result = _("lima.ui.fiscalperiod.closure");
                break;
        }

        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {

        Object result = "n/a";

        FiscalPeriod fiscalPeriod = getFiscalPeriodAt(rowIndex);

        if (fiscalPeriod != null) {
            // FIXME echatellier 20120405 i18n problem (hard coded)
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy");

            switch (columnIndex) {
                case 0:
                    result = simpleDateFormat.
                            format(fiscalPeriod.getBeginDate())
                             + " - " + simpleDateFormat.
                            format(fiscalPeriod.getEndDate());
                    break;
                case 1:
                    if (fiscalPeriod.getLocked()) {
                        result = _("lima.ui.fiscalperiod.closed");
                    } else {
                        result = _("lima.ui.fiscalperiod.open");
                    }
                    break;
            }
        }

        return result;
    }

    public void addFiscalPeriod(FiscalPeriod fiscalPeriod) {
        fiscalPeriods.add(fiscalPeriod);
        int row = fiscalPeriods.indexOf(fiscalPeriod);
        fireTableRowsInserted(row, row);
    }

    public void deleteFiscalPeriod(FiscalPeriod fiscalPeriod) {
        int row = fiscalPeriods.indexOf(fiscalPeriod);
        fiscalPeriods.remove(fiscalPeriod);
        fireTableRowsDeleted(row, row);
    }
        
    public void updateFiscalPeriod(FiscalPeriod fiscalPeriod) throws LimaException {
        int row = fiscalPeriods.indexOf(fiscalPeriod);

        if (log.isDebugEnabled()) {
            log.debug("Selected row : " + row);
        }

        fiscalPeriods.set(row, fiscalPeriod);
        fireTableRowsUpdated(row, row);
    }
}
