/*
 * #%L
 * Lima Swing
 * 
 * $Id: FiscalPeriodTable.java 3557 2012-08-01 09:07:09Z mallon $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/fiscalperiod/FiscalPeriodTable.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.fiscalperiod;

import org.chorem.lima.entity.FiscalPeriod;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

/**
 * Fiscal period table add support for JXTable.
 * 
 * Including:
 * <ul>
 * <li>Locked period red highlight
 * <li>
 * </ul>
 * 
 * @author chatellier
 * @version $Revision: 3557 $
 * 
 * Last update : $Date: 2012-08-01 11:07:09 +0200 (Wed, 01 Aug 2012) $
 * By : $Author: mallon $
 */
public class FiscalPeriodTable extends JXTable
        implements KeyListener, MouseListener {

    private static final long serialVersionUID = -8462838870024505659L;

    protected FiscalPeriodTableModel model;

    public FiscalPeriodTable(FiscalPeriodTableModel model) {
        super(model);
        this.model = model;

        addKeyListener(this);
        addMouseListener(this);

        // highlight financial financial transactions
        addBlockColor();
    }

    /**
     * Highlight locked period in RED.
     */
    protected void addBlockColor() {

        HighlightPredicate predicate = new HighlightPredicate() {
            @Override
            public boolean isHighlighted(Component renderer,
                                         ComponentAdapter adapter) {
                FiscalPeriod fiscalPeriod = model.getFiscalPeriodAt(adapter.row);
                return fiscalPeriod.getLocked();
            }
        };
        Highlighter colorTransaction =
                new ColorHighlighter(predicate, null, new Color(222, 0, 0));
        addHighlighter(colorTransaction);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (rowAtPoint(e.getPoint()) == -1) {
            clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /**
     * for each action combination key are think
     * for extend keyboard and laptop keyboard
     */
    @Override
    public void keyPressed(KeyEvent e) {
        // clear row selection with the key: escape
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
            if (!isEditing()) {
                clearSelection();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

}
