package org.chorem.lima.ui.fiscalperiod;
/*
 * #%L
 * Lima :: Swing
 * $Id: FiscalPeriodModelUI.java 3598 2012-08-10 16:31:26Z mallon $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/fiscalperiod/FiscalPeriodModelUI.java $
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.chorem.lima.entity.FiscalPeriod;
import org.jdesktop.beans.AbstractSerializableBean;

public class FiscalPeriodModelUI extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    public static final String BLOCK_ENABLED_PROPERTY = "blockEnabled";
    
    public static final String DELETE_ENABLED_PROPERTY = "deleteEnabled";

    protected FiscalPeriod selectedFiscalPeriod;
    protected boolean blockEnabled;
    protected boolean deleteEnabled;

    public FiscalPeriodModelUI() {
    }
    
    public boolean isDeleteEnabled() {
        return deleteEnabled;
    }
    
    public boolean isBlockEnabled() {
        return blockEnabled;
    }

    public void setBlockEnabled(boolean blockEnabled) {
        Boolean oldValue = isBlockEnabled();
        this.blockEnabled = blockEnabled;
        firePropertyChange(BLOCK_ENABLED_PROPERTY, oldValue, blockEnabled);
    }
    
    public void setDeleteEnabled(boolean deleteEnabled) {        
        Boolean oldValue = isDeleteEnabled();
        this.deleteEnabled = deleteEnabled;
        firePropertyChange(DELETE_ENABLED_PROPERTY, oldValue, deleteEnabled);
    }



}
