package org.chorem.lima.ui.fiscalperiod;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FiscalPeriod;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n._;

public class AddPeriod extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PERIOD = "period";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUzU8TQRSfVtpSPkQhICjEimj0slUPaAIqCKnYlI+IMcRenO4O7cB0Z519K8vF+Cf4J+jdi4k3T8aDZw9ejP+CMR68Gt/stt0uVkDpYbv73vv93sfM773+RlKuIue2qO8byrOB15lRnN/YWK1sMRMWmWsq7oBUJPwlkiRZJr1Wy+4COV8uaXi+Ac8vyLojbWa3oWdKpMeFXcHcGmMAZCKOMF03v95yz/iOp5qsraI6sb788T35wnr+KkmI72B1fdhK7iBU1ElXiSS5BWQQMz2leUHtKpahuF3Fevu1bUFQ112hdfaEPCOZEkk7VCEZkMnDtxxwBHjfAZKdKi5yKmT1CpDLUlUNsyYVqxuC16nhcWOTuyYVDlNcWsa8Za0Fb44TMKSBZGrUtgRTQK4fhC4EHyHBQ852lkJkxDVSlxYT7WEPaEUwINP/Qh1gljVTxJwO4/Bu7GXCGXHYjRG0NTcVkOFoRmOn6O7gmRiBT0dmW4DuqWKJVphAxKA+L78RGlp10HArdqDCqtxepMDWuLmtJ5jTxW3hXd4G6YRI3yhuRCFxgmayq/r7dNzXz2wrjpuIBzRaC7Cn4q4+k9omE3c8AGkDGYo1Elp15GRUiNyOzBcbPkXOxGaGmjIiTUWXPlEmKeWhGYdc/lOG99EVCnB0jwA1YeD9NTL0+d3Xt4Wm6jKYe7hjaNvSQDU4SuK1AK5TD4SS84CL/DJ1Zsok6zKBGyfYKOMdCltvuLE4zHdSww0NN5aoW0OKVObL+w8jjz8dI8kC6RGSWgWq4++RLNQUTkEKy3duzwUV9e104/OErg3IsMU2qSdgQUiXrWKJFLg+iOOzFgWaq3DbwqO45eNMxjvMpFVYJfvx59D6m7nmXBJY59hfw6PZpB6RNLcFt1mwjxqrpuP+6XVc5lkyWimdlkxC//c4DVkZwfNap8ZTqH8qUDqzYfocBdx+FQ8YNqtR00EX+u3G4UlR36FMb/4/SRcwH/bhGDuQQ5vv7sNw9sgMF47McAkZfgOZxaKbgQcAAA==";
    private static final Log log = LogFactory.getLog(AddPeriod.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXDatePicker beginDatePicker;
    protected JButton cancelButton;
    protected JXDatePicker endDatePicker;
    protected FiscalPeriodViewHandler handler;
    protected FiscalPeriodTableModel modelFiscalPeriodTable;
    protected JButton okButton;
    protected FiscalPeriod period;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AddPeriod $JDialog0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void $afterCompleteSetup() {
                getHandler().init(this);
            }
    
            protected void performOk() {
                getPeriod().setBeginDate(beginDatePicker.getDate());
                getPeriod().setEndDate(endDatePicker.getDate());
                dispose();
            }
    
            protected void performCancel() {
                setPeriod(null);
                dispose();
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AddPeriod(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0) {
        super(param0);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod() {
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Window param0) {
        super(param0);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AddPeriod(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AddPeriod(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__okButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performOk();
    }

    public void doWindowClosing__on__$JDialog0(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXDatePicker getBeginDatePicker() {
        return beginDatePicker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JXDatePicker getEndDatePicker() {
        return endDatePicker;
    }

    public FiscalPeriodViewHandler getHandler() {
        return handler;
    }

    public FiscalPeriodTableModel getModelFiscalPeriodTable() {
        return modelFiscalPeriodTable;
    }

    public JButton getOkButton() {
        return okButton;
    }

    public FiscalPeriod getPeriod() {
        return period;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setPeriod(FiscalPeriod period) {
        FiscalPeriod oldValue = this.period;
        this.period = period;
        firePropertyChange(PROPERTY_PERIOD, oldValue, period);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBeginDatePicker() {
        $objectMap.put("beginDatePicker", beginDatePicker = new JXDatePicker());
        
        beginDatePicker.setName("beginDatePicker");
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("lima.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createEndDatePicker() {
        $objectMap.put("endDatePicker", endDatePicker = new JXDatePicker());
        
        endDatePicker.setName("endDatePicker");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(FiscalPeriodView.class,JAXXUtil.PARENT).getHandler());
    }

    protected void createModelFiscalPeriodTable() {
        $objectMap.put("modelFiscalPeriodTable", modelFiscalPeriodTable = new FiscalPeriodTableModel());
    }

    protected void createOkButton() {
        $objectMap.put("okButton", okButton = new JButton());
        
        okButton.setName("okButton");
        okButton.setText(_("lima.common.ok"));
        okButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__okButton"));
    }

    protected void createPeriod() {
        $objectMap.put("period", period = new org.chorem.lima.entity.FiscalPeriodImpl());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDatePicker, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDatePicker, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(cancelButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 1 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        // late initializer
        $JDialog0.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createHandler();
        createModelFiscalPeriodTable();
        createPeriod();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.common.begindate"));
        createBeginDatePicker();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.enddate"));
        createEndDatePicker();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createCancelButton();
        createOkButton();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        setTitle(_("lima.ui.fiscalperiod.addfiscalperiodtitle"));
        $JDialog0.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__$JDialog0"));
        
        $completeSetup();
    }

}