/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialTransactionUnbalancedTableModel.java 3683 2013-06-19 07:42:34Z Bavencoff $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/financialtransactionunbalanced/FinancialTransactionUnbalancedTableModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialtransactionunbalanced;

import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.financialtransaction.AccountColumn;
import org.chorem.lima.ui.financialtransaction.CreditColumn;
import org.chorem.lima.ui.financialtransaction.DateColumn;
import org.chorem.lima.ui.financialtransaction.DebitColumn;
import org.chorem.lima.ui.financialtransaction.DescriptionColumn;
import org.chorem.lima.ui.financialtransaction.EntryBookColumn;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.chorem.lima.ui.financialtransaction.LetterColumn;
import org.chorem.lima.ui.financialtransaction.VoucherColumn;

import java.util.List;

/**
 * Basic transaction table model.
 * <p/>
 * Le modele est filtré sur {@link #selectedFiscalPeriod}(montée en charge !).
 *
 * @author ore
 * @author chatellier
 */
public class FinancialTransactionUnbalancedTableModel extends FinancialTransactionTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3914954536809622358L;

    /** selected financial period */
    protected FiscalPeriod selectedFiscalPeriod;

    protected void initColumns() {
        columns.add(new DateColumn(this));
        columns.add(new EntryBookColumn(this));
        columns.add(new VoucherColumn(this));
        columns.add(new AccountColumn(this));
        columns.add(new DescriptionColumn(this));
        columns.add(new DebitColumn(this));
        columns.add(new CreditColumn(this));
        columns.add(new LetterColumn(this));
    }

    /**
     * Le model est une combinaison de Transaction/entries.
     *
     * @return
     */
    protected void refresh() {
        transactions.clear();

        if (selectedFiscalPeriod != null) {
            List<FinancialTransaction> financialTransactions =
                    financialTransactionService.getAllInexactFinancialTransactions(selectedFiscalPeriod);
            transactions.addAll(financialTransactions);
            sortEntries();
        }
    }

    public void setFiscalPeriod(FiscalPeriod fiscalPeriod) {
        selectedFiscalPeriod = fiscalPeriod;
    }
}
