/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialTransactionUnbalancedTable.java 3683 2013-06-19 07:42:34Z Bavencoff $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/financialtransactionunbalanced/FinancialTransactionUnbalancedTable.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialtransactionunbalanced;

import org.chorem.lima.ui.common.CellRouteHorizontalAction;
import org.chorem.lima.ui.common.CellRouteVerticalAction;
import org.chorem.lima.ui.common.Column;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;

import javax.swing.*;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * Table des transaction qui ajoute des comportement (keys).
 *
 * @author ore
 * @author Rémi Chapelet
 */
public class FinancialTransactionUnbalancedTable extends JTable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3133690382049594727L;

    protected final FinancialTransactionUnbalancedViewHandler handler;

    private Highlighter colorTransaction;

    private ColorHighlighter colorBalance;

    public FinancialTransactionUnbalancedTable(final FinancialTransactionUnbalancedViewHandler handler) {

        this.handler = handler;

        setShowHorizontalLines(true);
        setShowVerticalLines(true);
        setGridColor(new Color(210,210,210));

        InputMap inputMap= getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        ActionMap actionMap = getActionMap();

        // action on Tab
        Object binding = inputMap.get(KeyStroke.getKeyStroke(KeyEvent.VK_TAB, 0));
        actionMap.put(binding, new CellRouteHorizontalAction(this, true));

        // action on Shift + Tab
        binding = inputMap.get(KeyStroke.getKeyStroke(KeyEvent.VK_TAB, KeyEvent.SHIFT_DOWN_MASK));
        actionMap.put(binding, new CellRouteHorizontalAction(this, false));

        // action on Enter
        binding = inputMap.get(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0));
        actionMap.put(binding, new CellRouteVerticalAction(this, true));

        // action on Shift + Enter
        binding = inputMap.get(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, KeyEvent.SHIFT_DOWN_MASK));
        actionMap.put(binding, new CellRouteVerticalAction(this, false));

        // add action on Ctrl + Shift + Delete
        binding = "delete-transaction";
        inputMap.put(KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, KeyEvent.CTRL_DOWN_MASK + KeyEvent.SHIFT_DOWN_MASK), binding);
        actionMap.put(binding, new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                handler.deleteSelectedTransaction();
            }
        });

        // add action on Ctrl + N
        binding = "new-entry";
        inputMap.put(KeyStroke.getKeyStroke(KeyEvent.VK_N, KeyEvent.CTRL_DOWN_MASK), binding);
        actionMap.put(binding, new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                handler.addEntry();
            }
        });

        // add action on Ctrl + Delete
        binding = "delete-entry";
        inputMap.put(KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, KeyEvent.CTRL_DOWN_MASK), binding);
        actionMap.put(binding, new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                handler.deleteSelectedEntry();
            }
        });

        // add action on Ctrl + B
        binding = "balance";
        inputMap.put(KeyStroke.getKeyStroke(KeyEvent.VK_B, KeyEvent.CTRL_DOWN_MASK), binding);
        actionMap.put(binding, new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                    handler.balanceTransaction();
            }
        });

        addMouseListener(new MyMouseAdapter());

    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer;
        FinancialTransactionTableModel tableModel = (FinancialTransactionTableModel) getModel();
        Column columnTable = tableModel.getColumn(column);
        renderer = columnTable.getCellRenderer(row);
        if (renderer == null) {
            renderer = super.getCellRenderer(row, column);
        }
        return renderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor;
        FinancialTransactionTableModel tableModel = (FinancialTransactionTableModel) getModel();
        Column columnTable = tableModel.getColumn(column);
        editor = columnTable.getCellEditor(row);
        if (editor == null) {
            editor = super.getCellEditor(row, column);
        }
        return editor;
    }

    private class MyMouseAdapter extends MouseAdapter {

        @Override
        public void mousePressed(MouseEvent e) {
            if (rowAtPoint(e.getPoint()) == -1) {
                clearSelection();
            }
        }
    }

}
