package org.chorem.lima.ui.financialtransaction;

/*
 * #%L
 * Lima :: Swing
 * $Id: VoucherColumn.java 3695 2013-07-10 09:11:39Z athimel $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/financialtransaction/VoucherColumn.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.celleditor.EntryTableCellRenderer;
import org.chorem.lima.ui.celleditor.StringTableCellEditor;

import static org.nuiton.i18n.I18n._;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class VoucherColumn extends FinancialTransactionColumn {

    public VoucherColumn(FinancialTransactionTableModel tableModel) {
        super(tableModel);
        renderer = new EntryTableCellRenderer();
        editor = new StringTableCellEditor();
    }

    @Override
    public Class<?> getColumnClass() {
        return String.class;
    }

    @Override
    public String getColumnName() {
        return _("lima.ui.financialtransaction.voucher");
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = tableModel.getEntryAt(row);
        return entry.getVoucher();
    }

    @Override
    public boolean isCellEditable(int row) {
        return true;
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        Entry entry = tableModel.getEntryAt(row);
        String voucher = ((String) value).trim();

        boolean update = (entry.getVoucher() == null || entry.getVoucher().compareTo(voucher) != 0);
        if (update) {
            entry.setVoucher(voucher);
            tableModel.updateEntry(entry);
        }
        return update;
    }
}
