package org.chorem.lima.ui.financialtransaction;

/*
 * #%L
 * Lima :: Swing
 * $Id: FinancialTransactionDefaultTable.java 3698 2013-08-02 15:06:11Z Bavencoff $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/financialtransaction/FinancialTransactionDefaultTable.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.common.CellRouteHorizontalAction;
import org.chorem.lima.ui.common.CellRouteVerticalAction;
import org.chorem.lima.ui.common.Column;

import javax.swing.*;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class FinancialTransactionDefaultTable extends JTable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3133690382049594727L;

    private static final Log log = LogFactory.getLog(FinancialTransactionTable.class);

    public FinancialTransactionDefaultTable() {

        setShowHorizontalLines(true);
        setShowVerticalLines(true);
        setGridColor(new Color(210,210,210));

        initNavigation();

        addMouseListener(new MyMouseAdapter());
    }

    protected void initNavigation() {
        InputMap inputMap= getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        ActionMap actionMap = getActionMap();

        // action on Tab
        Object binding = inputMap.get(KeyStroke.getKeyStroke(KeyEvent.VK_TAB, 0));
        actionMap.put(binding, new CellRouteHorizontalAction(this, true));

        // action on Shift + Tab
        binding = inputMap.get(KeyStroke.getKeyStroke(KeyEvent.VK_TAB, KeyEvent.SHIFT_DOWN_MASK));
        actionMap.put(binding, new CellRouteHorizontalAction(this, false));

        // action on Enter
        binding = inputMap.get(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0));
        actionMap.put(binding, new CellRouteVerticalAction(this, true));

        // action on Shift + Enter
        binding = inputMap.get(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, KeyEvent.SHIFT_DOWN_MASK));
        actionMap.put(binding, new CellRouteVerticalAction(this, false));

    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer;
        FinancialTransactionTableModel tableModel = (FinancialTransactionTableModel) getModel();
        Column columnTable = tableModel.getColumn(column);
        renderer = columnTable.getCellRenderer(row);
        if (renderer == null) {
            renderer = super.getCellRenderer(row, column);
        }
        return renderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor;
        FinancialTransactionTableModel tableModel = (FinancialTransactionTableModel) getModel();
        Column columnTable = tableModel.getColumn(column);
        editor = columnTable.getCellEditor(row);
        if (editor == null) {
            editor = super.getCellEditor(row, column);
        }
        return editor;
    }

    public void exit() {
        if (isEditing()) {
            TableCellEditor editor = getCellEditor();
            editor.stopCellEditing();
        }
    }

    private class MyMouseAdapter extends MouseAdapter {

        @Override
        public void mousePressed(MouseEvent e) {
            if (rowAtPoint(e.getPoint()) == -1) {
                clearSelection();
            }
        }
    }
}
