package org.chorem.lima.ui.financialtransaction;

/*
 * #%L
 * Lima :: Swing
 * $Id: EntryBookColumn.java 3695 2013-07-10 09:11:39Z athimel $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/financialtransaction/EntryBookColumn.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.celleditor.EntryBookTableCellEditor;
import org.chorem.lima.ui.celleditor.EntryBookTableCellRender;

import static org.nuiton.i18n.I18n._;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class EntryBookColumn extends FinancialTransactionColumn {


    public EntryBookColumn(FinancialTransactionTableModel tableModel) {
        super(tableModel);
        renderer = new EntryBookTableCellRender();
        editor = new EntryBookTableCellEditor();
    }

    @Override
    public Class<?> getColumnClass() {
        return EntryBook.class;
    }

    @Override
    public String getColumnName() {
        return _("lima.table.entrybook");
    }

    @Override
    public Object getValueAt(int row) {
        EntryBook result;
        Entry entry = tableModel.getEntryAt(row);
        FinancialTransaction transaction = entry.getFinancialTransaction();
        if (row == 0 || tableModel.getEntryAt(row - 1).getFinancialTransaction() != transaction) {
            result = transaction.getEntryBook(); // date
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int row) {
        return row == 0
                || tableModel.getEntryAt(row).getFinancialTransaction() != tableModel.getEntryAt(row - 1).getFinancialTransaction();
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        FinancialTransaction transaction = tableModel.getTransactionAt(row);
        EntryBook entryBook = (EntryBook) value;
        boolean update = (transaction.getEntryBook().getCode().compareTo(entryBook.getCode()) != 0);
        if (update) {
            transaction.setEntryBook(entryBook);
            tableModel.updateTransaction(transaction);
        }
        return update;
    }
}
