package org.chorem.lima.ui.financialtransaction;

/*
 * #%L
 * Lima :: Swing
 * $Id: AccountColumn.java 3695 2013-07-10 09:11:39Z athimel $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/financialtransaction/AccountColumn.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.celleditor.AccountTableCellEditor;
import org.chorem.lima.ui.celleditor.AccountTableCellRenderer;

import static org.nuiton.i18n.I18n._;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class AccountColumn extends FinancialTransactionColumn {

    public AccountColumn(FinancialTransactionTableModel tableModel) {
        super(tableModel);
        renderer = new AccountTableCellRenderer();
        editor = new AccountTableCellEditor();
    }

    @Override
    public Class<?> getColumnClass() {
        return Account.class;
    }

    @Override
    public String getColumnName() {
        return _("lima.ui.financialtransaction.account");
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = tableModel.getEntryAt(row);
        return entry.getAccount();
    }

    @Override
    public boolean isCellEditable(int row) {
        return true;
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        Entry entry = tableModel.getEntryAt(row);
        Account account = (Account) value;
        boolean update = ((entry.getAccount()) == null != (account == null))
                || (entry.getAccount() != null
                && account != null
                && !entry.getAccount().getAccountNumber().equals(account.getAccountNumber()));
        if (update) {
            entry.setAccount(account);
            tableModel.updateEntry(entry);
        }
        return update;
    }
}
