/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialStatementReportTable.java 3557 2012-08-01 09:07:09Z mallon $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/financialstatementreport/FinancialStatementReportTable.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialstatementreport;

import org.chorem.lima.beans.FinancialStatementAmounts;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class FinancialStatementReportTable extends JXTable
        implements KeyListener, MouseListener {

    private static final long serialVersionUID = 154211277688304679L;

    protected FinancialStatementReportTableModel model;

    private Highlighter colorTransaction;

    /*
    * Constructor, call highlighter
    */
    public FinancialStatementReportTable(FinancialStatementReportTableModel model) {
        super(model);

        addKeyListener(this);
        addMouseListener(this);

        this.model = model;

        //highlight financial financial transactions
        colorTitle1();
        colorTitle2();

        //Renderer for font
        FinancialStatementReportTableCellRenderer renderer = new FinancialStatementReportTableCellRenderer();
        for (int i = 0; i < getColumnModel().getColumnCount(); i++) {
            getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
    }

    /*
     * Color the background row in grey if the level is 1
     */
    protected void colorTitle1() {


        HighlightPredicate predicate = new HighlightPredicate() {
            @Override
            public boolean isHighlighted(Component renderer,
                                         ComponentAdapter adapter) {
                Boolean result = false;
                Object object = model.getElementAt(adapter.row);
                if (model.getElementAt(adapter.row) instanceof FinancialStatementAmounts) {
                    FinancialStatementAmounts financialStatementAmounts = (FinancialStatementAmounts) object;
                    result = financialStatementAmounts.getLevel() == 1;
                }
                return result;
            }
        };
        colorTransaction =
                new ColorHighlighter(predicate, new Color(222, 222, 222), null);
        addHighlighter(colorTransaction);
    }

    /*
    * Color the background in light grey if is a subamount
    */
    protected void colorTitle2() {


        HighlightPredicate predicate = new HighlightPredicate() {
            @Override
            public boolean isHighlighted(Component renderer,
                                         ComponentAdapter adapter) {
                Boolean result = false;
                Object object = model.getElementAt(adapter.row);
                if (model.getElementAt(adapter.row) instanceof FinancialStatementAmounts) {
                    FinancialStatementAmounts financialStatementAmounts = (FinancialStatementAmounts) object;
                    result = financialStatementAmounts.getSubAmount();
                }
                return result;
            }
        };
        colorTransaction =
                new ColorHighlighter(predicate, new Color(244, 244, 244), null);
        addHighlighter(colorTransaction);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (rowAtPoint(e.getPoint()) == -1) {
            clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /**
     * for each action combination key are think
     * for extend keyboard and laptop keyboard
     */
    @Override
    public void keyPressed(KeyEvent e) {
        // clear row selection with the key: escape
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
            if (!isEditing()) {
                clearSelection();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

}
