/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialPeriodViewHandler.java 3614 2012-08-20 11:59:56Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/financialperiod/FinancialPeriodViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialperiod;

import static org.nuiton.i18n.I18n._;

import java.util.Collections;
import java.util.List;

import javax.swing.JOptionPane;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.utils.FinancialPeriodComparator;
import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.service.LimaServiceFactory;
import org.jdesktop.swingx.JXTable;

/**
 * Handler for FinancialPeriodView.
 *
 * @author chatellier
 * @version $Revision: 3614 $
 * 
 * Last update : $Date: 2012-08-20 13:59:56 +0200 (Mon, 20 Aug 2012) $
 * By : $Author: echatellier $
 */
public class FinancialPeriodViewHandler implements ServiceListener {

    private static final Log log = LogFactory.getLog(FinancialPeriodViewHandler.class);

    protected FinancialPeriodService financialPeriodService;

    protected FinancialPeriodView view;

    protected FinancialPeriodViewHandler(FinancialPeriodView view) {
        this.view = view;
        
        financialPeriodService = LimaServiceFactory.getService(FinancialPeriodService.class);
        LimaServiceFactory.addServiceListener(ImportService.class, this);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, this);
    }

    /**
     * Init view.
     */
    public void init() {

        // get data from service
        List<ClosedPeriodicEntryBook> closedPeriodicEntryBooks = financialPeriodService.
                getAllClosedPeriodicEntryBooksFromUnblockedFiscalPeriod();
        Collections.sort(closedPeriodicEntryBooks, new FinancialPeriodComparator());
        if (log.isDebugEnabled()) {
            log.debug(String.format("Loaded %d closed periodic entry book", closedPeriodicEntryBooks.size()));
        }

        // notify ui
        view.getFinancialPeriodTableModel().setClosedPeriodicEntryBooks(closedPeriodicEntryBooks);
    }

    /**
     * Block selected period.
     */
    public void blockFinancialPeriod() {
        JXTable financialPeriodeTable = view.getFinancialPeriodTable();
        int selectedRow = financialPeriodeTable.getSelectedRow();
        FinancialPeriodTableModel model = (FinancialPeriodTableModel) view.getFinancialPeriodTable().getModel();

        // blocked it
        ClosedPeriodicEntryBook closedPeriodicEntryBook = model.getElementAt(selectedRow);
        int response = JOptionPane.showConfirmDialog(view, _("lima.ui.financialperiod.blockmessage"),
            _("lima.ui.financialperiod.blocktitle"),
            JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);

        if (response == JOptionPane.YES_OPTION) {
            closedPeriodicEntryBook = financialPeriodService.blockClosedPeriodicEntryBook(closedPeriodicEntryBook);
            model.setElementAt(selectedRow, closedPeriodicEntryBook);
        }
    }

    @Override
    public void notifyMethod(String serviceName, String methodName) {
        if (serviceName.contains("FiscalPeriod") || methodName.contains("importAll")) {
            init();
        }
    }
}
