/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialPeriodTableModel.java 3614 2012-08-20 11:59:56Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/financialperiod/FinancialPeriodTableModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialperiod;

import static org.nuiton.i18n.I18n._;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialPeriod;

/**
 * Financial period table model.
 *
 * @author chatellier
 * @version $Revision: 3614 $
 * 
 * Last update : $Date: 2012-08-20 13:59:56 +0200 (Mon, 20 Aug 2012) $
 * By : $Author: echatellier $
 */
public class FinancialPeriodTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 77027335135838258L;

    /** Datas cache */
    protected List<ClosedPeriodicEntryBook> closedPeriodicEntryBooks;

    public FinancialPeriodTableModel() {

    }

    /**
     * Update model data list.
     * 
     * @param closedPeriodicEntryBooks new data
     */
    public void setClosedPeriodicEntryBooks(List<ClosedPeriodicEntryBook> closedPeriodicEntryBooks) {
        this.closedPeriodicEntryBooks = closedPeriodicEntryBooks;
        fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (closedPeriodicEntryBooks != null) {
            result = closedPeriodicEntryBooks.size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {

        String result = "n/a";

        switch (columnIndex) {
            case 0:
                result = _("lima.ui.financialperiod.period");
                break;
            case 1:
                result = _("lima.ui.financialperiod.entrybook");
                break;
            case 2:
                result = _("lima.ui.financialperiod.closure");
                break;
        }

        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        // both String
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public ClosedPeriodicEntryBook getElementAt(int row) {
        ClosedPeriodicEntryBook currentRow = closedPeriodicEntryBooks.get(row);
        return currentRow;
    }

    public void setElementAt(int row, ClosedPeriodicEntryBook closedPeriodicEntryBook) {
        closedPeriodicEntryBooks.set(row, closedPeriodicEntryBook);
        fireTableRowsUpdated(row, row);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;

        ClosedPeriodicEntryBook closedPeriodicEntryBook = getElementAt(rowIndex);

        switch (columnIndex) {
            case 0:
                // FIXME echatellier 20120413 remove hardcoded french date format
                DateFormat df = new SimpleDateFormat("dd MMM yyyy");
                FinancialPeriod financialPeriod = closedPeriodicEntryBook.getFinancialPeriod();
                result = df.format(financialPeriod.getBeginDate())
                         + " - " + df.format(financialPeriod.getEndDate());
                break;
            case 1:
                EntryBook entryBook = closedPeriodicEntryBook.getEntryBook();
                result = entryBook.getCode() + " - " + entryBook.getLabel();
                break;
            case 2:
                if (closedPeriodicEntryBook.getLocked()) {
                    result = _("lima.common.closed");
                } else {
                    result = _("lima.common.open");
                }
                break;
        }

        return result;
    }
}
