/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialPeriodTable.java 3557 2012-08-01 09:07:09Z mallon $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/financialperiod/FinancialPeriodTable.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialperiod;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

/**
 * Financial period table adding color hidhlighter and key management.
 * 
 * @author chatellier
 * @version $Revision: 3557 $
 * 
 * Last update : $Date: 2012-08-01 11:07:09 +0200 (Wed, 01 Aug 2012) $
 * By : $Author: mallon $
 */
public class FinancialPeriodTable extends JXTable implements KeyListener, MouseListener {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1960326844433064178L;

    protected FinancialPeriodViewHandler handler;

    protected FinancialPeriodTableModel model;

    /**
     * Constructor, install highlighter.
     * 
     * @param handler
     */
    public FinancialPeriodTable(FinancialPeriodViewHandler handler) {
        this.handler = handler;
        model = handler.view.getFinancialPeriodTableModel();

        addKeyListener(this);
        addMouseListener(this);

        //highlight financial financial transactions
        addStripingColor();
        addBlockColor();
    }

    /**
     * Color the background row in grey if the month number is even (pair in french)
     */
    protected void addStripingColor() {
        Highlighter colorTransaction = HighlighterFactory.createSimpleStriping(new Color(233,233,233));
        addHighlighter(colorTransaction);
    }

    /**
     * Color the font in red if period are closed
     */
    protected void addBlockColor() {
        HighlightPredicate predicate = new HighlightPredicate() {
            @Override
            public boolean isHighlighted(Component renderer,
                                         ComponentAdapter adapter) {
                ClosedPeriodicEntryBook closedPeriodicEntryBook =
                        (ClosedPeriodicEntryBook) model.getElementAt(adapter.row);
                return closedPeriodicEntryBook.getLocked();
            }
        };
        Highlighter colorTransaction =
                new ColorHighlighter(predicate, null, new Color(222, 0, 0));
        addHighlighter(colorTransaction);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (rowAtPoint(e.getPoint()) == -1) {
            clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /**
     * for each action combination key are think
     * for extend keyboard and laptop keyboard
     */
    @Override
    public void keyPressed(KeyEvent e) {
        // clear row selection with the key: escape
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
            if (!isEditing()) {
                clearSelection();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

}
