/*
 * #%L
 * Lima Swing
 * 
 * $Id: EntryBookTableModel.java 3354 2012-04-05 14:09:35Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/entrybook/EntryBookTableModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.entrybook;

import static org.nuiton.i18n.I18n._;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import org.chorem.lima.entity.EntryBook;

/**
 * Entry book table model only rendering entry book list.
 *
 * @author ore
 * @author chatellier
 * @version $Revision: 3354 $
 *          <p/>
 *          Last update : $Date: 2012-04-05 16:09:35 +0200 (Thu, 05 Apr 2012) $
 *          By : $Author: echatellier $
 */
public class EntryBookTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 7578692417919755647L;

    protected List<EntryBook> entryBooks;

    public EntryBookTableModel(List<EntryBook> entryBooks) {
        this.entryBooks = entryBooks;
    }

    @Override
    public int getRowCount() {
        int result = entryBooks.size();
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0:
                res = _("lima.ui.entrybook.code");
                break;
            case 1:
                res = _("lima.ui.entrybook.label");
                break;
        }
        return res;
    }

    public EntryBook getEntryBookAtRow(int row) {
        EntryBook entryBook = entryBooks.get(row);
        return entryBook;
    }

    @Override
    public Object getValueAt(int row, int column) {

        Object result = null;
        EntryBook entryBook = getEntryBookAtRow(row);

        switch (column) {
            case 0:
                result = entryBook.getCode();
                break;
            case 1:
                result = entryBook.getLabel();
                break;
        }

        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void addEntryBook(EntryBook entryBook) {
        entryBooks.add(entryBook);
        int row = entryBooks.indexOf(entryBook);
        fireTableRowsInserted(row, row);
    }

    public void updateEntryBook(EntryBook entryBook) {
        int row = entryBooks.indexOf(entryBook);
        fireTableRowsUpdated(row, row);
    }

    public void removeEntryBook(EntryBook entryBook) {
        int row = entryBooks.indexOf(entryBook);
        entryBooks.remove(entryBook);
        fireTableRowsDeleted(row, row);
    }
}
