package org.chorem.lima.ui.combobox;
/*
 * #%L
 * Lima :: Swing
 * $Id: LetterComboBoxModel.java 3675 2013-05-03 15:58:31Z athimel $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/combobox/LetterComboBoxModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.AccountService;
import org.chorem.lima.business.api.FinancialTransactionService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.Account;
import org.chorem.lima.service.LimaServiceFactory;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import java.util.List;

/**
 * Date: 13/08/12
 *
 * @author mallon <mallon@codelutin.com>
 * @since 0.6-alpha-2
 */
public class LetterComboBoxModel extends AbstractListModel implements ComboBoxModel, ServiceListener {

    private static final long serialVersionUID = 1L;

    private static final Log log =
            LogFactory.getLog(AccountComboBoxModel.class);

    protected Object selectedAccount;

    protected List<String> datasCache;

    protected FinancialTransactionService financialTransactionService;

    public LetterComboBoxModel() {
        financialTransactionService =
                LimaServiceFactory.getService(FinancialTransactionService.class);
        LimaServiceFactory.addServiceListener(FinancialTransactionService.class, this);
        datasCache = getDataList();
    }

    @Override
    public Object getSelectedItem() {
        return selectedAccount;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        selectedAccount = anItem;
        fireContentsChanged(this, -1, -1);
    }


    @Override
    public Object getElementAt(int index) {
        return datasCache.get(index);
    }

    @Override
    public int getSize() {
        return datasCache.size();
    }

    public List<String> getDataList() {
        List<String> result = null;
        try {
            result = financialTransactionService.getAllLetters();
        } catch (LimaException eee) {
            if (log.isDebugEnabled()) {
                log.debug("Can't get list letters", eee);
            }
        }
        return result;

    }

    public void refresh() {
        datasCache = getDataList();
        fireContentsChanged(this, 0, datasCache.size());
    }

    @Override
    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("Letter") ||
                methodeName.contains("importAll")) {
            refresh();
        }
    }

}
