package org.chorem.lima.ui.celleditor;

/*
 * #%L
 * Lima :: Swing
 * $Id: EntryTableCellRenderer.java 3700 2013-08-02 16:38:54Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/celleditor/EntryTableCellRenderer.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.chorem.lima.ui.common.TableModelWithGroup;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTable;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import sun.swing.DefaultLookup;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import java.awt.*;
import java.io.Serializable;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class EntryTableCellRenderer implements TableCellRenderer, Serializable {

        private String text = null;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            //Create a new JLabel to avoid colouring only when row is selected

            JLabel myCell = new JLabel();
            myCell.setOpaque(true);
            myCell.setBorder(new EmptyBorder(1, 1, 1, 1));
            myCell.setName("Table.entryCellRenderer");

            Color background = Color.WHITE;
            Color foreground = Color.BLACK;

            if (isSelected) {
                foreground = table.getSelectionForeground();
                background = table.getSelectionBackground();
            } else {
                //FIXME tchemit-2013-08_02 Do not use sun. classes
                Color alternateColor = DefaultLookup.getColor(myCell, myCell.getUI(), "Table.alternateRowColor");
                if (alternateColor != null) {

                    if (table.getModel() instanceof TableModelWithGroup) {
                        TableModelWithGroup model = (TableModelWithGroup) table.getModel();
                        if (model.indexGroupAt(row) % 2 != 0) {
                            background = alternateColor;
                        }
                    } else if (row % 2 == 0) {
                        background = alternateColor;
                    }
                }
            }

            if (table.isCellEditable(row, column)
                    && (value == null
                    || (value instanceof String) && ((String) value).isEmpty()
                        )
                    ) {
                background = new Color(255, 198, 209);
            }

            if (table instanceof FinancialTransactionTable) {
                FinancialTransactionTableModel model = (FinancialTransactionTableModel) ((FinancialTransactionTable)table).getModel();
                if (model.getBalanceTransactionInRow(row).signum() != 0) {
                    foreground = new Color(240, 30, 30);
                }
            }

            if (hasFocus) {
                Border border = null;
                if (isSelected) {
                    //FIXME tchemit-2013-08_02 Do not use sun. classes
                    border = DefaultLookup.getBorder(myCell, myCell.getUI(), "Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    //FIXME tchemit-2013-08_02 Do not use sun. classes
                    border = DefaultLookup.getBorder(myCell, myCell.getUI(), "Table.focusCellHighlightBorder");
                }
                myCell.setBorder(border);
                if (table.getModel().isCellEditable(row, column)) {
                    background = Color.WHITE;
                    foreground = Color.BLACK;
                }
            } else {
                //FIXME tchemit-2013-08_02 Do not use sun. classes
                Border border = DefaultLookup.getBorder(myCell, myCell.getUI(), "Table.cellNoFocusBorder");
                if (border == null) {
                    border = new EmptyBorder(1, 1, 1, 1);
                }
                myCell.setBorder(border);
            }

            myCell.setBackground(background);
            myCell.setForeground(foreground);
            setValue(value);

            myCell.setText(text);

            return myCell;
        }

        protected void setValue(Object value) {
            this.text = (value == null) ? "" : value.toString();
        }
    }
