package org.chorem.lima.ui.accountsreports;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.common.AccountComboBoxModel;
import org.chorem.lima.ui.common.IntervalPanel;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import static org.nuiton.i18n.I18n._;

public class AccountsReportsView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTU8UQRCtXdmFBREFJRgxrkhi4mEWiDExoPJhCJBFDRhD3Is9Mx12sGe67e6B8WL8Cf4EvXsx8ebJePDswYvxLxjjwauxemZ2ZxeGSHAPszPV9V69qq6qtz+gpCRc3iFRZMkw0J5PrbWFra379g519F2qHOkJzSUkv0IRig0YcNt2peFKo27gtRReW+K+4AENOtCzdehX+jmjqkmp1nCxG+EoVdtsH89GIpQt1raoPNbXv34WX7kv3xQBIoHq+jGV6r9QWSY9dSh6roZhjLRLaowE2yhDesE26h00tiVGlLpHfPoMXkBvHcqCSCTTMHH0lGOOGB8JDb2TD4nN6JSGG1xuW06TS+pbzPOJFXoWcRyOlEpSwaVW1kL6vZF8P/LonhAxWRmpmiRwGZUabh2PaiXBZ4yDXqCp3CXsAQko03A1h9fhvs8Da7XT08Arma4kxWkNY113ofawslZ81g04m2rdpAx7jss6sU30YXMDUQpbi40GMHwAh9W3uc2jde4anHW46oUOwGIKyNIfIt3HGmaOXtgWqFtij02cpxpGulJZDLXmwT7HgEbavFf32ZvaZ512CRe6qoqzY2WzkzV3oQElGaIZr6FxcNw28CgZtLF9g2YI49M/oyNfP3x/v9yarjLGPpfr2rEcsOuF5AK70jOhh5LRCrXHautEzDagotJbxtPxHGGtJkBxGO+MgVsGbq0Q1USKUu+3j59Gn3w5AcVl6GecuMvE+K9CRTclVoEzNxJ35mNFJ/f68HnaaMNSaiwxttWcFzAvoFWicdbtUNPbEZZhPKcMbS125fPvkc13861SFFDa+UPds3KUHkM5iRavmnSL5K6WAaFo6PJsW+Ttj4L5HxVpy16Ln1ZeriU/mYVTcy7RpGp7gYuth4kaxEycgXm7HhOOH4GwD/eeSyWVxuPmcXmMeco8pvMZLv03w8R/M0wiw1/T15juFwcAAA==";
    private static final Log log = LogFactory.getLog(AccountsReportsView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AccountComboBox accountComboBox;
    protected AccountComboBoxModel accountComboboxModel;
    protected JLabel accountSelectorLabel;
    protected JButton back;
    protected AccountsReportsViewHandler handler;
    protected JButton html;
    protected IntervalPanel intervalPanel;
    protected JButton next;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AccountsReportsView $Table0 = this;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
                handler.init();
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccountsReportsView() {
        $initialize();
    }

    public AccountsReportsView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__back(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accountComboBox.back();
    }

    public void doActionPerformed__on__html(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createDocument();
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accountComboBox.next();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AccountComboBox getAccountComboBox() {
        return accountComboBox;
    }

    public AccountComboBoxModel getAccountComboboxModel() {
        return accountComboboxModel;
    }

    public JLabel getAccountSelectorLabel() {
        return accountSelectorLabel;
    }

    public JButton getBack() {
        return back;
    }

    public AccountsReportsViewHandler getHandler() {
        return handler;
    }

    public JButton getHtml() {
        return html;
    }

    public IntervalPanel getIntervalPanel() {
        return intervalPanel;
    }

    public JButton getNext() {
        return next;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAccountComboBox() {
        $objectMap.put("accountComboBox", accountComboBox = new AccountComboBox());
        
        accountComboBox.setName("accountComboBox");
    }

    protected void createAccountComboboxModel() {
        $objectMap.put("accountComboboxModel", accountComboboxModel = new AccountComboBoxModel());
    }

    protected void createAccountSelectorLabel() {
        $objectMap.put("accountSelectorLabel", accountSelectorLabel = new JLabel());
        
        accountSelectorLabel.setName("accountSelectorLabel");
        accountSelectorLabel.setText(_("lima.common.account"));
    }

    protected void createBack() {
        $objectMap.put("back", back = new JButton());
        
        back.setName("back");
        back.setText(_("lima.common.buttonback"));
        back.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__back"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new AccountsReportsViewHandler(this));
    }

    protected void createHtml() {
        $objectMap.put("html", html = new JButton());
        
        html.setName("html");
        html.setText(_("lima.common.generateHtml"));
        html.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__html"));
    }

    protected void createIntervalPanel() {
        $objectMap.put("intervalPanel", intervalPanel = new IntervalPanel());
        
        intervalPanel.setName("intervalPanel");
    }

    protected void createNext() {
        $objectMap.put("next", next = new JButton());
        
        next.setName("next");
        next.setText(_("lima.common.buttonnext"));
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(intervalPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($Table1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(accountSelectorLabel, new GridBagConstraints(0, 0, 1, 1, 0.125, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(accountComboBox, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(back, new GridBagConstraints(2, 0, 1, 1, 0.125, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(next, new GridBagConstraints(3, 0, 1, 1, 0.125, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(html, new GridBagConstraints(4, 0, 1, 1, 0.125, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 2 property setters
        accountComboBox.setModel(accountComboboxModel);
        accountComboBox.setRenderer(new org.chorem.lima.ui.common.AccountListRenderer());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createIntervalPanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createAccountSelectorLabel();
        createAccountComboboxModel();
        createAccountComboBox();
        createBack();
        createNext();
        createHtml();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}