package org.chorem.lima.ui;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaContext;
import org.chorem.lima.enums.ImportExportEnum;
import static org.nuiton.i18n.I18n._;

public class MainView extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_I18N_EN_ENABLED = "i18n_en.enabled";
    public static final String BINDING_I18N_FR_ENABLED = "i18n_fr.enabled";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JFRAME0_UNDECORATED = "$JFrame0.undecorated";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALWay08kVRTGLy0NNDAyPAcdnOAMMcaYBpq3EIeZURSEQQdGGYmOt7vu0HesF1W3oPH9iHHhLFy5MNGMC3duTNy5Mi50Ows3xn/BGBdujaequ6t43L51MyeyaKC+c373O+feqj48vvuTZH2PPHqbVip5L7AFt1h+5dLW1nrxNiuJZ5hf8rgrHI9UP5oyJLNNOoz4ui/Ihe3VMH20lj56xbFcx2b2oez5VdLuiwOT+WXGhCCPHM0o+f7oRizPV9zAq1NjUzLq3b//ynxufPBNhpCKC+4WoZThtKykkuZVkuGGID2w0h4dNam9AzY8bu+A31PhtSsm9f2r1GK75D3SukpaXOoBTJDz+iVHjCi/4grSNrKy5AFwTJCzjreTL5Udj1l5k1s0H/D8GuX2y5ztu26U0iJI+8jKGrODy9SDlL7QVCXv74PHfP16EttajYXA7hOBYUjn8cjx8Nvu8KXruFSIpZ5Y6qhKy4JZsEb/iTVCIQztk2VEaw02lAtqeUItT6rlKYlcq3NCXed0nHlBJs+o5Vm1PCeROw91bEyi12xPNt65qVgalVKTjRiX6gWJXkNPp6CTXZqR6pNyfYPBfUXhpoFTNXDkVMXK0UoPM5O97ZIyo3IvNs6flufH+kwKv5DCn5Xk19o5E7ezU5qanI9VmV4YS9HHU/RCij4h0WvWZ2Pr8tRkp7ek+pREr6Hn1F0pJBv2ulSfSdFnU/Q5id5We16Oqb1NJDtSlurjKXohRZ9I0SdT9CmJXq9tXFJbjwXKEjfZUmCa8NbGmB0T9uKovnrUVcezaOO4+koFyUrNPhcsznknvp6lRScQEqEOSx7gidbKx2ftm7e8OO2jY9Ihe4mUKzJBV+kB8wQ5J3lzvlyXry8n77k5C96yX6Q2M6FbR55d0cUwKhcHd5ccW8CYsEmLRWaEAYKcOZKUKGHKZy5MNGePTDQwK+WTWSkZZpq2SdYL4LIgg9snx6trIFUHq8Fjg1UIjNR/B3p/+/GPH5bq09QurN0vDT00DMKU43qOCy3j4dJd1VEqENwcXaPu/DbJ+cyESTKaFIckxjZqMpiD9aK5JR+m55+nfhkQ2dbff/p54I17D5DMEmk3HWos0TB+meRE2YMuOKZRcS8uRo4699vg9XToDeYTg92igSmumI7P1sEiFRzaT3oWuG1ymw1TAcNeMRDs6Qr0ZUjSl9hcMffLP70b3y/We9MEXh9qGJ70J/sqaamuFs2a4Z62NpgtO1yfBYaTjIuyAbIp/Nzu1o7fF9Hrl7LiT7EKHDSDGRuCCjgnDy4YVNDhIrcNOGdQcJj5dVRJ+NVdbXBLmfGdcnRDfnX/lByHO2HZojtR9d8iQHAE+Fu0aDKko6zgAg3pCKDlJQdOGjOQhWX34UeTMtJPs4BjoGCcTmWEl39VEHp1XISbrWhHP9oFnnAGTXgYTRhCE86hCcNownktwj3FeRhBe8ATHkMTHkcTnkATnkQT8mjCGPo8FNAe8IRJNGEa3YdZtAc84Sk0YQHdh0toD3oElYdn0R70CCoPz6E96BFUHl5Ae0gnwM96ls0sx+al/9XJmg6h6ZrCgxZB2c91dBV6BJWHl9Ae9AgqDxtoD3oElYfraA96BJWHV9Ae9AgqDzfQHvQIKg/baA96BJWH19Ae8ISb6GeUFkHZB4quQo+g8lBCe9AjqDwwtAc9gsrDDtoDnsDRZ1KLoOzDm+gq9AgqDxbagx5B5cFBe9AjqDzsoj3oEVQefLQHPYLKQ4D2gCfso+9NLYKyDwfoKtIJgnQIxzE3ubup/pWnDqp1j/u89itlTE3Vvt63kbS+vo3uqxYh04Um9GGrUHYS34d30XeJFkG5m++jq9AjqDx8iPagR1B5+BjtQYug3E09D6oqPtF5zDA7/MOV6i9F6Zi0ZugRVKV8qnWL38ASlFWkEwRpMelB7V8FGvi4A5T/AIBCFbDyKAAA";
    private static final Log log = LogFactory.getLog(MainView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuItem about;
    protected BetaLayerUI betaLayer;
    protected JTabbedPane contentTabbedPane;
    protected JMenuItem i18n_en;
    protected JMenuItem i18n_fr;
    protected JPanel mainPanel;
    protected JMenuItem menuFileFullscreen;
    protected JMenuItem menuFileNormalscreen;
    protected JMenuItem site;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MainView $JFrame0 = this;
    private JMenu $JMenu0;
    private JMenu $JMenu1;
    private JMenu $JMenu10;
    private JMenu $JMenu11;
    private JMenu $JMenu12;
    private JMenu $JMenu13;
    private JMenu $JMenu2;
    private JMenu $JMenu3;
    private JMenu $JMenu4;
    private JMenu $JMenu5;
    private JMenu $JMenu6;
    private JMenu $JMenu7;
    private JMenu $JMenu8;
    private JMenu $JMenu9;
    private JMenuBar $JMenuBar0;
    private JMenuItem $JMenuItem0;
    private JMenuItem $JMenuItem1;
    private JMenuItem $JMenuItem10;
    private JMenuItem $JMenuItem11;
    private JMenuItem $JMenuItem12;
    private JMenuItem $JMenuItem13;
    private JMenuItem $JMenuItem14;
    private JMenuItem $JMenuItem15;
    private JMenuItem $JMenuItem16;
    private JMenuItem $JMenuItem17;
    private JMenuItem $JMenuItem18;
    private JMenuItem $JMenuItem19;
    private JMenuItem $JMenuItem2;
    private JMenuItem $JMenuItem20;
    private JMenuItem $JMenuItem21;
    private JMenuItem $JMenuItem22;
    private JMenuItem $JMenuItem23;
    private JMenuItem $JMenuItem24;
    private JMenuItem $JMenuItem25;
    private JMenuItem $JMenuItem26;
    private JMenuItem $JMenuItem27;
    private JMenuItem $JMenuItem28;
    private JMenuItem $JMenuItem29;
    private JMenuItem $JMenuItem3;
    private JMenuItem $JMenuItem30;
    private JMenuItem $JMenuItem31;
    private JMenuItem $JMenuItem32;
    private JMenuItem $JMenuItem33;
    private JMenuItem $JMenuItem34;
    private JMenuItem $JMenuItem35;
    private JMenuItem $JMenuItem4;
    private JMenuItem $JMenuItem5;
    private JMenuItem $JMenuItem6;
    private JMenuItem $JMenuItem7;
    private JMenuItem $JMenuItem8;
    private JMenuItem $JMenuItem9;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JSeparator $JSeparator2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            SwingUtil.getLayer(mainPanel).setUI(betaLayer);
        }
    
        public LimaConfig getConfig() {
            return LimaContext.CONFIG_DEF.getContextValue(getDelegateContext());
        }
    
        public MainViewHandler getHandler() {
            return getContextValue(MainViewHandler.class);
        }
    
        public boolean acceptLocale(Locale l, String expected) {
          return l != null && l.toString().equals(expected);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainView() {
        $initialize();
    }

    public MainView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainView(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainView(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainView(String param0) {
        super(param0);
        $initialize();
    }

    public MainView(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainView(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainView(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JMenuItem0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ALL_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ACCOUNTCHARTS_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem10(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_VAT_EXPORT);
    }

    public void doActionPerformed__on__$JMenuItem11(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ACCOUNTCHARTS_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem12(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ENTRIES_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem13(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ACCOUNTCHARTS_EXPORT);
    }

    public void doActionPerformed__on__$JMenuItem14(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ENTRIES_EXPORT);
    }

    public void doActionPerformed__on__$JMenuItem15(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().loadURI(this);
    }

    public void doActionPerformed__on__$JMenuItem16(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showIdentity(this);
    }

    public void doActionPerformed__on__$JMenuItem17(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showConfig(this);
    }

    public void doActionPerformed__on__$JMenuItem18(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(this);
    }

    public void doActionPerformed__on__$JMenuItem19(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAccountView(this);
    }

    public void doActionPerformed__on__$JMenuItem2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ENTRYBOOKS_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem20(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showEntryBookView(this);
    }

    public void doActionPerformed__on__$JMenuItem21(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showFiscalPeriodView(this);
    }

    public void doActionPerformed__on__$JMenuItem22(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showFinancialPeriodView(this);
    }

    public void doActionPerformed__on__$JMenuItem23(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showFinancialStatementView(this);
    }

    public void doActionPerformed__on__$JMenuItem24(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showVatChartView(this);
    }

    public void doActionPerformed__on__$JMenuItem25(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.PDF_VAT_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem26(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showTransactionView(this);
    }

    public void doActionPerformed__on__$JMenuItem27(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showTransactionUnbalancedView(this);
    }

    public void doActionPerformed__on__$JMenuItem28(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showTransactionSearchView(this);
    }

    public void doActionPerformed__on__$JMenuItem29(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showLetteringView(this);
    }

    public void doActionPerformed__on__$JMenuItem3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem30(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAccountReports(this);
    }

    public void doActionPerformed__on__$JMenuItem31(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showEntryBookReports(this);
    }

    public void doActionPerformed__on__$JMenuItem32(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showBalanceView(this);
    }

    public void doActionPerformed__on__$JMenuItem33(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showLedgerView(this);
    }

    public void doActionPerformed__on__$JMenuItem34(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showFinancialStatementReportsView(this);
    }

    public void doActionPerformed__on__$JMenuItem35(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showVatReportView(this);
    }

    public void doActionPerformed__on__$JMenuItem4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_VAT_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ENTRIES_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ALL_EXPORT);
    }

    public void doActionPerformed__on__$JMenuItem7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ACCOUNTCHARTS_EXPORT);
    }

    public void doActionPerformed__on__$JMenuItem8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ENTRYBOOKS_EXPORT);
    }

    public void doActionPerformed__on__$JMenuItem9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportExportView(this, ImportExportEnum.CSV_FINANCIALSTATEMENTS_EXPORT);
    }

    public void doActionPerformed__on__about(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAbout(this);
    }

    public void doActionPerformed__on__i18n_en(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__i18n_fr(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileFullscreen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileNormalscreen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeScreen(this, false);
    }

    public void doActionPerformed__on__site(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().gotoSite(this);
    }

    public void doStateChanged__on__contentTabbedPane(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().swingSession.save();
    }

    public void doWindowClosing__on__$JFrame0(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenuItem getAbout() {
        return about;
    }

    public BetaLayerUI getBetaLayer() {
        return betaLayer;
    }

    public JTabbedPane getContentTabbedPane() {
        return contentTabbedPane;
    }

    public JMenuItem getI18n_en() {
        return i18n_en;
    }

    public JMenuItem getI18n_fr() {
        return i18n_fr;
    }

    public JPanel getMainPanel() {
        return mainPanel;
    }

    public JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public JMenuItem getSite() {
        return site;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JMenu get$JMenu1() {
        return $JMenu1;
    }

    protected JMenu get$JMenu10() {
        return $JMenu10;
    }

    protected JMenu get$JMenu11() {
        return $JMenu11;
    }

    protected JMenu get$JMenu12() {
        return $JMenu12;
    }

    protected JMenu get$JMenu13() {
        return $JMenu13;
    }

    protected JMenu get$JMenu2() {
        return $JMenu2;
    }

    protected JMenu get$JMenu3() {
        return $JMenu3;
    }

    protected JMenu get$JMenu4() {
        return $JMenu4;
    }

    protected JMenu get$JMenu5() {
        return $JMenu5;
    }

    protected JMenu get$JMenu6() {
        return $JMenu6;
    }

    protected JMenu get$JMenu7() {
        return $JMenu7;
    }

    protected JMenu get$JMenu8() {
        return $JMenu8;
    }

    protected JMenu get$JMenu9() {
        return $JMenu9;
    }

    protected JMenuBar get$JMenuBar0() {
        return $JMenuBar0;
    }

    protected JMenuItem get$JMenuItem0() {
        return $JMenuItem0;
    }

    protected JMenuItem get$JMenuItem1() {
        return $JMenuItem1;
    }

    protected JMenuItem get$JMenuItem10() {
        return $JMenuItem10;
    }

    protected JMenuItem get$JMenuItem11() {
        return $JMenuItem11;
    }

    protected JMenuItem get$JMenuItem12() {
        return $JMenuItem12;
    }

    protected JMenuItem get$JMenuItem13() {
        return $JMenuItem13;
    }

    protected JMenuItem get$JMenuItem14() {
        return $JMenuItem14;
    }

    protected JMenuItem get$JMenuItem15() {
        return $JMenuItem15;
    }

    protected JMenuItem get$JMenuItem16() {
        return $JMenuItem16;
    }

    protected JMenuItem get$JMenuItem17() {
        return $JMenuItem17;
    }

    protected JMenuItem get$JMenuItem18() {
        return $JMenuItem18;
    }

    protected JMenuItem get$JMenuItem19() {
        return $JMenuItem19;
    }

    protected JMenuItem get$JMenuItem2() {
        return $JMenuItem2;
    }

    protected JMenuItem get$JMenuItem20() {
        return $JMenuItem20;
    }

    protected JMenuItem get$JMenuItem21() {
        return $JMenuItem21;
    }

    protected JMenuItem get$JMenuItem22() {
        return $JMenuItem22;
    }

    protected JMenuItem get$JMenuItem23() {
        return $JMenuItem23;
    }

    protected JMenuItem get$JMenuItem24() {
        return $JMenuItem24;
    }

    protected JMenuItem get$JMenuItem25() {
        return $JMenuItem25;
    }

    protected JMenuItem get$JMenuItem26() {
        return $JMenuItem26;
    }

    protected JMenuItem get$JMenuItem27() {
        return $JMenuItem27;
    }

    protected JMenuItem get$JMenuItem28() {
        return $JMenuItem28;
    }

    protected JMenuItem get$JMenuItem29() {
        return $JMenuItem29;
    }

    protected JMenuItem get$JMenuItem3() {
        return $JMenuItem3;
    }

    protected JMenuItem get$JMenuItem30() {
        return $JMenuItem30;
    }

    protected JMenuItem get$JMenuItem31() {
        return $JMenuItem31;
    }

    protected JMenuItem get$JMenuItem32() {
        return $JMenuItem32;
    }

    protected JMenuItem get$JMenuItem33() {
        return $JMenuItem33;
    }

    protected JMenuItem get$JMenuItem34() {
        return $JMenuItem34;
    }

    protected JMenuItem get$JMenuItem35() {
        return $JMenuItem35;
    }

    protected JMenuItem get$JMenuItem4() {
        return $JMenuItem4;
    }

    protected JMenuItem get$JMenuItem5() {
        return $JMenuItem5;
    }

    protected JMenuItem get$JMenuItem6() {
        return $JMenuItem6;
    }

    protected JMenuItem get$JMenuItem7() {
        return $JMenuItem7;
    }

    protected JMenuItem get$JMenuItem8() {
        return $JMenuItem8;
    }

    protected JMenuItem get$JMenuItem9() {
        return $JMenuItem9;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(contentTabbedPane, BorderLayout.CENTER);
    }

    protected void createAbout() {
        $objectMap.put("about", about = new JMenuItem());
        
        about.setName("about");
        about.setText(_("lima.menu.help.about"));
        about.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__about"));
    }

    protected void createBetaLayer() {
        $objectMap.put("betaLayer", betaLayer = new BetaLayerUI());
    }

    protected void createContentTabbedPane() {
        $objectMap.put("contentTabbedPane", contentTabbedPane = new JTabbedPane());
        
        contentTabbedPane.setName("contentTabbedPane");
        contentTabbedPane.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__contentTabbedPane"));
    }

    protected void createI18n_en() {
        $objectMap.put("i18n_en", i18n_en = new JMenuItem());
        
        i18n_en.setName("i18n_en");
        i18n_en.setText(_("lima.menu.help.i18n.uk"));
        i18n_en.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__i18n_en"));
    }

    protected void createI18n_fr() {
        $objectMap.put("i18n_fr", i18n_fr = new JMenuItem());
        
        i18n_fr.setName("i18n_fr");
        i18n_fr.setText(_("lima.menu.help.i18n.fr"));
        i18n_fr.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__i18n_fr"));
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new JPanel());
        
        mainPanel.setName("mainPanel");
        mainPanel.setLayout(new BorderLayout());
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new JMenuItem());
        
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(_("lima.action.fullscreen"));
        menuFileFullscreen.setToolTipText(_("lima.action.fullscreen.tip"));
        menuFileFullscreen.setMnemonic(80);
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new JMenuItem());
        
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(_("lima.action.normalscreen"));
        menuFileNormalscreen.setToolTipText(_("lima.action.normalscreen.tip"));
        menuFileNormalscreen.setMnemonic(78);
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
    }

    protected void createSite() {
        $objectMap.put("site", site = new JMenuItem());
        
        site.setName("site");
        site.setText(_("lima.menu.help.site"));
        site.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__site"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JFrame0
        add(SwingUtil.boxComponentWithJxLayer(mainPanel));
        $JFrame0.setJMenuBar($JMenuBar0);
        // inline complete setup of $JMenuBar0
        $JMenuBar0.add($JMenu0);
        $JMenuBar0.add($JMenu7);
        $JMenuBar0.add($JMenu9);
        $JMenuBar0.add($JMenu10);
        $JMenuBar0.add($JMenu11);
        $JMenuBar0.add($JMenu12);
        // inline complete setup of $JMenu0
        $JMenu0.add($JMenu1);
        $JMenu0.add($JMenu4);
        $JMenu0.add($JSeparator0);
        $JMenu0.add($JMenuItem15);
        $JMenu0.add($JSeparator1);
        $JMenu0.add($JMenuItem16);
        $JMenu0.add($JMenuItem17);
        $JMenu0.add($JSeparator2);
        $JMenu0.add($JMenuItem18);
        // inline complete setup of $JMenu1
        $JMenu1.add($JMenu2);
        $JMenu1.add($JMenu3);
        // inline complete setup of $JMenu2
        $JMenu2.add($JMenuItem0);
        $JMenu2.add($JMenuItem1);
        $JMenu2.add($JMenuItem2);
        $JMenu2.add($JMenuItem3);
        $JMenu2.add($JMenuItem4);
        $JMenu2.add($JMenuItem5);
        // inline complete setup of $JMenu3
        $JMenu3.add($JMenuItem6);
        $JMenu3.add($JMenuItem7);
        $JMenu3.add($JMenuItem8);
        $JMenu3.add($JMenuItem9);
        $JMenu3.add($JMenuItem10);
        // inline complete setup of $JMenu4
        $JMenu4.add($JMenu5);
        $JMenu4.add($JMenu6);
        // inline complete setup of $JMenu5
        $JMenu5.add($JMenuItem11);
        $JMenu5.add($JMenuItem12);
        // inline complete setup of $JMenu6
        $JMenu6.add($JMenuItem13);
        $JMenu6.add($JMenuItem14);
        // inline complete setup of $JMenu7
        $JMenu7.add($JMenuItem19);
        $JMenu7.add($JMenuItem20);
        $JMenu7.add($JMenuItem21);
        $JMenu7.add($JMenuItem22);
        $JMenu7.add($JMenuItem23);
        $JMenu7.add($JMenu8);
        // inline complete setup of $JMenu8
        $JMenu8.add($JMenuItem24);
        $JMenu8.add($JMenuItem25);
        // inline complete setup of $JMenu9
        $JMenu9.add($JMenuItem26);
        $JMenu9.add($JMenuItem27);
        $JMenu9.add($JMenuItem28);
        $JMenu9.add($JMenuItem29);
        // inline complete setup of $JMenu10
        $JMenu10.add($JMenuItem30);
        $JMenu10.add($JMenuItem31);
        $JMenu10.add($JMenuItem32);
        $JMenu10.add($JMenuItem33);
        $JMenu10.add($JMenuItem34);
        $JMenu10.add($JMenuItem35);
        // inline complete setup of $JMenu11
        $JMenu11.add(menuFileFullscreen);
        $JMenu11.add(menuFileNormalscreen);
        // inline complete setup of $JMenu12
        $JMenu12.add(site);
        $JMenu12.add(about);
        $JMenu12.add($JMenu13);
        // inline complete setup of $JMenu13
        $JMenu13.add(i18n_fr);
        $JMenu13.add(i18n_en);
        addChildrenToMainPanel();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 43 property setters
        setExtendedState(this.MAXIMIZED_BOTH);
        setIconImage(SwingUtil.createImageIcon("puzzle_icon.png").getImage());
        $JMenu2.setIcon(SwingUtil.createActionIcon("import-element"));
        $JMenu3.setIcon(SwingUtil.createActionIcon("export-element"));
        $JMenu5.setIcon(SwingUtil.createActionIcon("import-element"));
        $JMenu6.setIcon(SwingUtil.createActionIcon("export-element"));
        $JMenuItem15.setIcon(SwingUtil.createActionIcon("documents"));
        $JMenuItem16.setIcon(SwingUtil.createActionIcon("identity"));
        $JMenuItem17.setIcon(SwingUtil.createActionIcon("config"));
        $JMenuItem18.setIcon(SwingUtil.createActionIcon("quit"));
        $JMenuItem18.setMnemonic('Q');
        $JMenu7.setMnemonic('S');
        $JMenuItem19.setIcon(SwingUtil.createActionIcon("charts-accounts"));
        $JMenuItem20.setIcon(SwingUtil.createActionIcon("charts-entrybooks"));
        $JMenuItem21.setIcon(SwingUtil.createActionIcon("charts-fiscalperiod"));
        $JMenuItem22.setIcon(SwingUtil.createActionIcon("charts-financialperiod"));
        $JMenuItem23.setIcon(SwingUtil.createActionIcon("charts-financialstatements"));
        $JMenu8.setIcon(SwingUtil.createActionIcon("charts-vatstatements"));
        $JMenuItem24.setIcon(SwingUtil.createActionIcon("charts-vatstatements"));
        $JMenuItem25.setIcon(SwingUtil.createActionIcon("charts-vatstatements"));
        $JMenu9.setMnemonic('E');
        $JMenuItem26.setIcon(SwingUtil.createActionIcon("entries-balanced"));
        $JMenuItem27.setIcon(SwingUtil.createActionIcon("entries-unbalanced"));
        $JMenuItem28.setIcon(SwingUtil.createActionIcon("entries-search"));
        $JMenuItem29.setIcon(SwingUtil.createActionIcon("lettering"));
        $JMenu10.setMnemonic('R');
        $JMenuItem30.setIcon(SwingUtil.createActionIcon("reports-account"));
        $JMenuItem31.setIcon(SwingUtil.createActionIcon("reports-entrybook"));
        $JMenuItem32.setIcon(SwingUtil.createActionIcon("reports-balance"));
        $JMenuItem33.setIcon(SwingUtil.createActionIcon("reports-ledger"));
        $JMenuItem34.setIcon(SwingUtil.createActionIcon("reports-financialstatement"));
        $JMenuItem35.setIcon(SwingUtil.createActionIcon("reports-vatstatement"));
        $JMenu11.setMnemonic('W');
        menuFileFullscreen.setIcon(SwingUtil.createActionIcon("fullscreen"));
        menuFileNormalscreen.setIcon(SwingUtil.createActionIcon("leave-fullscreen"));
        $JMenu12.setMnemonic('H');
        site.setIcon(SwingUtil.createActionIcon("site"));
        about.setIcon(SwingUtil.createActionIcon("about"));
        $JMenu13.setIcon(SwingUtil.createActionIcon("translate"));
        $JMenu13.setMnemonic('L');
        i18n_fr.setIcon(SwingUtil.createActionIcon("i18n-fr"));
        i18n_en.setIcon(SwingUtil.createActionIcon("i18n-uk"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JFrame0", $JFrame0);
        // inline creation of $JMenuBar0
        $objectMap.put("$JMenuBar0", $JMenuBar0 = new JMenuBar());
        
        $JMenuBar0.setName("$JMenuBar0");
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(_("lima.menu.file"));
        // inline creation of $JMenu1
        $objectMap.put("$JMenu1", $JMenu1 = new JMenu());
        
        $JMenu1.setName("$JMenu1");
        $JMenu1.setText(_("lima.ui.importexport.csv"));
        // inline creation of $JMenu2
        $objectMap.put("$JMenu2", $JMenu2 = new JMenu());
        
        $JMenu2.setName("$JMenu2");
        $JMenu2.setText(_("lima.ui.importexport.import"));
        // inline creation of $JMenuItem0
        $objectMap.put("$JMenuItem0", $JMenuItem0 = new JMenuItem());
        
        $JMenuItem0.setName("$JMenuItem0");
        $JMenuItem0.setText(_("lima.ui.importexport.all"));
        $JMenuItem0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem0"));
        // inline creation of $JMenuItem1
        $objectMap.put("$JMenuItem1", $JMenuItem1 = new JMenuItem());
        
        $JMenuItem1.setName("$JMenuItem1");
        $JMenuItem1.setText(_("lima.ui.importexport.accountcharts"));
        $JMenuItem1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem1"));
        // inline creation of $JMenuItem2
        $objectMap.put("$JMenuItem2", $JMenuItem2 = new JMenuItem());
        
        $JMenuItem2.setName("$JMenuItem2");
        $JMenuItem2.setText(_("lima.ui.importexport.entrybooks"));
        $JMenuItem2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem2"));
        // inline creation of $JMenuItem3
        $objectMap.put("$JMenuItem3", $JMenuItem3 = new JMenuItem());
        
        $JMenuItem3.setName("$JMenuItem3");
        $JMenuItem3.setText(_("lima.ui.importexport.financialstatements"));
        $JMenuItem3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem3"));
        // inline creation of $JMenuItem4
        $objectMap.put("$JMenuItem4", $JMenuItem4 = new JMenuItem());
        
        $JMenuItem4.setName("$JMenuItem4");
        $JMenuItem4.setText(_("lima.ui.importexport.vatstatements"));
        $JMenuItem4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem4"));
        // inline creation of $JMenuItem5
        $objectMap.put("$JMenuItem5", $JMenuItem5 = new JMenuItem());
        
        $JMenuItem5.setName("$JMenuItem5");
        $JMenuItem5.setText(_("lima.ui.importexport.financialtransactions"));
        $JMenuItem5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem5"));
        // inline creation of $JMenu3
        $objectMap.put("$JMenu3", $JMenu3 = new JMenu());
        
        $JMenu3.setName("$JMenu3");
        $JMenu3.setText(_("lima.ui.importexport.export"));
        // inline creation of $JMenuItem6
        $objectMap.put("$JMenuItem6", $JMenuItem6 = new JMenuItem());
        
        $JMenuItem6.setName("$JMenuItem6");
        $JMenuItem6.setText(_("lima.ui.importexport.all"));
        $JMenuItem6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem6"));
        // inline creation of $JMenuItem7
        $objectMap.put("$JMenuItem7", $JMenuItem7 = new JMenuItem());
        
        $JMenuItem7.setName("$JMenuItem7");
        $JMenuItem7.setText(_("lima.ui.importexport.accountcharts"));
        $JMenuItem7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem7"));
        // inline creation of $JMenuItem8
        $objectMap.put("$JMenuItem8", $JMenuItem8 = new JMenuItem());
        
        $JMenuItem8.setName("$JMenuItem8");
        $JMenuItem8.setText(_("lima.ui.importexport.entrybooks"));
        $JMenuItem8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem8"));
        // inline creation of $JMenuItem9
        $objectMap.put("$JMenuItem9", $JMenuItem9 = new JMenuItem());
        
        $JMenuItem9.setName("$JMenuItem9");
        $JMenuItem9.setText(_("lima.ui.importexport.financialstatements"));
        $JMenuItem9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem9"));
        // inline creation of $JMenuItem10
        $objectMap.put("$JMenuItem10", $JMenuItem10 = new JMenuItem());
        
        $JMenuItem10.setName("$JMenuItem10");
        $JMenuItem10.setText(_("lima.ui.importexport.vatstatements"));
        $JMenuItem10.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem10"));
        // inline creation of $JMenu4
        $objectMap.put("$JMenu4", $JMenu4 = new JMenu());
        
        $JMenu4.setName("$JMenu4");
        $JMenu4.setText(_("lima.ui.importexport.ebp"));
        // inline creation of $JMenu5
        $objectMap.put("$JMenu5", $JMenu5 = new JMenu());
        
        $JMenu5.setName("$JMenu5");
        $JMenu5.setText(_("lima.ui.importexport.import"));
        // inline creation of $JMenuItem11
        $objectMap.put("$JMenuItem11", $JMenuItem11 = new JMenuItem());
        
        $JMenuItem11.setName("$JMenuItem11");
        $JMenuItem11.setText(_("lima.ui.importexport.accountcharts"));
        $JMenuItem11.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem11"));
        // inline creation of $JMenuItem12
        $objectMap.put("$JMenuItem12", $JMenuItem12 = new JMenuItem());
        
        $JMenuItem12.setName("$JMenuItem12");
        $JMenuItem12.setText(_("lima.ui.importexport.entries"));
        $JMenuItem12.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem12"));
        // inline creation of $JMenu6
        $objectMap.put("$JMenu6", $JMenu6 = new JMenu());
        
        $JMenu6.setName("$JMenu6");
        $JMenu6.setText(_("lima.ui.importexport.export"));
        // inline creation of $JMenuItem13
        $objectMap.put("$JMenuItem13", $JMenuItem13 = new JMenuItem());
        
        $JMenuItem13.setName("$JMenuItem13");
        $JMenuItem13.setText(_("lima.ui.importexport.accountcharts"));
        $JMenuItem13.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem13"));
        // inline creation of $JMenuItem14
        $objectMap.put("$JMenuItem14", $JMenuItem14 = new JMenuItem());
        
        $JMenuItem14.setName("$JMenuItem14");
        $JMenuItem14.setText(_("lima.ui.importexport.entries"));
        $JMenuItem14.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem14"));
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JMenuItem15
        $objectMap.put("$JMenuItem15", $JMenuItem15 = new JMenuItem());
        
        $JMenuItem15.setName("$JMenuItem15");
        $JMenuItem15.setText(_("lima.documents"));
        $JMenuItem15.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem15"));
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        // inline creation of $JMenuItem16
        $objectMap.put("$JMenuItem16", $JMenuItem16 = new JMenuItem());
        
        $JMenuItem16.setName("$JMenuItem16");
        $JMenuItem16.setText(_("lima.identity"));
        $JMenuItem16.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem16"));
        // inline creation of $JMenuItem17
        $objectMap.put("$JMenuItem17", $JMenuItem17 = new JMenuItem());
        
        $JMenuItem17.setName("$JMenuItem17");
        $JMenuItem17.setText(_("lima.preferences"));
        $JMenuItem17.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem17"));
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        // inline creation of $JMenuItem18
        $objectMap.put("$JMenuItem18", $JMenuItem18 = new JMenuItem());
        
        $JMenuItem18.setName("$JMenuItem18");
        $JMenuItem18.setText(_("lima.common.quit"));
        $JMenuItem18.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem18"));
        // inline creation of $JMenu7
        $objectMap.put("$JMenu7", $JMenu7 = new JMenu());
        
        $JMenu7.setName("$JMenu7");
        $JMenu7.setText(_("lima.structure"));
        // inline creation of $JMenuItem19
        $objectMap.put("$JMenuItem19", $JMenuItem19 = new JMenuItem());
        
        $JMenuItem19.setName("$JMenuItem19");
        $JMenuItem19.setText(_("lima.charts.account"));
        $JMenuItem19.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem19"));
        // inline creation of $JMenuItem20
        $objectMap.put("$JMenuItem20", $JMenuItem20 = new JMenuItem());
        
        $JMenuItem20.setName("$JMenuItem20");
        $JMenuItem20.setText(_("lima.common.entrybooks"));
        $JMenuItem20.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem20"));
        // inline creation of $JMenuItem21
        $objectMap.put("$JMenuItem21", $JMenuItem21 = new JMenuItem());
        
        $JMenuItem21.setName("$JMenuItem21");
        $JMenuItem21.setText(_("lima.charts.fiscalyear"));
        $JMenuItem21.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem21"));
        // inline creation of $JMenuItem22
        $objectMap.put("$JMenuItem22", $JMenuItem22 = new JMenuItem());
        
        $JMenuItem22.setName("$JMenuItem22");
        $JMenuItem22.setText(_("lima.charts.financialperiod"));
        $JMenuItem22.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem22"));
        // inline creation of $JMenuItem23
        $objectMap.put("$JMenuItem23", $JMenuItem23 = new JMenuItem());
        
        $JMenuItem23.setName("$JMenuItem23");
        $JMenuItem23.setText(_("lima.charts.financialstatement"));
        $JMenuItem23.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem23"));
        // inline creation of $JMenu8
        $objectMap.put("$JMenu8", $JMenu8 = new JMenu());
        
        $JMenu8.setName("$JMenu8");
        $JMenu8.setText(_("lima.charts.vatstatement"));
        // inline creation of $JMenuItem24
        $objectMap.put("$JMenuItem24", $JMenuItem24 = new JMenuItem());
        
        $JMenuItem24.setName("$JMenuItem24");
        $JMenuItem24.setText(_("lima.charts.vatstatement"));
        $JMenuItem24.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem24"));
        // inline creation of $JMenuItem25
        $objectMap.put("$JMenuItem25", $JMenuItem25 = new JMenuItem());
        
        $JMenuItem25.setName("$JMenuItem25");
        $JMenuItem25.setText(_("lima.charts.vatpdf"));
        $JMenuItem25.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem25"));
        // inline creation of $JMenu9
        $objectMap.put("$JMenu9", $JMenu9 = new JMenu());
        
        $JMenu9.setName("$JMenu9");
        $JMenu9.setText(_("lima.entries"));
        // inline creation of $JMenuItem26
        $objectMap.put("$JMenuItem26", $JMenuItem26 = new JMenuItem());
        
        $JMenuItem26.setName("$JMenuItem26");
        $JMenuItem26.setText(_("lima.entries.writetransaction"));
        $JMenuItem26.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem26"));
        // inline creation of $JMenuItem27
        $objectMap.put("$JMenuItem27", $JMenuItem27 = new JMenuItem());
        
        $JMenuItem27.setName("$JMenuItem27");
        $JMenuItem27.setText(_("lima.entries.searchunbalancedtransaction"));
        $JMenuItem27.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem27"));
        // inline creation of $JMenuItem28
        $objectMap.put("$JMenuItem28", $JMenuItem28 = new JMenuItem());
        
        $JMenuItem28.setName("$JMenuItem28");
        $JMenuItem28.setText(_("lima.entries.searchtransaction"));
        $JMenuItem28.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem28"));
        // inline creation of $JMenuItem29
        $objectMap.put("$JMenuItem29", $JMenuItem29 = new JMenuItem());
        
        $JMenuItem29.setName("$JMenuItem29");
        $JMenuItem29.setText(_("lima.entries.lettering"));
        $JMenuItem29.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem29"));
        // inline creation of $JMenu10
        $objectMap.put("$JMenu10", $JMenu10 = new JMenu());
        
        $JMenu10.setName("$JMenu10");
        $JMenu10.setText(_("lima.reports"));
        // inline creation of $JMenuItem30
        $objectMap.put("$JMenuItem30", $JMenuItem30 = new JMenuItem());
        
        $JMenuItem30.setName("$JMenuItem30");
        $JMenuItem30.setText(_("lima.reports.accounts"));
        $JMenuItem30.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem30"));
        // inline creation of $JMenuItem31
        $objectMap.put("$JMenuItem31", $JMenuItem31 = new JMenuItem());
        
        $JMenuItem31.setName("$JMenuItem31");
        $JMenuItem31.setText(_("lima.reports.entrybooks"));
        $JMenuItem31.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem31"));
        // inline creation of $JMenuItem32
        $objectMap.put("$JMenuItem32", $JMenuItem32 = new JMenuItem());
        
        $JMenuItem32.setName("$JMenuItem32");
        $JMenuItem32.setText(_("lima.reports.balance"));
        $JMenuItem32.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem32"));
        // inline creation of $JMenuItem33
        $objectMap.put("$JMenuItem33", $JMenuItem33 = new JMenuItem());
        
        $JMenuItem33.setName("$JMenuItem33");
        $JMenuItem33.setText(_("lima.reports.ledger"));
        $JMenuItem33.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem33"));
        // inline creation of $JMenuItem34
        $objectMap.put("$JMenuItem34", $JMenuItem34 = new JMenuItem());
        
        $JMenuItem34.setName("$JMenuItem34");
        $JMenuItem34.setText(_("lima.reports.financialstatement"));
        $JMenuItem34.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem34"));
        // inline creation of $JMenuItem35
        $objectMap.put("$JMenuItem35", $JMenuItem35 = new JMenuItem());
        
        $JMenuItem35.setName("$JMenuItem35");
        $JMenuItem35.setText(_("lima.reports.vat"));
        $JMenuItem35.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem35"));
        // inline creation of $JMenu11
        $objectMap.put("$JMenu11", $JMenu11 = new JMenu());
        
        $JMenu11.setName("$JMenu11");
        $JMenu11.setText(_("lima.menu.window"));
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JMenu12
        $objectMap.put("$JMenu12", $JMenu12 = new JMenu());
        
        $JMenu12.setName("$JMenu12");
        $JMenu12.setText(_("lima.menu.help"));
        createSite();
        createAbout();
        // inline creation of $JMenu13
        $objectMap.put("$JMenu13", $JMenu13 = new JMenu());
        
        $JMenu13.setName("$JMenu13");
        $JMenu13.setText(_("lima.menu.help.i18n"));
        createI18n_fr();
        createI18n_en();
        createBetaLayer();
        createMainPanel();
        createContentTabbedPane();
        // inline creation of $JFrame0
        setName("$JFrame0");
        setDefaultCloseOperation(0);
        SwingUtil.setComponentHeight($JFrame0,600);
        setResizable(true);
        setTitle(_("lima.ui.mainview.title"));
        SwingUtil.setComponentWidth($JFrame0,800);
        $JFrame0.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__$JFrame0"));
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JFRAME0_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_I18N_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    i18n_fr.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_I18N_EN_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    i18n_en.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
    }

}