package org.chorem.lima.ui.Filter.dateIntervalCondition;

/*
 * #%L
 * Lima :: Swing
 * $Id: DateIntervalConditionHandler.java 3695 2013-07-10 09:11:39Z athimel $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.7/lima-swing/src/main/java/org/chorem/lima/ui/Filter/dateIntervalCondition/DateIntervalConditionHandler.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.Condition;
import org.chorem.lima.beans.DateIntervalCondition;
import org.chorem.lima.ui.Filter.ConditionHandler;
import org.chorem.lima.ui.Filter.financialTransactionCondition.FinancialTransactionConditionHandler;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchViewHandler;

import javax.swing.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class DateIntervalConditionHandler implements ConditionHandler {

    /** log. */
    private static final Log log =
            LogFactory.getLog(FinancialTransactionSearchViewHandler.class);

    protected DateIntervalConditionView view;

    protected DateIntervalCondition condition;

    protected FinancialTransactionConditionHandler filterHandler;

    public DateIntervalConditionHandler(DateIntervalConditionView view) {
        this.view = view;
        this.condition = new DateIntervalCondition();
    }

    @Override
    public Condition getCondition() {
        return condition;
    }

    @Override
    public JComponent getView() {
        return view;
    }

    @Override
    public void setFilterHandler(FinancialTransactionConditionHandler filterHandler) {
        this.filterHandler = filterHandler;
    }

    public DateFormat[] getFormats() {
        DateFormat[] formats = {DateFormat.getDateInstance(DateFormat.SHORT), new SimpleDateFormat("dd/MM/yyyy")};
        return formats;
    }

    public void delete() {
        filterHandler.removeCondition(this);
    }

    public Date getBeginDate() {
        return condition.getBeginDate();
    }

    public void setBeginDate(Date beginDate) {
        condition.setBeginDate(beginDate);
    }

    public Date getEndDate() {
        return condition.getEndDate();
    }

    public void setEndDate(Date endDate) {
        condition.setEndDate(endDate);
    }
}
