package org.chorem.lima.ui.Filter.EntryBookCondition;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.ui.LimaRendererUtil;
import static org.nuiton.i18n.I18n._;

public class EntryBookConditionView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Uz08TQRTHp5UWClSQBoSISdUmGg9b7xBFig02RQ0lhtiL092xHZydGWdm6eLB+Cf4J+jdi4k3T8aDZw9ejP+CMR68Gt9sf1FcsQn20DZv3vvM9739vn39DaW0Qhf2cBg6KuCG+sSp3NzdvdvYI67ZINpVVBqhUOeTSKJkHU15/bg26FK9asuL3fJiSfhScMIPVa9U0aQ2B4zoFiHGoPPDFa7WxVr/eCWUgepR+6LiqC9/fE++8J6/SiIUSlCXhlby/6oadDJWRUnqGTQHN+3jIsO8CTIU5U3Qm7WxEsNa38E+eYKeofEqSkusAGbQxdFbjhhRfSgNGi/s4AYj1wwqCdV03JZQxHcY9bETUKdMmSHKucWNOlgX4nFJcI8aKnhM6D4lbSkjchq4Lcw9RpRB5RNyNzugATpTqKwHxggOonN2KqGj2zAkpxu2aZl+9kShUsUNwiB5big5ig7nZguVmqsEY/cwtyM5O1QwODpSRXqaq1TDszgzfA3EbOK8BDOcGzID2MwZ2Gzgg0QdpVQAYYMW6386cxuOOp5cPOJJC4xOfy3kPr/7+rbcM2IG7p6PTT20R2AQqYSEZ0bt1TMdFwaGsuIWlit1oBAGSxgt2XKMsFr3GMTBfdEYHFvubGLdAkRq/Mv7DwsPP51CyTKaZAJ7ZWzzb6OMaSmYgmBeKG+sRYqm2xPwPWu1GTRGXcENOr3qYYPzDQrW4M3rIYxgOWYEfR2NzMefudqbtd4YEiBr6a/pg1GkHqA05YxyEm1kd9liN3BKahJ4YrBUcWuWsL+zsmvhfPRdiOtzygjBdqjcISEYaW61IyKPDbwFGoEh0LKtvRL1Yv9dHRk9ZoBpT4vxjNwo8nzKqR/4Nfo06v9yPGphBFRWKvKIKEW8/wCbdglj24R7RBF1DGtpBNYEg4XdAJudkJPtLAu8wLaEd1yDo8Bm9qmm8JreFu2SAOse8xwt7jfyBDCXRgcAAA==";
    private static final Log log = LogFactory.getLog(EntryBookConditionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JList entryBookList;
    protected EntryBookConditionHandler handler;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private EntryBookConditionView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EntryBookConditionView() {
        $initialize();
    }

    public EntryBookConditionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.delete();
    }

    public void doValueChanged__on__entryBookList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setEntryBook(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JList getEntryBookList() {
        return entryBookList;
    }

    public EntryBookConditionHandler getHandler() {
        return handler;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(EntryBookConditionHandler handler) {
        EntryBookConditionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createEntryBookList() {
        $objectMap.put("entryBookList", entryBookList = new JList());
        
        entryBookList.setName("entryBookList");
        entryBookList.setVisibleRowCount(-1);
        entryBookList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__entryBookList"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new EntryBookConditionHandler(this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(entryBookList);
        
        // apply 6 property setters
        $JButton0.setIcon(SwingUtil.createActionIcon("remove-condition"));
        $JScrollPane0.setMinimumSize(new Dimension(300, 60));
        $JScrollPane0.setPreferredSize(new Dimension(300, 60));
        entryBookList.setCellRenderer(LimaRendererUtil.newDecoratorListCellRenderer(EntryBook.class));
        entryBookList.setListData(handler.getEntryBookList());
        entryBookList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("lima.filter.condition.delete"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.enum.list.entryBook"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createEntryBookList();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}