package org.chorem.lima.ui.Filter.BigDecimalCondition;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListSelectionModel;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.AbstractBigDecimalCondition;
import org.chorem.lima.ui.common.LabelListCellRenderer;
import static org.nuiton.i18n.I18n._;

public class BigDecimalConditionView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVO28TQRDH1ya24zxIiJUoEUEyEAGiONOiRBDysJLIhAhbKMINe76RvdF5d9nbw5cG8RH4CNDTINFRIQpqChrEV0CIghYxe+dHDEdi6Vz4MTvz2//MzYzffCcZT5HLRzQILOVzzdpg7d07PHxgH0FDb4HXUExqoUj0SqVJuk4mnb7d0+RqvWLCS93w0qZoS8GBn4herZAJTx+74LUAtCaXhiManleq9o9XA+mrHrUvKo766ueP9Evnxes0IYFEdVlMpXhW1CCTsQpJM0eTObzpGS25lDdRhmK8iXqnjW3TpZ63T9vwlDwnuQrJSqoQpsmV0VMOGWF8IDXJrdSo7cItTbaFalqNllDQtlzWppbPrDJzNShrgzW3oIE2d1Nwh2kmeJztEYOOlCE7i+QW5Y4LSpOdxOSdCDWA51f2NnytBUfhBVOZwPI6WCirazZu+b53xqU2uFjYIc+KMQ47zggJCu/C+tliQwSazA+F9OzDUbN2XzGgXoEpXxt66lF0dGbt+20b1Hb4o8tR5OKQP/afNei/QYOk6iSjfDRrslj/t2Uf4lHUrIt/NasBhqe/Fwpf3n97V+516CzePR/remLAsHOkMpXRzFw9E7Wnr5lbuk/lap3kPXBxOsPpW44RVu0eozi874IJt0y4tUO9FiIyua8fPi48+XyOpMtkwhXUKVPjv0vyuqWwCsJ1Anl3PVQ01Rk3wo02TcZYQ3BNzq85VNOizbBfePNOgCVYjilBX4ed//SrUH273itDCmUt/dd9UIrMY5Jl3GUcwlHtTmHsaE5KD3xHDKYtbv5S5nNWdvu6GL6vxOU5qYVwa0zWIMBpn1uLRBSpxvVg+xowZRN7I8zFfLs5MnpMI9OcluIZhREYmbZwolm6Hg9ZGAEyjqvMAQUqIWcq6kZwdjW0E7Ly1NfiQEhfnlKhpVGqbAPlp4g5m2HMtxMRMJ3wOdWOJSQETfNwix1gA4LiCWsz3t0uxwk5M7goOuHDGvwJJMDlDe4heHDadIyUn+9BGbdaUk4OOVXWPCuvP7N4B7hECQAA";
    private static final Log log = LogFactory.getLog(BigDecimalConditionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected NumberEditor bigDecimaleditor;
    protected BigDecimalConditionHandler handler;
    protected JLabel label;
    protected JComboBox operandComboBox;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private BigDecimalConditionView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BigDecimalConditionView() {
        $initialize();
    }

    public BigDecimalConditionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.delete();
    }

    public void doItemStateChanged__on__operandComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.operandSelected(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor getBigDecimaleditor() {
        return bigDecimaleditor;
    }

    public BigDecimalConditionHandler getHandler() {
        return handler;
    }

    public JLabel getLabel() {
        return label;
    }

    public JComboBox getOperandComboBox() {
        return operandComboBox;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(BigDecimalConditionHandler handler) {
        BigDecimalConditionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBigDecimaleditor() {
        $objectMap.put("bigDecimaleditor", bigDecimaleditor = new NumberEditor(this));
        
        bigDecimaleditor.setName("bigDecimaleditor");
        bigDecimaleditor.setAutoPopup(false);
        bigDecimaleditor.setNumberPattern("([1-9]\\d*|0)(\\.\\d*)?");
        bigDecimaleditor.setProperty("value");
        bigDecimaleditor.setShowPopupButton(false);
        bigDecimaleditor.setShowReset(false);
        bigDecimaleditor.setUseFloat(true);
        bigDecimaleditor.setUseSign(false);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new BigDecimalConditionHandler(this));
    }

    protected void createLabel() {
        $objectMap.put("label", label = new JLabel());
        
        label.setName("label");
        label.setText(_(""));
    }

    protected void createOperandComboBox() {
        $objectMap.put("operandComboBox", operandComboBox = new JComboBox());
        
        operandComboBox.setName("operandComboBox");
        operandComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__operandComboBox"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(operandComboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(bigDecimaleditor, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 7 property setters
        $JButton0.setIcon(SwingUtil.createActionIcon("remove-condition"));
        operandComboBox.setModel(new DefaultComboBoxModel(AbstractBigDecimalCondition.Operand.values()));
        operandComboBox.setRenderer(new LabelListCellRenderer());
        operandComboBox.setSelectedItem(handler.getOperand());
        bigDecimaleditor.setBean(handler);
        bigDecimaleditor.setModel(handler.getValue());
        bigDecimaleditor.setModelType(BigDecimal.class);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("lima.filter.condition.delete"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createLabel();
        createOperandComboBox();
        createBigDecimaleditor();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}