package org.chorem.lima.ui;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ClosableTabHeader extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CAN_CLOSE = "canClose";
    public static final String PROPERTY_TITLE = "title";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLOSE_TAB_ENABLED = "closeTab.enabled";
    public static final String BINDING_LABEL_TEXT = "label.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Uu24TQRS9MbEd50EeBiuIREpIEBVrGhoS5YmiEBmIcAqEG8beiT3ReGcyM5ssKRCfwCdAT4NER4UoqCloEL+AEAUt4s6uX4EFWzFb7K7u3Hvm3HPPzKuvkNQK5g9IEDjK9wyrU2dn/eHD++UDWjG3qa4oJo1QED0DCUiUYMRtxbWBhVLBlucb5flNUZfCo15H9VIBhrV5wqmuUWoMzJ6uqGidL7aWlwLpqyZqi1Qc6ovv3xLP3WcvEwCBRHa2lbluVe1OBguQYK6BKdzpiOQ58apIQzGvinzHbGyTE63vkTo9hKeQLkBKEoVgBq703nKIEdYH0kB6cY+UOb1hYFGoqlOpCUXrDmd14vjM2eRC22XM2abEpUrKsDRlIGmY4dTAhOXlWK5OxLWdMlQhnkXArMl21oYQnBKvA4mTMuXYts0JHH2MIM5OwQZtRqYDz4IhFwPZU7kbvjHCayQruHxKchym0x5mW+2BEiSVj2ED06U/5/8Al6LJT/82eQsYrv7MZT+9/fJmqznucdz7Ymxqh1txDFIJSZVhduvxaNa+YTx/l8ilEmQ05Wj10MozMcSKjWUkh/tFwtpyZ5voGkIk05/fvc89/ngOElswzAVxt4jNvwMZU1OoguBuIFfXQkajx0P4nrDcDKSEJIc+ajS1zDzOPDpHDI607Bu6EqAQMzFCtNiUMx9+ZIuv15piDCC5S39NbwuSfASpaLfQ/Q1jx7p9RGrqu6Jt4DhLD9jvsGzYazZ8z8d1m9kXnrmu2UkIvxj49nM1ZG7/roVA2a5ANrzQF4KBQUMDPMTnl11iyFyZeS7aeuXseJNH1l4Vwtc5q3p1vAf6JHihCbiHRHeFZoZF562fplklwrgZj5HrAWOsLBTeSruEeYa6/yDUC1iaevauc/vkNLovKr7+P5RyeB2zE/Rpz8p3R+1m2J50l4ruU6WoW2ycnzMLZsO3+m5otQvCL9kYwflYCAAA";
    private static final Log log = LogFactory.getLog(ClosableTabHeader.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean canClose;
    protected JButton closeTab;
    protected JLabel label;
    protected String title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ClosableTabHeader $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ClosableTabHeader() {
        $initialize();
    }

    public ClosableTabHeader(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getCanClose() {
        return canClose;
    }

    public JButton getCloseTab() {
        return closeTab;
    }

    public JLabel getLabel() {
        return label;
    }

    public String getTitle() {
        return title;
    }

    public Boolean isCanClose() {
        return canClose !=null && canClose;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCanClose(Boolean canClose) {
        Boolean oldValue = this.canClose;
        this.canClose = canClose;
        firePropertyChange(PROPERTY_CAN_CLOSE, oldValue, canClose);
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        firePropertyChange(PROPERTY_TITLE, oldValue, title);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createCanClose() {
        $objectMap.put("canClose", canClose = true);
    }

    protected void createCloseTab() {
        $objectMap.put("closeTab", closeTab = new JButton());
        
        closeTab.setName("closeTab");
        closeTab.setBorderPainted(false);
        closeTab.setFocusPainted(false);
        closeTab.setHorizontalTextPosition(0);
        closeTab.setOpaque(true);
        closeTab.setVerticalAlignment(0);
        closeTab.setVerticalTextPosition(0);
    }

    protected void createLabel() {
        $objectMap.put("label", label = new JLabel());
        
        label.setName("label");
        if (label.getFont() != null) {
            label.setFont(label.getFont().deriveFont((float) 12));
        }
        label.setOpaque(false);
        label.setVerticalAlignment(0);
        label.setVerticalTextPosition(0);
    }

    protected void createTitle() {
        $objectMap.put("title", title = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(closeTab, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(2, 15, 0, 0), 0, 0));
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        closeTab.setIcon(SwingUtil.createActionIcon("closeTab"));
        closeTab.setPreferredSize(new Dimension(16,16));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createTitle();
        createCanClose();
        createLabel();
        createCloseTab();
        // inline creation of $Table0
        setName("$Table0");
        setOpaque(false);
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_TEXT, true ,"title") {
        
            @Override
            public void processDataBinding() {
                label.setText(_(getTitle()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLOSE_TAB_ENABLED, true ,"canClose") {
        
            @Override
            public void processDataBinding() {
                closeTab.setEnabled(isCanClose());
            }
        });
    }

}